/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.generators;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorMethodData;
import com.jetbrains.php.lang.intentions.generators.PhpConstructorGenerator;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpNameStyle;
import com.jetbrains.php.refactoring.PhpNameUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAccessorsGenerator {
    public static final String PHP_SETTER_TEMPLATE_NAME = "PHP Setter Method";
    public static final String PHP_GETTER_TEMPLATE_NAME = "PHP Getter Method";
    public static final String PHP_FLUENT_SETTER_TEMPLATE_NAME = "PHP Fluent Setter Method";
    private static final String PHP_SETTER_QUICK_TEMPLATE = "/**\n * @return %TYPE_HINT%\n */\npublic function set%NAME%($%PARAM_NAME%){}";
    private static final String PHP_GETTER_QUICK_TEMPLATE = "/**\n * @param %TYPE_HINT% $%PARAM_NAME%\n */\npublic function %GET_OR_IS%%NAME%(){}";
    @Nullable
    private final PhpClass myTargetClass;
    @NotNull
    private final Field myField;

    public PhpAccessorsGenerator(@NotNull Field field) {
        if (field == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(0);
        }
        this.myField = field;
        this.myTargetClass = field.getContainingClass();
    }

    public PhpAccessorsGenerator(@NotNull PhpClass targetClass, @NotNull Field field) {
        if (targetClass == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(1);
        }
        if (field == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(2);
        }
        this.myTargetClass = targetClass;
        this.myField = field;
    }

    @NotNull
    private static String getQuickModeTemplate(@NotNull String template, @NotNull Properties properties) {
        if (template == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(4);
        }
        String templateText = PHP_SETTER_TEMPLATE_NAME.equals(template) ? PHP_SETTER_QUICK_TEMPLATE : PHP_GETTER_QUICK_TEMPLATE;
        for (Object property : properties.keySet()) {
            String name;
            if (!(property instanceof String) || !templateText.contains(name = (String)property)) continue;
            templateText = templateText.replace("%" + property + "%", properties.getProperty(name));
        }
        String string = templateText;
        if (string == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean namesEqual(@NotNull String original2, @NotNull String expected) {
        if (original2 == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(6);
        }
        if (expected == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(7);
        }
        String adjustedOriginal = original2.indexOf(95) >= 0 ? original2.replace("_", "") : original2;
        String adjustedExpected = expected.indexOf(95) >= 0 ? expected.replace("_", "") : expected;
        return adjustedOriginal.equalsIgnoreCase(adjustedExpected);
    }

    public PhpAccessorMethodData @NotNull [] createGetters(boolean quickMode) {
        return this.createAccessors(PHP_GETTER_TEMPLATE_NAME, PhpAccessorMethodData.Type.GETTER, quickMode);
    }

    public PhpAccessorMethodData @NotNull [] createSetters(boolean isFluent, boolean quickMode) {
        String templateToUse = !this.myField.getModifier().isStatic() && isFluent ? PHP_FLUENT_SETTER_TEMPLATE_NAME : PHP_SETTER_TEMPLATE_NAME;
        return this.createAccessors(templateToUse, isFluent ? PhpAccessorMethodData.Type.FLUENT_SETTER : PhpAccessorMethodData.Type.SETTER, quickMode);
    }

    private PhpAccessorMethodData @NotNull [] createAccessors(@NotNull String templateName, @NotNull PhpAccessorMethodData.Type type, boolean quickMode) {
        if (templateName == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(8);
        }
        if (type == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(9);
        }
        ArrayList<PhpAccessorMethodData> accessors = new ArrayList<PhpAccessorMethodData>();
        PhpClass klass = this.myTargetClass;
        if (klass != null) {
            Properties attributes = this.getAccessMethodAttributes(PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)this.myField), templateName);
            String methodTemplate = quickMode ? PhpAccessorsGenerator.getQuickModeTemplate(templateName, attributes) : PhpCodeUtil.getCodeTemplate(templateName, attributes, this.myField.getProject());
            PhpClass dummyClass = PhpCodeUtil.createClassFromMethodTemplate(klass, klass.getProject(), methodTemplate);
            if (dummyClass != null) {
                PhpDocComment currDocComment = null;
                for (PsiElement child = dummyClass.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child instanceof PhpDocComment) {
                        currDocComment = (PhpDocComment)child;
                        continue;
                    }
                    if (!(child instanceof Method)) continue;
                    accessors.add(new PhpAccessorMethodData(this.myField, klass, currDocComment, (Method)child, type));
                    currDocComment = null;
                }
            }
        }
        PhpAccessorMethodData[] phpAccessorMethodDataArray = accessors.toArray(new PhpAccessorMethodData[0]);
        if (phpAccessorMethodDataArray == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(10);
        }
        return phpAccessorMethodDataArray;
    }

    public PhpAccessorMethodData @NotNull [] createAccessors(boolean fluentSetters, boolean quickMode) {
        PhpAccessorMethodData[] getters = this.createGetters(quickMode);
        PhpAccessorMethodData[] setters = this.createSetters(fluentSetters, quickMode);
        PhpAccessorMethodData[] result = new PhpAccessorMethodData[getters.length + setters.length];
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)this.myField.getContainingFile(), PhpCodeStyleSettings.class);
        if (settings.GETTERS_SETTERS_ORDER_STYLE == PhpCodeStyleSettings.GettersSettersOrderStyle.GETTERS_FIRST) {
            System.arraycopy(getters, 0, result, 0, getters.length);
            System.arraycopy(setters, 0, result, getters.length, setters.length);
        } else {
            System.arraycopy(setters, 0, result, 0, setters.length);
            System.arraycopy(getters, 0, result, setters.length, setters.length);
        }
        if (result == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(11);
        }
        return result;
    }

    private Properties getAccessMethodAttributes(@Nullable PhpPsiElement scopeForUseOperator, String templateName) {
        Properties attributes = new Properties();
        this.fillAttributes(scopeForUseOperator, attributes, templateName);
        this.addTypeHintsAndReturnType(attributes);
        return attributes;
    }

    private void fillAttributes(@Nullable PhpPsiElement scopeForUseOperator, Properties attributes, String templateName) {
        String fieldName = this.myField.getName();
        String typeHint = PhpCodeUtil.getTypeHint(this.myField, scopeForUseOperator);
        String paramName = fieldName;
        paramName = StringUtil.trimStart((String)paramName, (String)"_");
        attributes.setProperty("FIELD_NAME", fieldName);
        attributes.setProperty("PARAM_NAME", paramName);
        boolean hasIsPrefix = templateName.equals(PHP_GETTER_TEMPLATE_NAME) && fieldName.startsWith("is") && fieldName.length() > 2 && Character.isUpperCase(fieldName.toCharArray()[2]);
        attributes.setProperty("TYPE_HINT", typeHint);
        attributes.setProperty("STATIC", this.myField.getModifier().isStatic() ? "static" : "");
        PhpClass phpClass = this.myTargetClass;
        attributes.setProperty("CLASS_NAME", phpClass != null ? phpClass.getName() : "");
        attributes.setProperty("GET_OR_IS", "bool".equalsIgnoreCase(typeHint) ? (hasIsPrefix ? "" : "is") : "get");
        String name = fieldName;
        if (!"bool".equalsIgnoreCase(typeHint) || !hasIsPrefix) {
            name = this.getAccessorNamePart(fieldName);
        }
        attributes.setProperty("NAME", name);
    }

    @NotNull
    private String getAccessorNamePart(String fieldName) {
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)this.myField.getContainingFile(), PhpCodeStyleSettings.class);
        PhpNameStyle.Style style = settings.GETTERS_SETTERS_NAMING_STYLE;
        switch (style) {
            case CAMEL_CASE: {
                String string = PhpCodeUtil.camelCaps(fieldName);
                if (string == null) {
                    PhpAccessorsGenerator.$$$reportNull$$$0(12);
                }
                return string;
            }
            case SNAKE_CASE: {
                List<String> nameParts = PhpNameUtil.splitName(fieldName);
                String string = "_" + StreamEx.of(nameParts).without((Object)"_").map(StringUtil::decapitalize).joining((CharSequence)"_");
                if (string == null) {
                    PhpAccessorsGenerator.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        String string = fieldName;
        if (string == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(14);
        }
        return string;
    }

    private void addTypeHintsAndReturnType(Properties attributes) {
        String typeHint;
        boolean hasFeatureVoid;
        String typeHint2;
        Project project = this.myField.getProject();
        if (PhpLanguageFeature.SCALAR_TYPE_HINTS.isSupported(project) && !(typeHint2 = PhpConstructorGenerator.getTypeHint((PhpNamedElement)this.myField)).isEmpty()) {
            attributes.setProperty("SCALAR_TYPE_HINT", typeHint2);
        }
        if (hasFeatureVoid = PhpLanguageFeature.RETURN_VOID.isSupported(project)) {
            attributes.setProperty("VOID_RETURN_TYPE", "void");
        }
        if (PhpLanguageFeature.RETURN_TYPES.isSupported(project) && !(typeHint = PhpConstructorGenerator.getTypeHint((PhpNamedElement)this.myField)).isEmpty()) {
            attributes.setProperty("RETURN_TYPE", typeHint);
        }
    }

    private String @NotNull [] getPossibleAccessorMethodNames(@NotNull String templateName) {
        if (templateName == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(15);
        }
        HashSet<String> allNames = new HashSet<String>();
        String prefix = PHP_GETTER_TEMPLATE_NAME.equals(templateName) ? "get" : "set";
        allNames.add(StringUtil.toUpperCase((String)(prefix + this.myField.getName())));
        FileTemplate currTemplate = FileTemplateManager.getInstance((Project)this.myField.getProject()).getCodeTemplate(templateName);
        if (currTemplate != null) {
            this.collectMethodNamesFromTemplate(currTemplate.getText(), 0, this.myField, allNames, templateName);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(allNames);
        if (stringArray == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    private void collectMethodNamesFromTemplate(@NotNull String templateText, int startOffset, Field field, Set<String> result, String templateName) {
        int functionStart;
        if (templateText == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(17);
        }
        if ((functionStart = templateText.indexOf("function", startOffset)) < 0) {
            return;
        }
        int argListStart = templateText.indexOf(40, functionStart += "function".length());
        if (argListStart >= 0) {
            String methodName = templateText.substring(functionStart, argListStart).trim();
            Properties attributes = this.getAccessMethodAttributes(PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)field), templateName);
            for (String property : attributes.stringPropertyNames()) {
                String value = attributes.getProperty(property, "");
                methodName = methodName.replace("${" + property + "}", value);
            }
            methodName = StringUtil.toUpperCase((String)methodName.replace("_", ""));
            result.add(methodName);
        }
        this.collectMethodNamesFromTemplate(templateText, functionStart, field, result, templateName);
    }

    private Method @NotNull [] findFieldAccessMethods(String templateName) {
        PhpClass klass = this.myTargetClass;
        ArrayList<Method> accessMethods = new ArrayList<Method>();
        boolean isStatic = this.myField.getModifier().isStatic();
        if (klass != null) {
            Method[] methods;
            String[] expectedNames = this.getPossibleAccessorMethodNames(templateName);
            block0: for (Method m : methods = klass.getOwnMethods()) {
                if (m.getAccess().isPrivate() || m.getModifier().isStatic() != isStatic) continue;
                String methodName = m.getName();
                for (String expectedName : expectedNames) {
                    if (!PhpAccessorsGenerator.namesEqual(methodName, expectedName)) continue;
                    accessMethods.add(m);
                    continue block0;
                }
            }
        }
        Method[] methodArray = accessMethods.toArray(Method.EMPTY);
        if (methodArray == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(18);
        }
        return methodArray;
    }

    public Method @NotNull [] findGetters() {
        return this.findFieldAccessMethods(PHP_GETTER_TEMPLATE_NAME);
    }

    public Method @NotNull [] findSetters() {
        return this.findFieldAccessMethods(PHP_SETTER_TEMPLATE_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/generators/PhpAccessorsGenerator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/generators/PhpAccessorsGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickModeTemplate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createAccessors";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorNamePart";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleAccessorMethodNames";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findFieldAccessMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQuickModeTemplate";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "namesEqual";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAccessors";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleAccessorMethodNames";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectMethodNamesFromTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

