/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.generators;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.MethodImpl;
import org.jetbrains.annotations.NotNull;

public class PhpAccessorMethodData {
    private final PhpClass targetClass;
    private final PhpDocComment docComment;
    private final Method method;
    private final Type accessorType;
    private final Field classField;

    public PhpAccessorMethodData(Field field, PhpClass targetClass, PhpDocComment docComment, Method method, @NotNull Type accessorType) {
        if (accessorType == null) {
            PhpAccessorMethodData.$$$reportNull$$$0(0);
        }
        this.targetClass = targetClass;
        this.docComment = docComment;
        this.method = method;
        this.accessorType = accessorType;
        this.classField = field;
    }

    public PhpDocComment getDocComment() {
        return this.docComment;
    }

    public Method getMethod() {
        return this.method;
    }

    public PhpClass getTargetClass() {
        return this.targetClass;
    }

    public Type getAccessorType() {
        return this.accessorType;
    }

    public Field getClassField() {
        return this.classField;
    }

    public String getCompletionLookupString() {
        return PhpAccessorMethodData.getCompletionLookupString(this.method);
    }

    @NotNull
    public static String getCompletionLookupString(@NotNull Method method) {
        PhpPsiElement modifierList;
        if (method == null) {
            PhpAccessorMethodData.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        Object object = modifierList = method instanceof MethodImpl ? ((MethodImpl)method).getModifierList() : PhpPsiUtil.getChildOfType((PsiElement)method, PhpElementTypes.MODIFIER_LIST);
        if (modifierList != null) {
            sb.append(modifierList.getText()).append(' ');
        }
        sb.append("function ").append(method.getName()).append('(');
        boolean isFirst = true;
        for (Parameter parameter : method.getParameters()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append('$').append(parameter.getName());
        }
        sb.append(')');
        String string = sb.toString();
        if (string == null) {
            PhpAccessorMethodData.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/generators/PhpAccessorMethodData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/generators/PhpAccessorMethodData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionLookupString";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        GETTER,
        SETTER,
        FLUENT_SETTER;

    }
}

