/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.changeVisibility;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureHandler;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class PhpChangeVisibilityIntentionBase
extends BaseElementAtCaretIntentionAction {
    private static final String ALL_FIELDS_IN_LIST = "All fields";
    private static final String CURRENT_METHOD_TEXT = "Current Method only";
    private static boolean ourChangeAllFields;

    @TestOnly
    public static void setChangeAllFields(boolean changeAllFields) {
        ourChangeAllFields = changeAllFields;
    }

    @NotNull
    @NlsSafe
    protected abstract PhpModifier.Access getTargetAccess();

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PhpClassMember targetElement;
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(1);
        }
        if ((targetElement = PhpChangeVisibilityIntentionBase.getTargetElement(element)) == null) {
            return;
        }
        if (targetElement instanceof Method) {
            this.changeAccess(project, editor, (Method)targetElement);
        } else if (targetElement instanceof PhpPromotedFieldParameterImpl) {
            Runnable callback = () -> {
                PsiElement visibility = PhpPsiUtil.getChildOfType((PsiElement)targetElement, PhpTokenTypes.tsVISIBILITY_MODIFIERS);
                if (visibility == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{visibility.getContainingFile().getVirtualFile()})) {
                    return;
                }
                WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getFamilyName(), null, () -> visibility.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.tsVISIBILITY_MODIFIERS, String.format("function a(%s $a){}", this.getTargetAccess().toString()))), (PsiFile[])new PsiFile[0]);
            };
            if (!this.checkConflicts(project, ((Parameter)targetElement).getPromotedFieldAccess(), Collections.singleton((Field)targetElement), callback)) {
                callback.run();
            }
        } else if (targetElement instanceof Field) {
            PhpClassFieldsList fieldsList = (PhpClassFieldsList)PhpPsiUtil.getParentByCondition((PsiElement)targetElement, (Condition<? super PsiElement>)((Condition)PhpClassFieldsList.class::isInstance));
            if (fieldsList == null) {
                return;
            }
            Collection allFieldsInList = fieldsList.getFields();
            if (allFieldsInList.size() > 1) {
                this.changeAccessViaPopup(editor, (Field)targetElement, (PhpPsiElement)fieldsList, allFieldsInList);
            } else {
                this.changeAccess((Field)targetElement);
            }
        }
    }

    public void changeAccess(@NotNull Field element) {
        if (element == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(2);
        }
        PhpClassFieldsList fieldsList = (PhpClassFieldsList)PhpPsiUtil.getParentByCondition((PsiElement)element, (Condition<? super PsiElement>)((Condition)PhpClassFieldsList.class::isInstance));
        if (fieldsList == null) {
            return;
        }
        Collection allFieldsInList = fieldsList.getFields();
        this.changeAccess(element, (PhpPsiElement)fieldsList, allFieldsInList);
    }

    public void changeAccess(@NotNull Project project, @NotNull Editor editor, @NotNull Method currentMethod) {
        Method superMethod;
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(4);
        }
        if (currentMethod == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(5);
        }
        if (this.isAvailable((PhpClassMember)(superMethod = PhpChangeSignatureUsageSearcher.findDeepestSuperMethod(currentMethod, currentMethod.getMethodType(false) == Method.MethodType.CONSTRUCTOR)))) {
            String containingName = superMethod.getContainingClass() != null ? superMethod.getContainingClass().getName() : superMethod.getContainingFile().getName();
            JBPopupFactory.getInstance().createPopupChooserBuilder(Arrays.asList(CURRENT_METHOD_TEXT, "Method in parent " + containingName + " and its descendants")).setTitle(PhpBundle.message("target", new Object[0])).setMovable(true).setResizable(false).setRequestFocus(true).setItemChosenCallback(option -> this.doChangeAccess(project, editor, StringUtil.equals((CharSequence)CURRENT_METHOD_TEXT, (CharSequence)option) ? currentMethod : superMethod)).createPopup().showInBestPositionFor(editor);
        } else {
            this.doChangeAccess(project, editor, currentMethod);
        }
    }

    public void doChangeAccess(@NotNull Project project, @Nullable Editor editor, @NotNull Method method) {
        String errorMessage;
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(6);
        }
        if (method == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(7);
        }
        if (StringUtil.isNotEmpty((String)(errorMessage = PhpChangeSignatureHandler.refactorStatus(project, (PsiElement)method)))) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorMessage, (String)this.getFamilyName(), null);
            return;
        }
        new PhpChangeSignatureProcessor(project, new PhpMethodDescriptor((Function)method), this.getTargetAccess().toString(), method.getName(), PhpChangeVisibilityIntentionBase.getReturnType((Function)method), PhpChangeVisibilityIntentionBase.getParametersInfo(method), Collections.emptySet(), false, false).run();
    }

    private static PhpParameterInfo @NotNull [] getParametersInfo(@NotNull Method method) {
        if (method == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(8);
        }
        Parameter[] parameters = method.getParameters();
        PhpParameterInfo[] infos = new PhpParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            infos[i] = new PhpParameterInfo(i, parameters[i]);
        }
        if (infos == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(9);
        }
        return infos;
    }

    private void changeAccessViaPopup(@NotNull Editor editor, @NotNull Field selectedField, @NotNull PhpPsiElement fieldsList, @NotNull Collection<Field> allFieldsInList) {
        if (editor == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(10);
        }
        if (selectedField == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(11);
        }
        if (fieldsList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(12);
        }
        if (allFieldsInList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(13);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.changeAccess((Field)(!ourChangeAllFields ? selectedField : null), fieldsList, allFieldsInList);
            return;
        }
        SmartList highlighters = new SmartList();
        JBPopupFactory.getInstance().createPopupChooserBuilder(Arrays.asList("Only '" + selectedField.getName() + "'", ALL_FIELDS_IN_LIST)).setItemSelectedCallback(arg_0 -> PhpChangeVisibilityIntentionBase.lambda$changeAccessViaPopup$3(editor, selectedField, fieldsList, (List)highlighters, arg_0)).setTitle(PhpBundle.message("expressions", new Object[0])).setMovable(true).setResizable(false).setRequestFocus(true).setItemChosenCallback(option -> this.changeAccess((Field)(!StringUtil.equals((CharSequence)ALL_FIELDS_IN_LIST, (CharSequence)option) ? selectedField : null), fieldsList, allFieldsInList)).addListener(new JBPopupListener((List)highlighters){
            final /* synthetic */ List val$highlighters;
            {
                this.val$highlighters = list;
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpChangeVisibilityIntentionBase.dropHighlighters(this.val$highlighters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/lang/intentions/changeVisibility/PhpChangeVisibilityIntentionBase$1", "onClosed"));
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    private static void handleHighlighting(String option, Editor editor, PhpClassMember targetElement, PhpPsiElement classFieldsList, List<RangeHighlighter> highlighters) {
        if (option == null) {
            return;
        }
        PhpChangeVisibilityIntentionBase.dropHighlighters(highlighters);
        if (StringUtil.equals((CharSequence)ALL_FIELDS_IN_LIST, (CharSequence)option)) {
            highlighters.add(PhpChangeVisibilityIntentionBase.addRangeHighlighter(editor, (PsiElement)classFieldsList));
        } else {
            highlighters.add(PhpChangeVisibilityIntentionBase.addRangeHighlighter(editor, (PsiElement)targetElement));
        }
    }

    public static void dropHighlighters(@NotNull List<RangeHighlighter> highlighters) {
        if (highlighters == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(14);
        }
        highlighters.forEach(RangeMarker::dispose);
        highlighters.clear();
    }

    @NotNull
    public static RangeHighlighter addRangeHighlighter(Editor editor, PsiElement element) {
        TextRange range = element.getTextRange();
        RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, range.getStartOffset(), range.getEndOffset(), 5999, HighlighterTargetArea.EXACT_RANGE);
        if (rangeHighlighter == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(15);
        }
        return rangeHighlighter;
    }

    private void changeFieldListAccess(@NotNull PhpPsiElement fieldsList, @NotNull PhpModifier modifier) {
        if (fieldsList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(16);
        }
        if (modifier == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(17);
        }
        if (PhpPsiUtil.isOfType((PsiElement)fieldsList, PhpElementTypes.CLASS_CONSTANTS)) {
            this.changeConstantListAccess(fieldsList);
            return;
        }
        PsiElement modifierList = PhpPsiUtil.getChildOfType((PsiElement)fieldsList, PhpElementTypes.MODIFIER_LIST);
        if (modifierList instanceof PhpModifierList) {
            PhpModifierList changedModifierList = PhpPsiElementFactory.createModifierList(fieldsList.getProject(), PhpModifier.instance((PhpModifier.Access)this.getTargetAccess(), (PhpModifier.Abstractness)modifier.getAbstractness(), (PhpModifier.State)modifier.getState()));
            if (ReadonlyStatusHandler.ensureFilesWritable((Project)modifierList.getProject(), (VirtualFile[])new VirtualFile[]{modifierList.getContainingFile().getVirtualFile()})) {
                WriteCommandAction.runWriteCommandAction((Project)fieldsList.getProject(), (String)this.getFamilyName(), null, () -> modifierList.replace((PsiElement)changedModifierList), (PsiFile[])new PsiFile[0]);
            }
        }
    }

    private void changeConstantListAccess(@NotNull PhpPsiElement constantsList) {
        if (constantsList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(18);
        }
        Project project = constantsList.getProject();
        PhpModifierList modifierList = PhpPsiElementFactory.createModifierList(project, PhpModifier.instance((PhpModifier.Access)this.getTargetAccess(), (PhpModifier.Abstractness)PhpModifier.Abstractness.IMPLEMENTED, (PhpModifier.State)PhpModifier.State.DYNAMIC));
        PsiElement modifierListChild = PhpPsiUtil.getChildOfType((PsiElement)constantsList, PhpElementTypes.MODIFIER_LIST);
        PsiElement firstChild = PhpPsiUtil.getChildOfType((PsiElement)constantsList, PhpTokenTypes.kwCONST);
        if (ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{constantsList.getContainingFile().getVirtualFile()})) {
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getFamilyName(), null, () -> {
                if (modifierListChild != null) {
                    modifierListChild.replace((PsiElement)modifierList);
                } else if (firstChild != null) {
                    constantsList.addBefore((PsiElement)modifierList, firstChild);
                }
            }, (PsiFile[])new PsiFile[0]);
        }
    }

    private void changeAccess(@Nullable Field field, @NotNull PhpPsiElement fieldsList, @NotNull Collection<Field> allFieldsInList) {
        if (fieldsList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(19);
        }
        if (allFieldsInList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(20);
        }
        PhpModifier modifier = Objects.requireNonNull((Field)ContainerUtil.getFirstItem(allFieldsInList)).getModifier();
        Runnable callback = field != null && allFieldsInList.size() > 1 ? () -> this.changeModifierAccess(field, fieldsList) : () -> this.changeFieldListAccess(fieldsList, modifier);
        Project project = fieldsList.getProject();
        if (this.checkConflicts(project, modifier.getAccess(), field != null ? Collections.singleton(field) : allFieldsInList, callback)) {
            return;
        }
        callback.run();
    }

    private boolean checkConflicts(Project project, PhpModifier.Access access, Collection<Field> fields, Runnable changeCurrentFieldAccessCallback) {
        MultiMap<PsiElement, String> conflicts;
        return access.isWeakerThan(this.getTargetAccess()) && PhpChangeVisibilityIntentionBase.checkConflicts(project, conflicts = this.findConflicts(project, fields), changeCurrentFieldAccessCallback);
    }

    private static boolean checkConflicts(@NotNull Project project, MultiMap<PsiElement, String> conflicts, Runnable callback) {
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(21);
        }
        if (conflicts == null) {
            return true;
        }
        if (!conflicts.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException("");
            }
            ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts, callback);
            if (!conflictsDialog.showAndGet()) {
                return true;
            }
        }
        return false;
    }

    private void changeModifierAccess(@NotNull Field field, @NotNull PhpPsiElement fieldsList) {
        if (field == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(22);
        }
        if (fieldsList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(23);
        }
        PhpPsiElement changedFieldsList = this.copyFieldAndChangeAccess(field, field.getName(), PhpChangeVisibilityIntentionBase.getDefaultValueText(field));
        if (ReadonlyStatusHandler.ensureFilesWritable((Project)field.getProject(), (VirtualFile[])new VirtualFile[]{fieldsList.getContainingFile().getVirtualFile()})) {
            WriteCommandAction.runWriteCommandAction((Project)field.getProject(), (String)this.getFamilyName(), null, () -> {
                PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)field, PhpTokenTypes.opCOMMA);
                fieldsList.getParent().addAfter((PsiElement)changedFieldsList, (PsiElement)fieldsList);
            }, (PsiFile[])new PsiFile[0]);
        }
    }

    @Nullable
    public static String getDefaultValueText(@NotNull Field field) {
        if (field == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(24);
        }
        PsiElement defaultValue = PhpChangeVisibilityIntentionBase.hasDefaultValue(field) ? field.getDefaultValue() : null;
        return defaultValue != null ? defaultValue.getText() : null;
    }

    private static boolean hasDefaultValue(@NotNull Field field) {
        if (field == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(25);
        }
        return PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(field.getLastChild(), true), PhpTokenTypes.opASGN);
    }

    @NotNull
    private PhpPsiElement copyFieldAndChangeAccess(Field field, String fieldName, @Nullable String defaultValueText) {
        PhpModifier changedModifier = PhpModifier.instance((PhpModifier.Access)this.getTargetAccess(), (PhpModifier.Abstractness)field.getModifier().getAbstractness(), (PhpModifier.State)field.getModifier().getState());
        PhpPsiElement phpPsiElement = field.isConstant() ? PhpPsiElementFactory.createClassConstant(field.getProject(), changedModifier.getAccess(), fieldName, StringUtil.notNullize((String)defaultValueText)) : PhpPsiElementFactory.createClassField(field.getProject(), changedModifier, fieldName, defaultValueText, PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(field.getProject(), field.getDeclaredType(), (PsiElement)field));
        if (phpPsiElement == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(26);
        }
        return phpPsiElement;
    }

    @Nullable
    private MultiMap<PsiElement, String> findConflicts(Project project, Collection<Field> accessChangeCandidates) {
        MultiMap conflicts = new MultiMap();
        if (ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
            for (Field field : accessChangeCandidates) {
                PhpClass containingClass = field.getContainingClass();
                if (containingClass == null) continue;
                this.collectConflictsFromSuperMembers((MultiMap<PsiElement, String>)conflicts, field);
                this.collectConflictsFromReferences((MultiMap<PsiElement, String>)conflicts, field, containingClass);
            }
        }), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, project)) {
            return conflicts;
        }
        return null;
    }

    private void collectConflictsFromReferences(MultiMap<PsiElement, String> conflicts, Field field, PhpClass containingClass) {
        ReferencesSearch.search((PsiElement)field, (SearchScope)field.getUseScope()).forEach(ref -> {
            Collection<PhpClass> current;
            if (ref instanceof MemberReference && PhpAnnotatorVisitor.getStrictestAccessibleInContextReferenceAccess((MemberReference)ref, containingClass, current = PhpAnnotatorVisitor.resolveCurrentScope((MemberReference)ref, this.getTargetAccess())).isWeakerThan(this.getTargetAccess())) {
                this.putConflict(conflicts, field, ref.getElement(), (PhpClass)ContainerUtil.getFirstItem(current));
            }
            return true;
        });
    }

    private void collectConflictsFromSuperMembers(MultiMap<PsiElement, String> conflicts, Field field) {
        PhpClassHierarchyUtils.processSuperFields((Field)field, (baseField, subClass, baseClass) -> {
            if (baseField.getModifier().getAccess().isWeakerThan(this.getTargetAccess())) {
                this.putConflict(conflicts, field, (PsiElement)baseField, baseClass);
                return false;
            }
            return true;
        });
    }

    private void putConflict(MultiMap<PsiElement, String> conflicts, Field field, PsiElement usage, @Nullable PhpClass current) {
        String currentName = current != null ? current.getName() : usage.getContainingFile().getName();
        String conflictMessage = PhpBundle.message("change.signature.visibility.not.accessible", RefactoringUIUtil.getDescription((PsiElement)field, (boolean)true), this.getTargetAccess(), currentName);
        conflicts.putValue((Object)usage, (Object)conflictMessage);
    }

    @Nullable
    private static String getReturnType(@NotNull Function function) {
        PhpTypeDeclaration returnType;
        if (function == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(27);
        }
        return (returnType = function.getTypeDeclaration()) != null ? returnType.getText() : null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(28);
        }
        if (element == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(29);
        }
        PhpClassMember targetElement = PhpChangeVisibilityIntentionBase.getTargetElement(element);
        return this.isAvailable(targetElement);
    }

    @Contract(value="null->false")
    private boolean isAvailable(@Nullable PhpClassMember targetElement) {
        PhpClass containingClass;
        PhpClass phpClass = containingClass = targetElement != null ? targetElement.getContainingClass() : null;
        if (containingClass == null || containingClass.isInterface()) {
            return false;
        }
        if (!PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY.isSupported(targetElement.getProject()) && targetElement instanceof Field && ((Field)targetElement).isConstant()) {
            return false;
        }
        return PhpChangeVisibilityIntentionBase.getAccess(targetElement) != this.getTargetAccess();
    }

    @Nullable
    private static PhpModifier.Access getAccess(PhpClassMember targetElement) {
        PhpModifierList modifierList = (PhpModifierList)PhpPsiUtil.getChildByCondition((PsiElement)(targetElement instanceof Method ? targetElement : targetElement.getParent()), (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF);
        return modifierList != null && PhpPsiUtil.getChildOfType((PsiElement)modifierList, PhpTokenTypes.tsVISIBILITY_MODIFIERS) != null ? targetElement.getModifier().getAccess() : null;
    }

    @Nullable
    private static PhpClassMember getTargetElement(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(30);
        }
        if ((parent = element.getParent()) instanceof PhpModifierList) {
            parent = parent.getParent();
        }
        if (parent instanceof PhpDocMethod || parent instanceof PhpDocProperty) {
            return null;
        }
        if (parent instanceof PhpClassFieldsList) {
            return (PhpClassMember)ContainerUtil.getOnlyItem((Collection)((PhpClassFieldsList)parent).getFields());
        }
        return parent instanceof Method || parent instanceof Field ? (PhpClassMember)ObjectUtils.tryCast((Object)parent, PhpClassMember.class) : null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("make.01", this.getTargetAccess().toString());
        if (string == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(32);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void lambda$changeAccessViaPopup$3(Editor editor, Field selectedField, PhpPsiElement fieldsList, List highlighters, String option) {
        PhpChangeVisibilityIntentionBase.handleHighlighting(option, editor, (PhpClassMember)selectedField, fieldsList, highlighters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 15: 
            case 26: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 15: 
            case 26: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: 
            case 15: 
            case 26: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/changeVisibility/PhpChangeVisibilityIntentionBase";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedField";
                break;
            }
            case 12: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldsList";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFieldsInList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantsList";
                break;
            }
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/changeVisibility/PhpChangeVisibilityIntentionBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeHighlighter";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFieldAndChangeAccess";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "changeAccess";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doChangeAccess";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParametersInfo";
                break;
            }
            case 9: 
            case 15: 
            case 26: 
            case 31: 
            case 32: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "changeAccessViaPopup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dropHighlighters";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "changeFieldListAccess";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "changeConstantListAccess";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkConflicts";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "changeModifierAccess";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValueText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultValue";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTargetElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 15: 
            case 26: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

