/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.array;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.intentions.array.PhpConvertToTraditionalArraySyntaxIntention;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConvertToTraditionalListSyntaxIntention
extends PhpConvertToTraditionalArraySyntaxIntention {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpConvertToTraditionalListSyntaxIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpConvertToTraditionalListSyntaxIntention.$$$reportNull$$$0(1);
        }
        if (!PhpProjectConfigurationFacade.getInstance(element.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.LIST_ASSIGN)) {
            return false;
        }
        ArrayCreationExpression array = (ArrayCreationExpression)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)ArrayCreationExpression.INSTANCEOF);
        Object expr = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)MultiassignmentExpression.INSTANCEOF);
        if (expr != null && array != null && array.isShortSyntax() || this.insideArrayInForeach(element)) {
            this.setText(this.getText());
            return true;
        }
        return false;
    }

    private boolean insideArrayInForeach(PsiElement element) {
        Object foreach = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF);
        if (foreach == null) {
            return false;
        }
        int leftOffset = this.getLeftStartOffset((PsiElement)foreach);
        int rightOffset = this.getEndOffset((PsiElement)foreach);
        return leftOffset > -1 && rightOffset > -1 && TextRange.create((int)leftOffset, (int)rightOffset).contains(element.getTextRange());
    }

    @Override
    public void invokeWithStrategy(Project project, PsiElement element, boolean isRecursive) {
        PsiElement expression = PhpConvertToTraditionalListSyntaxIntention.getExpression(element);
        if (expression != null) {
            this.singleReplace(PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile()), PsiDocumentManager.getInstance((Project)project), expression);
        }
    }

    @Nullable
    private static PsiElement getExpression(@NotNull PsiElement element) {
        Object expression;
        if (element == null) {
            PhpConvertToTraditionalListSyntaxIntention.$$$reportNull$$$0(2);
        }
        if ((expression = PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)ArrayCreationExpression.INSTANCEOF)) == null) {
            expression = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF);
        }
        return expression;
    }

    @Override
    public String openStringToInsert() {
        return "list(";
    }

    @Override
    @NotNull
    public String getText() {
        String string = PhpConvertToTraditionalListSyntaxIntention.getIntentionText();
        if (string == null) {
            PhpConvertToTraditionalListSyntaxIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @IntentionName
    public static String getIntentionText() {
        return PhpBundle.message("intention.convert.to.traditional.syntax.list", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/array/PhpConvertToTraditionalListSyntaxIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/array/PhpConvertToTraditionalListSyntaxIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExpression";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

