/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.array;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.intentions.array.PhpConvertToShortArraySyntaxIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConvertToShortListSyntaxIntention
extends PhpConvertToShortArraySyntaxIntention {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpConvertToShortListSyntaxIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpConvertToShortListSyntaxIntention.$$$reportNull$$$0(1);
        }
        if (!PhpProjectConfigurationFacade.getInstance(element.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.LIST_ASSIGN)) {
            return false;
        }
        if (PhpConvertToShortListSyntaxIntention.isAvailableOnArrayExpression(element) && this.insideList(element)) {
            this.setText(this.getText());
            return true;
        }
        return false;
    }

    public static boolean isAvailableOnArrayExpression(PsiElement element) {
        PsiElement expression = PhpConvertToShortListSyntaxIntention.getExpression(element);
        if (expression != null && !PhpConvertToShortListSyntaxIntention.embeddedLists(expression) && PhpConvertToShortListSyntaxIntention.listCall(expression)) {
            return PhpPsiUtil.isOfType(expression, PhpElementTypes.FOREACH) || PhpPsiUtil.isOfType(expression.getParent(), PhpElementTypes.STATEMENT, PhpElementTypes.FOREACH);
        }
        return false;
    }

    private static boolean embeddedLists(PsiElement expression) {
        int count = 0;
        for (PsiElement sibling = expression.getFirstChild(); sibling != null; sibling = sibling.getNextSibling()) {
            if (!PhpPsiUtil.isOfType(sibling, PhpTokenTypes.kwLIST) && !PhpPsiUtil.isOfType(sibling.getFirstChild(), PhpTokenTypes.kwLIST)) continue;
            ++count;
        }
        return count > 1;
    }

    private static boolean listCall(PsiElement expression) {
        for (PsiElement sibling = expression.getFirstChild(); sibling != null; sibling = sibling.getNextSibling()) {
            if (!PhpPsiUtil.isOfType(sibling, PhpTokenTypes.kwLIST) || !PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace(sibling, true), PhpTokenTypes.chLPAREN)) continue;
            return true;
        }
        return false;
    }

    private boolean insideList(@NotNull PsiElement element) {
        if (element == null) {
            PhpConvertToShortListSyntaxIntention.$$$reportNull$$$0(2);
        }
        PsiElement expression = PhpConvertToShortListSyntaxIntention.getExpression(element);
        int leftOffset = this.getLeftStartOffset(expression);
        int rightOffset = this.getEndOffset(expression);
        return leftOffset > -1 && rightOffset > -1 && TextRange.create((int)leftOffset, (int)rightOffset).contains(element.getTextRange());
    }

    @Override
    public int getLeftStartOffset(@Nullable PsiElement expression) {
        PsiElement firstChild;
        if (expression != null && (firstChild = PhpPsiUtil.getChildOfType(expression, PhpTokenTypes.kwLIST)) != null) {
            return firstChild.getTextRange().getStartOffset();
        }
        return -1;
    }

    @Override
    public int getEndOffset(@Nullable PsiElement expression) {
        Object lastChild;
        PsiElement list;
        if (expression != null && (list = PhpPsiUtil.getChildOfType(expression, PhpTokenTypes.kwLIST)) != null && (lastChild = PhpPsiUtil.getNextSiblingByCondition(list, (Condition<? super PsiElement>)((Condition)i -> PhpPsiUtil.isOfType(i, PhpTokenTypes.chRPAREN)))) != null) {
            return lastChild.getTextRange().getStartOffset();
        }
        return -1;
    }

    @Override
    public int getRightStartOffset(PsiElement expression) {
        Object lastChild;
        PsiElement list = PhpPsiUtil.getChildOfType(expression, PhpTokenTypes.kwLIST);
        if (list != null && (lastChild = PhpPsiUtil.getNextSiblingByCondition(list, (Condition<? super PsiElement>)((Condition)i -> PhpPsiUtil.isOfType(i, PhpTokenTypes.chLPAREN)))) != null) {
            return lastChild.getTextRange().getEndOffset();
        }
        return -1;
    }

    @Override
    public void invokeWithStrategy(Project project, PsiElement element, boolean isRecursive) {
        PsiElement expression = PhpConvertToShortListSyntaxIntention.getExpression(element);
        if (expression != null) {
            this.singleReplace(PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile()), PsiDocumentManager.getInstance((Project)project), expression);
        }
    }

    @Nullable
    public static PsiElement getExpression(@NotNull PsiElement element) {
        Object expression;
        if (element == null) {
            PhpConvertToShortListSyntaxIntention.$$$reportNull$$$0(3);
        }
        if ((expression = PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)MultiassignmentExpression.INSTANCEOF)) == null) {
            expression = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF);
        }
        return expression;
    }

    @Override
    @NotNull
    public String getText() {
        String string = PhpConvertToShortListSyntaxIntention.getIntentionText();
        if (string == null) {
            PhpConvertToShortListSyntaxIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @IntentionName
    public static String getIntentionText() {
        return PhpBundle.message("intention.convert.to.short.syntax.list", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/array/PhpConvertToShortListSyntaxIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/array/PhpConvertToShortListSyntaxIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "insideList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExpression";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

