/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.array;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.intentions.array.PhpConvertArraySyntaxBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import org.jetbrains.annotations.NotNull;

public class PhpConvertToShortArraySyntaxIntention
extends PhpConvertArraySyntaxBase {
    public static final String OPEN_SQUARE_BRACKET = "[";
    public static final String CLOSE_SQUARE_BRACKET = "]";

    @Override
    boolean isAvailable(PsiElement expression) {
        PsiFile file = expression.getContainingFile();
        if (!(file instanceof PhpFile)) {
            return false;
        }
        PhpLanguageLevel preferableLanguageLevel = PhpProjectConfigurationFacade.getInstance(expression.getProject()).getLanguageLevel();
        return expression instanceof ArrayCreationExpression && PhpConvertToShortArraySyntaxIntention.isAvailableOnArrayExpression(preferableLanguageLevel, (ArrayCreationExpression)expression);
    }

    public static boolean isAvailableOnArrayExpression(PhpLanguageLevel preferableLanguageLevel, ArrayCreationExpression expression) {
        return preferableLanguageLevel.hasFeature(PhpLanguageFeature.SHORT_ARRAY_SYNTAX) && !expression.isShortSyntax() && PhpConvertToShortArraySyntaxIntention.isValidLongArrayExpression(expression);
    }

    protected static boolean isValidLongArrayExpression(ArrayCreationExpression expression) {
        PsiElement firstChild = expression.getFirstChild();
        return PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.kwARRAY) && PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace(firstChild, true), PhpTokenTypes.chLPAREN) && PhpPsiUtil.isOfType(expression.getLastChild(), PhpTokenTypes.chRPAREN);
    }

    @Override
    public int getLeftStartOffset(PsiElement expression) {
        PsiElement firstChild = expression.getFirstChild();
        if (PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.kwARRAY)) {
            return firstChild.getTextRange().getStartOffset();
        }
        return -1;
    }

    @Override
    public int getRightStartOffset(PsiElement expression) {
        PsiElement firstChild = expression.getFirstChild();
        PsiElement secondChild = PhpPsiUtil.getNextSiblingIgnoreWhitespace(firstChild, true);
        if (PhpPsiUtil.isOfType(secondChild, PhpTokenTypes.chLPAREN)) {
            return secondChild.getTextRange().getEndOffset();
        }
        return -1;
    }

    @Override
    public int getEndOffset(PsiElement expression) {
        PsiElement lastChild = expression.getLastChild();
        if (PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.chRPAREN)) {
            return lastChild.getTextRange().getStartOffset();
        }
        return -1;
    }

    @Override
    public String openStringToInsert() {
        return OPEN_SQUARE_BRACKET;
    }

    @Override
    String closeStringToInsert() {
        return CLOSE_SQUARE_BRACKET;
    }

    @NotNull
    public String getText() {
        String string = PhpConvertToShortArraySyntaxIntention.getTitle();
        if (string == null) {
            PhpConvertToShortArraySyntaxIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionName
    public static String getTitle() {
        return PhpBundle.message("intention.convert.to.short.syntax", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/intentions/array/PhpConvertToShortArraySyntaxIntention", "getText"));
    }
}

