/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.formatter.PhpFormatterUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Variable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariableAddPhpDocCommentIntention
extends IntentionAndQuickFixAction {
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String PHP_DOC_TEMPLATE_VAR = "/** @var TYPE_NAME $<var> */";

    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpVariableAddPhpDocCommentIntention.getTitle();
        if (string == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
        if (project == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(2);
        }
        Variable variable = PhpVariableAddPhpDocCommentIntention.findVariable(file, editor);
        PhpVariableAddPhpDocCommentIntention.insertVarPhpDocComment(project, editor, (PsiElement)variable, variable.getName());
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
        if (project == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(3);
        }
        return PhpVariableAddPhpDocCommentIntention.findVariable(file, editor) != null;
    }

    @Nullable
    public static Variable findVariable(@NotNull PsiFile file, @Nullable Editor editor) {
        if (file == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            return null;
        }
        if (!file.getManager().isInProject((PsiElement)file)) {
            return null;
        }
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        return (Variable)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)position, Variable.class, (boolean)false);
    }

    public static void insertVarPhpDocComment(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement anchor, @NotNull String variableName) {
        if (project == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(6);
        }
        if (anchor == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(7);
        }
        if (variableName == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(8);
        }
        String actualCode = PHP_DOC_TEMPLATE_VAR.replace("<var>", variableName);
        ASTNode statementNode = PhpFormatterUtil.getBoundStatement(anchor.getNode());
        if (statementNode == null) {
            return;
        }
        PsiElement statement = statementNode.getPsi();
        PsiElement parent = statement.getParent();
        if (parent != null) {
            PhpDocComment elementToInsert = PhpPsiElementFactory.createFromText(project, PhpDocComment.class, actualCode);
            PsiWhiteSpace newLine = PhpPsiElementFactory.createFromText(project, PsiWhiteSpace.class, "");
            if (elementToInsert != null) {
                PsiDocumentManager manager;
                Document document;
                PsiElement inserted = parent.addBefore((PsiElement)elementToInsert, statement);
                if (newLine != null) {
                    parent.addAfter((PsiElement)newLine, inserted);
                }
                if ((document = (manager = PsiDocumentManager.getInstance((Project)project)).getDocument(parent.getContainingFile())) != null) {
                    manager.doPostponedOperationsAndUnblockDocument(document);
                }
                String selection = TYPE_NAME;
                int selectionPos = inserted.getText().indexOf(TYPE_NAME);
                if (selectionPos >= 0) {
                    int selectionStart = inserted.getTextOffset() + selectionPos;
                    editor.getCaretModel().moveToOffset(selectionStart);
                    editor.getCaretModel().moveCaretRelatively(TYPE_NAME.length(), 0, true, false, false);
                }
                int line = editor.getDocument().getLineNumber(inserted.getTextOffset());
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(editor.getDocument(), editor.getDocument().getLineStartOffset(line));
            }
        }
    }

    @IntentionFamilyName
    public static String getTitle() {
        return PhpBundle.message("intention.variable.add.phpdoc.comment.family.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpVariableAddPhpDocCommentIntention";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpVariableAddPhpDocCommentIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findVariable";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "insertVarPhpDocComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

