/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpStatementUtils {
    private PhpStatementUtils() {
    }

    @Contract(value="null -> true")
    public static boolean statementMayCompleteNormally(Statement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof PhpBreak || statement instanceof PhpContinue || statement instanceof PhpReturn || statement.getFirstChild() instanceof PhpThrowExpression) {
            return false;
        }
        if (statement instanceof PhpExpression) {
            return true;
        }
        if (statement instanceof For) {
            return PhpStatementUtils.forStatementMayReturnNormally((For)statement);
        }
        if (statement instanceof ForeachStatement) {
            return true;
        }
        if (statement instanceof While) {
            return PhpStatementUtils.whileStatementMayReturnNormally((While)statement);
        }
        if (statement instanceof DoWhile) {
            return PhpStatementUtils.doWhileStatementMayReturnNormally((DoWhile)statement);
        }
        if (statement instanceof GroupStatement) {
            return PhpStatementUtils.groupStatementMayCompleteNormally((GroupStatement)statement);
        }
        if (statement instanceof If) {
            return PhpStatementUtils.ifStatementMayReturnNormally((If)statement);
        }
        if (statement instanceof Try) {
            return PhpStatementUtils.tryStatementMayReturnNormally((Try)statement);
        }
        if (statement instanceof PhpSwitch) {
            return PhpStatementUtils.switchStatementMayReturnNormally((PhpSwitch)statement);
        }
        return true;
    }

    private static boolean forStatementMayReturnNormally(@NotNull For loopStatement) {
        if (loopStatement == null) {
            PhpStatementUtils.$$$reportNull$$$0(0);
        }
        if (PhpStatementUtils.statementIsBreakTarget((Statement)loopStatement)) {
            return true;
        }
        PhpPsiElement[] conditionalExpressions = loopStatement.getConditionalExpressions();
        int length = conditionalExpressions.length;
        return length != 0 && (length > 1 || !PhpLangUtil.isTrue((PsiElement)conditionalExpressions[0]));
    }

    private static boolean whileStatementMayReturnNormally(@NotNull While loopStatement) {
        PhpPsiElement condition;
        if (loopStatement == null) {
            PhpStatementUtils.$$$reportNull$$$0(1);
        }
        return !PhpLangUtil.isTrue((PsiElement)(condition = loopStatement.getCondition())) || PhpStatementUtils.statementIsBreakTarget((Statement)loopStatement);
    }

    private static boolean doWhileStatementMayReturnNormally(@NotNull DoWhile loopStatement) {
        if (loopStatement == null) {
            PhpStatementUtils.$$$reportNull$$$0(2);
        }
        Statement statement = loopStatement.getStatement();
        PhpPsiElement condition = loopStatement.getCondition();
        return PhpStatementUtils.statementMayCompleteNormally(statement) && !PhpLangUtil.isTrue((PsiElement)condition) || PhpStatementUtils.statementIsBreakTarget((Statement)loopStatement);
    }

    private static boolean groupStatementMayCompleteNormally(@Nullable GroupStatement groupStatement) {
        if (groupStatement != null) {
            for (PsiElement statement : groupStatement.statements()) {
                if (!(statement instanceof Statement) || PhpStatementUtils.statementMayCompleteNormally((Statement)statement)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean ifStatementMayReturnNormally(@NotNull If ifStatement) {
        ElseIf[] elseIfBranches;
        if (ifStatement == null) {
            PhpStatementUtils.$$$reportNull$$$0(3);
        }
        if (PhpStatementUtils.statementMayCompleteNormally(ifStatement.getStatement())) {
            return true;
        }
        for (ElseIf elseIfBranch : elseIfBranches = ifStatement.getElseIfBranches()) {
            if (!PhpStatementUtils.statementMayCompleteNormally(elseIfBranch.getStatement())) continue;
            return true;
        }
        Else elseBranch = ifStatement.getElseBranch();
        return elseBranch == null || PhpStatementUtils.statementMayCompleteNormally((Statement)elseBranch.getStatement());
    }

    private static boolean tryStatementMayReturnNormally(@NotNull Try tryStatement2) {
        Catch[] catchClauses;
        Finally finallyBlock;
        if (tryStatement2 == null) {
            PhpStatementUtils.$$$reportNull$$$0(4);
        }
        if ((finallyBlock = tryStatement2.getFinallyBlock()) != null && !PhpStatementUtils.statementMayCompleteNormally(finallyBlock.getStatement())) {
            return false;
        }
        Statement tryBlock = tryStatement2.getStatement();
        if (PhpStatementUtils.statementMayCompleteNormally(tryBlock)) {
            return true;
        }
        for (Catch catchClause : catchClauses = tryStatement2.getCatchClauses()) {
            if (!PhpStatementUtils.statementMayCompleteNormally(catchClause.getStatement())) continue;
            return true;
        }
        return false;
    }

    private static boolean switchStatementMayReturnNormally(@NotNull PhpSwitch switchStatement) {
        if (switchStatement == null) {
            PhpStatementUtils.$$$reportNull$$$0(5);
        }
        if (PhpStatementUtils.statementIsBreakTarget((Statement)switchStatement)) {
            return true;
        }
        Object[] caseClauses = switchStatement.getAllCases();
        if (caseClauses.length == 0) {
            return true;
        }
        PhpCase defaultCase = switchStatement.getDefaultCase();
        if (defaultCase == null) {
            return true;
        }
        for (int i = ArrayUtil.find((Object[])caseClauses, (Object)defaultCase); i < caseClauses.length; ++i) {
            Object caseClause = caseClauses[i];
            if (PhpStatementUtils.statementMayCompleteNormally(caseClause.getStatement())) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull Statement statement) {
        if (statement == null) {
            PhpStatementUtils.$$$reportNull$$$0(6);
        }
        BreakFinder breakFinder = new BreakFinder(statement);
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpStatementUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forStatementMayReturnNormally";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "whileStatementMayReturnNormally";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doWhileStatementMayReturnNormally";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "ifStatementMayReturnNormally";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tryStatementMayReturnNormally";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "switchStatementMayReturnNormally";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "statementIsBreakTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class BreakFinder
    extends PhpRecursiveElementVisitor {
        private final Statement target;
        private boolean found;

        private BreakFinder(@NotNull Statement target) {
            if (target == null) {
                BreakFinder.$$$reportNull$$$0(0);
            }
            this.target = target;
        }

        public boolean breakFound() {
            return this.found;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                BreakFinder.$$$reportNull$$$0(1);
            }
            if (!this.found) {
                super.visitElement(element);
            }
        }

        public void visitPhpBreak(PhpBreak breakStatement) {
            Statement prevStatement;
            PsiElement exitedStatement = BreakFinder.getStatementToBreak(breakStatement);
            if (exitedStatement != null && PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.target, (boolean)false) && ((prevStatement = (Statement)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)breakStatement, (Condition<? super PsiElement>)Statement.INSTANCEOF)) == null || PhpStatementUtils.statementMayCompleteNormally(prevStatement))) {
                this.found = true;
            }
        }

        private static PsiElement getStatementToBreak(PhpBreak breakStatement) {
            PsiElement label = breakStatement.getArgument();
            Integer identifier = label != null ? PhpCodeInsightUtil.toInt(label) : null;
            return PhpPsiUtil.getLoopStatement((PhpPsiElement)breakStatement, identifier != null ? identifier : 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpStatementUtils$BreakFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

