/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import org.jetbrains.annotations.NotNull;

public class PhpSmartLineSplitIntention
extends PsiElementBaseIntentionAction {
    static final char SINGLE_QUOTE = '\'';
    static final char DOUBLE_QUOTE = '\"';

    @NotNull
    public String getFamilyName() {
        String string = PhpSmartLineSplitIntention.getTitle();
        if (string == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PhpSmartLineSplitIntention.getTitle();
        if (string == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        ASTNode node;
        if (project == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(3);
        }
        char newQuote = !PhpPsiUtil.isOfType(node = (element = PhpSmartLineSplitIntention.getInnerStringElement(element)).getNode(), PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE) && !PhpPsiUtil.isOfType(node, PhpTokenTypes.chRSINGLE_QUOTE) ? (char)'\"' : '\'';
        String binary = "";
        Document document = editor.getDocument();
        TextRange range = element.getTextRange();
        CaretModel model = editor.getCaretModel();
        int position = model.getOffset();
        PsiElement outerString = element.getParent();
        if (outerString.getText().startsWith("b")) {
            binary = "b";
        }
        if (outerString.getText().startsWith("B")) {
            binary = "B";
        }
        String toInsert = newQuote + " . " + binary + newQuote;
        document.insertString(position, (CharSequence)toInsert);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile file = element.getContainingFile();
        psiDocumentManager.commitDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)project).reformatText(file, range.getStartOffset(), range.getEndOffset() + toInsert.length());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(5);
        }
        if (editor.getSelectionModel().hasSelection()) {
            return false;
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        PsiElement innerString = PhpSmartLineSplitIntention.getInnerStringElement(element);
        if (innerString.getNode().getTreeParent() == null || !PhpLanguageFeature.CONSTANT_SCALAR_EXPRESSIONS.isSupported(project) && PhpSmartLineSplitIntention.isClassField(innerString.getNode())) {
            return false;
        }
        if (PhpSmartLineSplitIntention.isStringLiteral(innerString.getNode())) {
            return true;
        }
        return innerString.getNode().getStartOffset() == editor.getCaretModel().getOffset() && !PhpSmartLineSplitIntention.prevSiblingIsLeftBrace(innerString.getNode()) && !PhpSmartLineSplitIntention.nextSiblingIsRightBrace(innerString.getNode()) && !PhpPsiUtil.isOfType(element, PhpTokenTypes.chLSINGLE_QUOTE) && !PhpPsiUtil.isOfType(element, PhpTokenTypes.chLDOUBLE_QUOTE);
    }

    private static boolean isClassField(ASTNode node) {
        ASTNode parent = node.getTreeParent().getTreeParent();
        return parent != null && (parent.getElementType() == PhpStubElementTypes.CLASS_FIELD || parent.getElementType() == PhpStubElementTypes.CLASS_CONST);
    }

    private static PsiElement getInnerStringElement(PsiElement element) {
        PsiElement innerString = element;
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE)) {
            while (innerString.getNode().getTreeParent() != null && innerString.getNode().getTreeParent().getElementType() != PhpElementTypes.STRING) {
                innerString = innerString.getParent();
            }
        }
        return innerString;
    }

    private static boolean isStringLiteral(ASTNode node) {
        return node.getElementType() == PhpTokenTypes.STRING_LITERAL || node.getElementType() == PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE;
    }

    private static boolean nextSiblingIsRightBrace(ASTNode node) {
        if (node.getElementType() == PhpTokenTypes.chRBRACE) {
            return true;
        }
        ASTNode nextSibling = node.getTreeNext();
        if (nextSibling != null) {
            return nextSibling.getElementType() == PhpTokenTypes.chRBRACE;
        }
        return false;
    }

    private static boolean prevSiblingIsLeftBrace(ASTNode node) {
        ASTNode prevSibling = node.getTreePrev();
        if (prevSibling != null) {
            return prevSibling.getElementType() == PhpTokenTypes.chLBRACE;
        }
        return false;
    }

    @IntentionFamilyName
    public static String getTitle() {
        return PhpBundle.message("intention.line.split", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpSmartLineSplitIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpSmartLineSplitIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

