/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.intentions.PhpImportClassIntention;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpChangeVisibilityIntentionBase;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseListImpl;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.PhpNameUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReplaceWithAliasIntention
extends BaseElementAtCaretIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PhpReference reference;
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(1);
        }
        if ((reference = PhpReplaceWithAliasIntention.getReference(element)) != null) {
            PhpReplaceWithAliasIntention.replaceWithAlias(project, editor, reference, true);
        }
    }

    public static void replaceWithAlias(Project project, Editor editor, PhpReference reference, boolean runRename) {
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference);
        if (scope == null) {
            return;
        }
        PsiFile file = reference.getContainingFile();
        Collection<PhpUse> uses = PhpReplaceWithAliasIntention.resolveUses(reference);
        PhpUse useDirectly = PhpReplaceWithAliasIntention.getUseDirectly((PsiElement)reference);
        PhpUse targetUseWithoutAlias = useDirectly != null ? useDirectly : (!PhpCodeInsightUtil.isFullyQualified(reference) ? (PhpUse)ContainerUtil.find(uses, use -> use.getAliasName() == null) : null);
        List<PsiReference> references = PhpReplaceWithAliasIntention.getReferences(scope, reference, targetUseWithoutAlias);
        List existingAliases = ContainerUtil.filter(uses, use -> use.getAliasName() != null);
        if (!existingAliases.isEmpty()) {
            if (existingAliases.size() > 1) {
                PhpReplaceWithAliasIntention.chooseFromExistingAliasesAndReplaceReferences(project, editor, scope, references, existingAliases);
            } else {
                PhpReplaceWithAliasIntention.replaceReferences(project, scope, references, ((PhpUse)existingAliases.get(0)).getName());
            }
        } else {
            PhpUse use2 = PhpReplaceWithAliasIntention.updateUseAndReplaceReferences(project, scope, reference, targetUseWithoutAlias, references);
            if (runRename) {
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                PhpReplaceWithAliasIntention.runRename(project, editor, (PsiElement)useDirectly, file, use2);
            }
        }
    }

    @Nullable
    private static PhpUse updateUseAndReplaceReferences(@NotNull Project project, PhpPsiElement scope, PhpReference targetReference, PhpUse targetUseWithoutAlias, Collection<PsiReference> references) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(2);
        }
        PhpGroupUseElement.PhpUseKeyword keyword = targetUseWithoutAlias != null ? PhpReplaceWithAliasIntention.getUseKeyword(PhpGroupUseElement.getKeyword(targetUseWithoutAlias, PhpUseImpl.getUseList((PsiElement)targetUseWithoutAlias))) : PhpReplaceWithAliasIntention.getUseKeyword(targetReference);
        String newAliasName = PhpReplaceWithAliasIntention.createUniqueClassAliasName(scope, targetReference.getName(), keyword);
        if (ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{scope.getContainingFile().getVirtualFile()})) {
            return (PhpUse)ApplicationManager.getApplication().runWriteAction(() -> {
                String referenceFQN = targetReference.getFQN();
                PhpReplaceWithAliasIntention.replaceReferences(references, newAliasName, project);
                return PhpReplaceWithAliasIntention.updateImport(project, targetUseWithoutAlias, scope, keyword, newAliasName, referenceFQN);
            });
        }
        return null;
    }

    private static void chooseFromExistingAliasesAndReplaceReferences(@NotNull Project project, Editor editor, PhpPsiElement scope, Collection<PsiReference> references, List<PhpUse> existingAliases) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(3);
        }
        Map usesByName = ContainerUtil.map2Map(existingAliases, use -> Pair.create((Object)use.getName(), (Object)use));
        SmartList highlighters = new SmartList();
        JBPopupFactory.getInstance().createPopupChooserBuilder(ContainerUtil.map(existingAliases, use -> use.getName())).setTitle(PhpBundle.message("choose.an.alias.to.use", new Object[0])).setMovable(true).setResizable(false).setRequestFocus(true).setSelectionMode(0).setItemSelectedCallback(arg_0 -> PhpReplaceWithAliasIntention.lambda$chooseFromExistingAliasesAndReplaceReferences$5((List)highlighters, usesByName, editor, arg_0)).setItemChosenCallback(name -> CommandProcessor.getInstance().executeCommand(project, () -> PhpReplaceWithAliasIntention.replaceReferences(project, scope, references, name), PhpImportClassIntention.getNameText(), null)).addListener(new JBPopupListener((List)highlighters){
            final /* synthetic */ List val$highlighters;
            {
                this.val$highlighters = list;
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpChangeVisibilityIntentionBase.dropHighlighters(this.val$highlighters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/lang/intentions/PhpReplaceWithAliasIntention$1", "onClosed"));
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    private static void replaceReferences(@NotNull Project project, PhpPsiElement scope, Collection<PsiReference> references, String name) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(4);
        }
        if (ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{scope.getContainingFile().getVirtualFile()})) {
            ApplicationManager.getApplication().runWriteAction(() -> PhpReplaceWithAliasIntention.replaceReferences(references, name, project));
        }
    }

    @NotNull
    private static List<PsiReference> getReferences(PhpPsiElement scope, PhpReference reference, PhpUse useWithoutAlias) {
        List list = useWithoutAlias != null ? ContainerUtil.filter(PhpCodeInsightUtil.collectReferencesToAlias(useWithoutAlias), r -> PhpTargetElementEvaluator.getElementByReference(r) == null) : ContainerUtil.filter(PhpReplaceWithAliasIntention.getReferences(reference, scope), r -> r instanceof PhpReference && PhpCodeInsightUtil.isFullyQualified(reference) == PhpCodeInsightUtil.isFullyQualified((PhpReference)r));
        if (list == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static void runRename(@NotNull Project project, @NotNull Editor editor, @Nullable PsiElement useDirectly, PsiFile file, @Nullable PhpUse replacedUseWithAlias) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(7);
        }
        if (replacedUseWithAlias != null && useDirectly != null) {
            ASTNode node = replacedUseWithAlias.getNameNode();
            if (node == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(node.getStartOffset() + node.getTextLength());
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        RenameHandler handler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
        if (handler == null) {
            return;
        }
        handler.invoke(project, editor, file, dataContext);
    }

    @Nullable
    private static PhpUse updateImport(Project project, @Nullable PhpUse use, @NotNull PhpPsiElement scope, PhpGroupUseElement.PhpUseKeyword keyword, String newAliasName, String referenceFQN) {
        if (scope == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(8);
        }
        if (use != null) {
            return (PhpUse)use.replace((PsiElement)PhpReplaceWithAliasIntention.createUseWithAlias(project, use, newAliasName));
        }
        PhpAliasImporter.insertUseStatementWithKeyword(keyword.getValue(), StringUtil.notNullize((String)referenceFQN), newAliasName, scope);
        return null;
    }

    private static void replaceReferences(Collection<? extends PsiReference> references, String uniqueAliasName, Project project) {
        for (PsiReference psiReference : references) {
            if (!PhpCodeInsightUtil.canBeReferenceToUse(psiReference.getElement())) continue;
            PhpReplaceWithAliasIntention.replaceReference(project, psiReference, uniqueAliasName);
        }
    }

    @NotNull
    private static Collection<PhpReference> getReferences(@NotNull PhpReference reference, @NotNull PhpPsiElement scope) {
        PsiElement resolve;
        if (reference == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(10);
        }
        List list = (resolve = (PsiElement)ContainerUtil.getFirstItem((Collection)reference.resolveGlobal(false))) != null ? StreamEx.of((Collection)ReferencesSearch.search((PsiElement)resolve, (SearchScope)new LocalSearchScope((PsiElement)scope)).findAll()).select(PhpReference.class).toList() : Collections.emptyList();
        if (list == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private static PhpGroupUseElement.PhpUseKeyword getUseKeyword(PhpReference reference) {
        if (reference instanceof ConstantReference) {
            PhpGroupUseElement.PhpUseKeyword phpUseKeyword = PhpGroupUseElement.PhpUseKeyword.CONSTANT;
            if (phpUseKeyword == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(12);
            }
            return phpUseKeyword;
        }
        if (reference instanceof FunctionReference) {
            PhpGroupUseElement.PhpUseKeyword phpUseKeyword = PhpGroupUseElement.PhpUseKeyword.FUNCTION;
            if (phpUseKeyword == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(13);
            }
            return phpUseKeyword;
        }
        PhpGroupUseElement.PhpUseKeyword phpUseKeyword = PhpGroupUseElement.PhpUseKeyword.CLASS;
        if (phpUseKeyword == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(14);
        }
        return phpUseKeyword;
    }

    public static void replaceReference(Project project, PsiReference reference, String name) {
        if (reference instanceof FunctionReference) {
            PhpReplaceWithAliasIntention.replaceFunctionReference((FunctionReference)reference, name);
        } else if (reference instanceof ConstantReference) {
            ((ConstantReference)reference).replace((PsiElement)PhpPsiElementFactory.createConstantReference(project, name));
        } else if (reference instanceof PhpPsiElement) {
            PhpImportClassIntention.replaceClassReference((PhpPsiElement)reference, name);
        } else {
            PhpNamespaceReference namespaceReference = (PhpNamespaceReference)ObjectUtils.tryCast((Object)reference.getElement(), PhpNamespaceReference.class);
            if (namespaceReference != null) {
                PhpReplaceWithAliasIntention.replaceFirstPartOfNamespaceReference(project, namespaceReference, name);
            }
        }
    }

    private static void replaceFirstPartOfNamespaceReference(Project project, PhpNamespaceReference namespaceReference, String name) {
        String fullName = StringUtil.trimEnd((String)namespaceReference.getText(), (String)"\\");
        int firstDelimiter = fullName.indexOf("\\");
        String namespaceName = firstDelimiter >= 0 ? name + fullName.substring(firstDelimiter) : name;
        boolean inDoc = PhpPsiUtil.getParentByCondition((PsiElement)namespaceReference, false, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
        namespaceReference.replace((PsiElement)PhpPsiElementFactory.createNamespaceReference(project, namespaceName, inDoc));
    }

    private static void replaceFunctionReference(FunctionReference reference, String aliasName) {
        ParameterList list = reference.getParameterList();
        String parameterListText = list != null ? list.getText() : "";
        reference.replace((PsiElement)PhpPsiElementFactory.createFunctionReference(reference.getProject(), aliasName + "(" + parameterListText + ")"));
    }

    @NotNull
    static PhpUse createUseWithAlias(@NotNull Project project, @NotNull PhpUse originalUse, @Nullable String aliasName) {
        PhpUseList useList;
        PhpNamespaceReference useListNamespaceReference;
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(15);
        }
        if (originalUse == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(16);
        }
        PhpNamespaceReference phpNamespaceReference = useListNamespaceReference = (useList = PhpUseImpl.getUseList((PsiElement)originalUse)) != null ? useList.getNamespaceReference() : null;
        if (useListNamespaceReference != null) {
            return PhpReplaceWithAliasIntention.createUseInGroupStatement(project, aliasName, useList, originalUse, useListNamespaceReference);
        }
        String keyword = PhpGroupUseElement.getKeyword(originalUse, useList);
        PhpUse phpUse = PhpPsiElementFactory.createUseStatementWithKeyword(project, keyword, originalUse.getFQN(), aliasName).getDeclarations()[0];
        if (phpUse == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(17);
        }
        return phpUse;
    }

    @NotNull
    public static String createUniqueClassAliasName(@NotNull PhpPsiElement scope, String name, PhpGroupUseElement.PhpUseKeyword keyword) {
        if (scope == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(18);
        }
        THashSet aliases = new THashSet(PhpImportClassIntention.collectUsedAliases(scope, keyword), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        String aliasCandidate = PhpLangUtil.toShortName(name) + "Alias";
        String string = PhpNameUtil.unique(aliasCandidate, "", "", (Condition<? super String>)((Condition)((Set)aliases)::contains));
        if (string == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static PhpUse createUseInGroupStatement(@NotNull Project project, String aliasName, PhpUseList useList, PhpUse originalUse, PhpNamespaceReference namespaceReference) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(20);
        }
        PhpUse[] declarations = useList.getDeclarations();
        ArrayList<PhpGroupUseElement> uses = new ArrayList<PhpGroupUseElement>(declarations.length);
        int replacedUseWithAliasIndex = PhpReplaceWithAliasIntention.collectDeclarationsAndReplaceOriginalWithAlias(declarations, originalUse, aliasName, uses);
        boolean trailingComma = PhpUseListImpl.getTrailingComma(useList) != null;
        PhpUse phpUse = PhpPsiElementFactory.createGroupUseStatement(project, null, PhpLangUtil.toFQN(namespaceReference.getFullName()), uses, trailingComma).getDeclarations()[replacedUseWithAliasIndex];
        if (phpUse == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(21);
        }
        return phpUse;
    }

    private static int collectDeclarationsAndReplaceOriginalWithAlias(PhpUse[] declarations, PhpUse originalUse, String aliasName, Collection<PhpGroupUseElement> uses) {
        int replacedIndex = -1;
        PhpReference originalUseTargetReference = originalUse.getTargetReference();
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            PhpUse declaration = declarations[i];
            PhpReference declarationReference = declaration.getTargetReference();
            if (declarationReference != null && declarationReference.equals(originalUseTargetReference)) {
                replacedIndex = i;
                uses.add(new PhpGroupUseElement(declaration, aliasName));
                continue;
            }
            uses.add(new PhpGroupUseElement(declaration));
        }
        assert (replacedIndex >= 0) : "Can't find replaced use. Original use fqn: " + originalUse.getFQN() + ". Result declarations:\n" + uses.stream().map(PhpGroupUseElement::toString).collect(Collectors.joining());
        return replacedIndex;
    }

    @NotNull
    private static PhpGroupUseElement.PhpUseKeyword getUseKeyword(String value) {
        for (PhpGroupUseElement.PhpUseKeyword keyword : PhpGroupUseElement.PhpUseKeyword.values()) {
            if (!StringUtil.equals((CharSequence)keyword.getValue(), (CharSequence)value)) continue;
            PhpGroupUseElement.PhpUseKeyword phpUseKeyword = keyword;
            if (phpUseKeyword == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(22);
            }
            return phpUseKeyword;
        }
        throw new IllegalArgumentException();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(23);
        }
        if (element == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(24);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(element);
        if (scope == null) {
            return false;
        }
        PhpReference reference = PhpReplaceWithAliasIntention.getReference(element);
        if (reference == null) {
            return false;
        }
        PhpUse useDirectly = PhpReplaceWithAliasIntention.getUseDirectly((PsiElement)reference);
        if (useDirectly != null) {
            return PhpReplaceWithAliasIntention.importCanBeAliased(useDirectly);
        }
        if (PhpTargetElementEvaluator.getElementByReference((PsiReference)reference) != null) {
            return false;
        }
        return PhpCodeInsightUtil.isFullyQualified(reference) ? reference.multiResolve(false).length > 0 : ContainerUtil.exists(PhpReplaceWithAliasIntention.resolveUses(reference), PhpReplaceWithAliasIntention::importCanBeAliased);
    }

    @Nullable
    private static PhpReference getReference(@Nullable PsiElement element) {
        return (PhpReference)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    @NotNull
    private static Collection<PhpUse> resolveUses(@Nullable PhpReference reference) {
        String fqn;
        PhpUse use = PhpReplaceWithAliasIntention.getUseDirectly((PsiElement)reference);
        if (use != null) {
            Set<PhpUse> set = Collections.singleton(use);
            if (set == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(25);
            }
            return set;
        }
        if (reference == null) {
            List<PhpUse> list = Collections.emptyList();
            if (list == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(26);
            }
            return list;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference);
        if (scope == null) {
            List<PhpUse> list = Collections.emptyList();
            if (list == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(27);
            }
            return list;
        }
        PhpNamedElement resolve = (PhpNamedElement)ObjectUtils.tryCast((Object)reference.resolve(), PhpNamedElement.class);
        String string = fqn = resolve != null ? resolve.getFQN() : null;
        if (fqn == null) {
            List<PhpUse> list = Collections.emptyList();
            if (list == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(28);
            }
            return list;
        }
        List list = ContainerUtil.filter(PhpCodeInsightUtil.findDeclarations(scope, fqn), d -> StringUtil.equals((CharSequence)PhpReplaceWithAliasIntention.getKeyword(d), (CharSequence)PhpReplaceWithAliasIntention.getUseKeyword(reference).getValue()));
        if (list == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    private static String getKeyword(@NotNull PhpUse first) {
        if (first == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(30);
        }
        String string = PhpGroupUseElement.getKeyword(first, PhpUseImpl.getUseList((PsiElement)first));
        if (string == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    private static PhpUse getUseDirectly(@Nullable PsiElement element) {
        return (PhpUse)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpReplaceWithAliasIntention.getTitle();
        if (string == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PhpReplaceWithAliasIntention.getTitle();
        if (string == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(33);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static boolean importCanBeAliased(@NotNull PhpUse phpUse) {
        if (phpUse == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(34);
        }
        return phpUse.getAliasName() == null && !phpUse.isTraitImport();
    }

    @IntentionName
    @Nls
    public static String getTitle() {
        return PhpBundle.message("intention.replace.class.with.alias", new Object[0]);
    }

    private static /* synthetic */ void lambda$chooseFromExistingAliasesAndReplaceReferences$5(List highlighters, Map usesByName, Editor editor, String name) {
        if (name == null) {
            return;
        }
        PhpChangeVisibilityIntentionBase.dropHighlighters(highlighters);
        PhpUse use = (PhpUse)usesByName.get(name);
        if (use != null) {
            highlighters.add(PhpChangeVisibilityIntentionBase.addRangeHighlighter(editor, (PsiElement)use));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceWithAliasIntention";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalUse";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpUse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceWithAliasIntention";
                break;
            }
            case 5: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseKeyword";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseWithAlias";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createUniqueClassAliasName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseInGroupStatement";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveUses";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateUseAndReplaceReferences";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "chooseFromExistingAliasesAndReplaceReferences";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceReferences";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runRename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateImport";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createUseWithAlias";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createUniqueClassAliasName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createUseInGroupStatement";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getKeyword";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "importCanBeAliased";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

