/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import org.jetbrains.annotations.NotNull;

public class PhpReplaceTernaryWithIfIntention
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        TernaryExpression ternaryExpression;
        if (project == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(1);
        }
        if ((ternaryExpression = (TernaryExpression)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)TernaryExpression.INSTANCEOF)) != null) {
            Object currentStatement;
            PhpPsiElement trueVariant = ternaryExpression.getTrueVariant();
            PhpPsiElement falseVariant = ternaryExpression.getFalseVariant();
            PhpPsiElement condition = ternaryExpression.getCondition();
            if (trueVariant != null && falseVariant != null && condition != null && (currentStatement = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)Statement.INSTANCEOF)) instanceof Statement) {
                int statementStart = currentStatement.getTextOffset();
                int ternaryStart = ternaryExpression.getTextOffset() - statementStart;
                int ternaryLength = ternaryExpression.getTextLength();
                String statementText = currentStatement.getText();
                int ternaryEnd = ternaryStart + ternaryLength;
                String arg = "if (" + condition.getText() + ") { " + statementText.substring(0, ternaryStart) + trueVariant.getText() + statementText.substring(ternaryEnd);
                If newElement = PhpPsiElementFactory.createFirstFromText(project, If.class, arg = arg + " } else {" + statementText.substring(0, ternaryStart) + falseVariant.getText() + statementText.substring(ternaryEnd) + "}");
                if (newElement != null) {
                    currentStatement.replace((PsiElement)newElement);
                }
            }
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(3);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        TernaryExpression ternaryExpression = (TernaryExpression)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)TernaryExpression.INSTANCEOF);
        Statement statement = null;
        if (ternaryExpression != null) {
            statement = (Statement)PhpPsiUtil.getParentByCondition((PsiElement)ternaryExpression, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        }
        if (statement != null && !(statement instanceof GroupStatement) && !PhpPsiUtil.isOfType(statement.getFirstChild(), PhpTokenTypes.kwCONST)) {
            this.setText(PhpReplaceTernaryWithIfIntention.getTitle());
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("replace.ternary.expression.with.if.clause", new Object[0]);
        if (string == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PhpReplaceTernaryWithIfIntention.getTitle();
        if (string == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @IntentionName
    public static String getTitle() {
        return PhpBundle.message("intention.replace.ternary.expression.with.if", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceTernaryWithIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceTernaryWithIfIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

