/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.debug.common.PhpEvaluator;
import com.jetbrains.php.lang.intentions.PhpStatementUtils;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpNameUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PhpReplaceSwitchWithIfIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.kwSWITCH)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PhpSwitch)) {
            return false;
        }
        PhpSwitch switchStatement = (PhpSwitch)parent;
        return switchStatement.getCases().length > 0;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(3);
        }
        PhpSwitch switchStatement = (PhpSwitch)element.getParent();
        assert (switchStatement != null);
        List<SwitchStatementBranch> branches = PhpReplaceSwitchWithIfIntention.collectBranches(project, switchStatement);
        PhpReplaceSwitchWithIfIntention.updateSwitchStatement(project, switchStatement, branches);
    }

    public static List<SwitchStatementBranch> collectBranches(@NotNull Project project, @NotNull PhpSwitch switchStatement) {
        if (project == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(4);
        }
        if (switchStatement == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(5);
        }
        ArrayList<SwitchStatementBranch> openBranches = new ArrayList<SwitchStatementBranch>();
        ArrayList<SwitchStatementBranch> allBranches = new ArrayList<SwitchStatementBranch>();
        SwitchStatementBranch currentBranch = null;
        for (PhpCase phpCase : switchStatement.getAllCases()) {
            if (currentBranch == null) {
                openBranches.clear();
                currentBranch = new SwitchStatementBranch();
                allBranches.add(currentBranch);
                openBranches.add(currentBranch);
            } else if (currentBranch.hasStatements()) {
                currentBranch = new SwitchStatementBranch();
                allBranches.add(currentBranch);
                openBranches.add(currentBranch);
            }
            if (PhpPsiUtil.isOfType((PsiElement)phpCase, PhpElementTypes.CASE_DEFAULT)) {
                currentBranch.setDefault();
            } else {
                PhpPsiElement value = phpCase.getCondition();
                String valueText = PhpReplaceSwitchWithIfIntention.getCaseValueText(value);
                currentBranch.addCaseValue(valueText);
            }
            for (PsiElement statement : PhpReplaceSwitchWithIfIntention.getStatements(phpCase)) {
                if (statement instanceof Statement && !PhpStatementUtils.statementMayCompleteNormally((Statement)statement)) {
                    currentBranch = null;
                }
                for (SwitchStatementBranch branch : openBranches) {
                    if (statement instanceof PhpBreak) {
                        Integer identifier;
                        PhpBreak breakStatement = (PhpBreak)statement;
                        PsiElement label = breakStatement.getArgument();
                        Integer n = identifier = label != null ? PhpCodeInsightUtil.toInt(label) : null;
                        if (identifier == null && label != null) {
                            Statement newBreakStatement = PhpPsiElementFactory.createStatement(project, "break " + label.getText() + " - 1;");
                            branch.addStatement((PsiElement)newBreakStatement);
                            continue;
                        }
                        if (identifier == null || identifier == 1) {
                            branch.clearPendingWhiteSpaces();
                            continue;
                        }
                        int newIdentifier = identifier - 1;
                        Statement newBreakStatement = newIdentifier == 1 ? PhpPsiElementFactory.createStatement(project, "break;") : PhpPsiElementFactory.createStatement(project, "break " + newIdentifier + ";");
                        branch.addStatement((PsiElement)newBreakStatement);
                        continue;
                    }
                    if (statement instanceof Statement) {
                        branch.addStatement(statement);
                        continue;
                    }
                    if (statement instanceof PsiWhiteSpace) {
                        branch.addWhiteSpace(statement);
                        continue;
                    }
                    branch.addElement(statement);
                }
            }
        }
        return allBranches;
    }

    private static List<PsiElement> getStatements(@NotNull PhpCase phpCase) {
        if (phpCase == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(6);
        }
        ArrayList<PsiElement> statements = new ArrayList<PsiElement>();
        Statement caseStatement = phpCase.getStatement();
        assert (caseStatement instanceof GroupStatement);
        GroupStatement groupStatement = (GroupStatement)caseStatement;
        PsiElement colon = PhpPsiUtil.getChildOfType((PsiElement)phpCase, PhpTokenTypes.opCOLON);
        if (colon == null) {
            colon = phpCase.getCondition();
        }
        if (colon == null) {
            colon = phpCase.getFirstChild();
        }
        for (PsiElement next = colon.getNextSibling(); next != null && next != groupStatement; next = next.getNextSibling()) {
            statements.add(next);
        }
        for (PsiElement child = groupStatement.getFirstChild(); child != null; child = child.getNextSibling()) {
            statements.add(child);
        }
        return statements;
    }

    private static String getCaseValueText(PhpPsiElement value) {
        if (value instanceof ParenthesizedExpression) {
            value = ((ParenthesizedExpression)value).unparenthesize();
        }
        return value == null ? "" : value.getText();
    }

    private static void updateSwitchStatement(@NotNull Project project, @NotNull PhpSwitch switchStatement, @NotNull List<SwitchStatementBranch> branches) {
        String declarationString;
        Object expressionText;
        if (project == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(7);
        }
        if (switchStatement == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(8);
        }
        if (branches == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(9);
        }
        PsiElement argument = switchStatement.getArgument();
        assert (argument instanceof PhpExpression);
        PhpExpression expression = (PhpExpression)argument;
        boolean canCauseSideEffects = PhpEvaluator.canCauseSideEffects((PsiElement)expression);
        if (canCauseSideEffects) {
            expressionText = "$" + PhpReplaceSwitchWithIfIntention.suggestUniqueVariableName((PsiElement)expression);
            declarationString = (String)expressionText + " = " + expression.getText() + ";";
        } else {
            declarationString = null;
            expressionText = expression.getText();
        }
        StringBuilder ifStatementText = new StringBuilder(1024);
        boolean firstBranch = true;
        SwitchStatementBranch defaultBranch = null;
        for (SwitchStatementBranch branch : branches) {
            if (branch.isDefault()) {
                defaultBranch = branch;
                continue;
            }
            List<String> caseValues = branch.getCaseValues();
            List<PsiElement> bodyElements = branch.getBodyElements();
            PhpReplaceSwitchWithIfIntention.dumpBranch((String)expressionText, caseValues, bodyElements, firstBranch, ifStatementText);
            if (!firstBranch) continue;
            firstBranch = false;
        }
        if (defaultBranch != null) {
            List<PsiElement> bodyElements = defaultBranch.getBodyElements();
            PhpReplaceSwitchWithIfIntention.dumpDefaultBranch(bodyElements, firstBranch, ifStatementText);
        }
        if (!StringUtil.isEmpty((CharSequence)ifStatementText)) {
            if (canCauseSideEffects) {
                Statement declarationStatement = PhpPsiElementFactory.createStatement(project, declarationString);
                PsiElement parent = switchStatement.getParent();
                parent.addBefore((PsiElement)declarationStatement, (PsiElement)switchStatement);
            }
            Statement ifStatement = PhpPsiElementFactory.createStatement(project, ifStatementText.toString());
            switchStatement.replace((PsiElement)ifStatement);
        }
    }

    @NotNull
    private static String suggestUniqueVariableName(@NotNull PsiElement position) {
        if (position == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(10);
        }
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations(position, false, null);
        Set usedNames = ContainerUtil.map2Set(declarations, element -> element.getName());
        SmartList name = new SmartList((Object)"i");
        PhpNameUtil.unique((List<String>)name, usedNames);
        String string = (String)name.get(0);
        if (string == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static void dumpBranch(String expressionText, List<String> caseValues, List<PsiElement> bodyStatements, boolean firstBranch, @NonNls StringBuilder ifStatementString) {
        if (!firstBranch) {
            ifStatementString.append("else");
        }
        PhpReplaceSwitchWithIfIntention.dumpCaseValues(expressionText, caseValues, ifStatementString);
        PhpReplaceSwitchWithIfIntention.dumpBody(bodyStatements, ifStatementString);
    }

    private static void dumpDefaultBranch(List<PsiElement> bodyStatements, boolean firstBranch, @NonNls StringBuilder ifStatementString) {
        if (!firstBranch) {
            ifStatementString.append("else ");
        }
        PhpReplaceSwitchWithIfIntention.dumpBody(bodyStatements, ifStatementString);
    }

    private static void dumpCaseValues(String expressionText, List<String> caseValues, @NonNls StringBuilder ifStatementString) {
        ifStatementString.append("if(");
        boolean firstCaseValue = true;
        for (String caseValue : caseValues) {
            if (!firstCaseValue) {
                ifStatementString.append("||");
            } else {
                firstCaseValue = false;
            }
            ifStatementString.append(expressionText);
            ifStatementString.append("==");
            ifStatementString.append(caseValue);
        }
        ifStatementString.append(')');
    }

    private static void dumpBody(List<PsiElement> bodyStatements, @NonNls StringBuilder ifStatementString) {
        ifStatementString.append('{');
        for (PsiElement bodyStatement : bodyStatements) {
            ifStatementString.append(bodyStatement.getText());
        }
        ifStatementString.append("\n}");
    }

    @NotNull
    public String getText() {
        String string = PhpBundle.message("intention.family.name.replace.switch.with.if", new Object[0]);
        if (string == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.replace.switch.with.if", new Object[0]);
        if (string == null) {
            PhpReplaceSwitchWithIfIntention.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpCase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceSwitchWithIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceSwitchWithIfIntention";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestUniqueVariableName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectBranches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStatements";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateSwitchStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestUniqueVariableName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SwitchStatementBranch {
        private final List<String> caseValues = new SmartList();
        private final List<PsiElement> bodyElements = new SmartList();
        private final List<PsiElement> pendingWhiteSpace = new SmartList();
        private boolean isDefault = false;
        private boolean hasStatements = false;

        public void addCaseValue(String labelString) {
            this.caseValues.add(labelString);
        }

        public void addStatement(PsiElement statement) {
            if (!this.hasStatements) {
                this.hasStatements = true;
            }
            this.addElement(statement);
        }

        private void addElement(PsiElement element) {
            this.bodyElements.addAll(this.pendingWhiteSpace);
            this.pendingWhiteSpace.clear();
            this.bodyElements.add(element);
        }

        public void addWhiteSpace(PsiElement statement) {
            if (this.bodyElements.isEmpty()) {
                this.pendingWhiteSpace.clear();
            }
            this.pendingWhiteSpace.add(statement);
        }

        public List<String> getCaseValues() {
            return Collections.unmodifiableList(this.caseValues);
        }

        public List<PsiElement> getBodyStatements() {
            return ContainerUtil.filter(this.bodyElements, e -> e instanceof Statement);
        }

        public List<PsiElement> getBodyElements() {
            return Collections.unmodifiableList(this.bodyElements);
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault() {
            this.isDefault = true;
        }

        public boolean hasStatements() {
            return this.hasStatements;
        }

        public void clearPendingWhiteSpaces() {
            this.pendingWhiteSpace.clear();
        }
    }
}

