/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.util.PhpStringUtil;
import org.jetbrains.annotations.NotNull;

public class PhpReplaceQuotesIntention
extends PsiElementBaseIntentionAction {
    @IntentionName
    @IntentionFamilyName
    public static final String TEXT = PhpBundle.message("replace.quotes", new Object[0]);
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        return PhpReplaceQuotesIntention.isStringLiteral(element);
    }

    public static boolean isStringLiteral(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(2);
        }
        if ((node = element.getNode()) == null) {
            return false;
        }
        IElementType type = node.getElementType();
        IElementType parentType = node.getTreeParent().getElementType();
        return type == PhpTokenTypes.STRING_LITERAL || parentType == PhpElementTypes.STRING || type == PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE || element.getParent() != null && element.getParent().getParent() instanceof StringLiteralExpression;
    }

    @NotNull
    public String getFamilyName() {
        String string = TEXT;
        if (string == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = TEXT;
        if (string == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        StringLiteralExpression string;
        if (project == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(6);
        }
        if ((string = (StringLiteralExpression)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF)) == null || string.isHeredoc() || PhpHeredocToStringIntention.isNowdoc((PsiElement)string)) {
            return;
        }
        if (!PhpStringUtil.isUnescapableText(string.getText(), PhpReplaceQuotesIntention.getNewQuote(string) == '\"')) {
            PhpQuickFixBase.showErrorMessage(string.getProject(), PhpBundle.message("intention.replace.quotes", new Object[0]), (PsiElement)string);
            return;
        }
        StringLiteralExpression newElement = PhpReplaceQuotesIntention.createLiteralWithChangedQuotes(string);
        ASTNode parentNode = string.getNode();
        ASTNode tempNode = parentNode.getTreeParent();
        tempNode.replaceChild(parentNode, newElement.getNode());
    }

    public static StringLiteralExpression createLiteralWithChangedQuotes(@NotNull StringLiteralExpression string) {
        char newQuote;
        if (string == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(7);
        }
        char oldQuote = (newQuote = PhpReplaceQuotesIntention.getNewQuote(string)) == '\"' ? (char)'\'' : '\"';
        String data = string.getText();
        String isBinary = "";
        if (data.startsWith("b") || data.startsWith("B")) {
            isBinary = data.substring(0, 1);
        }
        data = data.substring(1 + isBinary.length(), data.length() - 1);
        data = PhpReplaceQuotesIntention.escapeString(data, newQuote, oldQuote);
        String text = isBinary + newQuote + data + newQuote;
        return PhpPsiElementFactory.createPhpPsiFromText(string.getProject(), StringLiteralExpression.class, text);
    }

    private static char getNewQuote(@NotNull StringLiteralExpression string) {
        if (string == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(8);
        }
        return !string.isSingleQuote() ? (char)'\'' : '\"';
    }

    private static String escapeString(String t, char newQuote, char oldQuote) {
        String temp = PhpStringUtil.unescapeText(t, oldQuote == '\'', new String[0]);
        return PhpStringUtil.escapeText(temp, newQuote == '\'', Character.valueOf('\n'), Character.valueOf('\t'));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceQuotesIntention";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceQuotesIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralWithChangedQuotes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNewQuote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

