/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.debug.common.PhpEvaluator;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.intentions.PhpStatementUtils;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpReplaceIfWithSwitchIntention
extends PsiElementBaseIntentionAction {
    @Nls
    @IntentionName
    public static final String TEXT = PhpBundle.message("replace.if.with.switch", new Object[0]);

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.kwIF)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof If)) {
            return false;
        }
        return PhpReplaceIfWithSwitchIntention.getCaseExpression((If)parent, false) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(3);
        }
        If ifStatement = (If)element.getParent();
        assert (ifStatement != null);
        PsiElement caseExpression = PhpReplaceIfWithSwitchIntention.getCaseExpression(ifStatement, true);
        assert (caseExpression != null);
        ArrayList<IfStatementBranch> branches = new ArrayList<IfStatementBranch>();
        PhpReplaceIfWithSwitchIntention.collectBranches(ifStatement, caseExpression, branches);
        PhpReplaceIfWithSwitchIntention.updateIfStatement(project, ifStatement, caseExpression, branches);
    }

    @Nullable
    private static PsiElement getCaseExpression(@NotNull If ifStatement, boolean checkSiblingIfs) {
        if (ifStatement == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(4);
        }
        PhpPsiElement condition = ifStatement.getCondition();
        List<PsiElement> possibleCaseExpressions = PhpReplaceIfWithSwitchIntention.determinePossibleCaseExpressions((PsiElement)condition);
        for (PsiElement caseExpression : possibleCaseExpressions) {
            if (PhpEvaluator.canCauseSideEffects(caseExpression)) continue;
            If ifStatementToCheck = ifStatement;
            while (PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase((PsiElement)ifStatementToCheck.getCondition(), caseExpression)) {
                ElseIf[] elseIfBranches;
                for (ElseIf elseIfBranch : elseIfBranches = ifStatementToCheck.getElseIfBranches()) {
                    if (PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase((PsiElement)elseIfBranch.getCondition(), caseExpression)) continue;
                    return null;
                }
                Else elseBranch = ifStatementToCheck.getElseBranch();
                if (elseBranch != null && elseBranch.getStatement() instanceof If) {
                    ifStatementToCheck = (If)elseBranch.getStatement();
                    continue;
                }
                if (checkSiblingIfs && elseBranch == null && ifStatementToCheck.getNextPsiSibling() instanceof If) {
                    ifStatementToCheck = (If)ifStatementToCheck.getNextPsiSibling();
                    assert (ifStatementToCheck != null);
                    if (PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase((PsiElement)ifStatementToCheck.getCondition(), caseExpression)) continue;
                    return caseExpression;
                }
                return caseExpression;
            }
        }
        return null;
    }

    private static void collectBranches(If ifStatement, PsiElement caseExpression, List<IfStatementBranch> branches) {
        SmartList ifStatementsToDelete = new SmartList();
        If currentIfStatement = ifStatement;
        while (true) {
            ElseIf[] elseIfBranches;
            PhpReplaceIfWithSwitchIntention.createBranch((ControlStatement)currentIfStatement, caseExpression, branches);
            for (ElseIf elseIfBranch : elseIfBranches = currentIfStatement.getElseIfBranches()) {
                PhpReplaceIfWithSwitchIntention.createBranch((ControlStatement)elseIfBranch, caseExpression, branches);
            }
            Else elseBranch = currentIfStatement.getElseBranch();
            if (elseBranch != null) {
                PhpPsiElement elseBranchStatement = elseBranch.getStatement();
                if (elseBranchStatement instanceof If) {
                    currentIfStatement = (If)elseBranchStatement;
                    continue;
                }
                if (!(elseBranchStatement instanceof Statement)) break;
                IfStatementBranch elseIfBranch = new IfStatementBranch();
                elseIfBranch.setElse();
                elseIfBranch.setStatement((Statement)elseBranchStatement);
                branches.add(elseIfBranch);
                break;
            }
            PhpPsiElement nextSibling = currentIfStatement.getNextPsiSibling();
            if (!(nextSibling instanceof If) || !PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase((PsiElement)(currentIfStatement = (If)nextSibling).getCondition(), caseExpression)) break;
            ifStatementsToDelete.add(currentIfStatement);
        }
        for (If ifStatementToDelete : ifStatementsToDelete) {
            ifStatementToDelete.delete();
        }
    }

    @NotNull
    private static List<PsiElement> determinePossibleCaseExpressions(PsiElement condition) {
        PsiElement expressionToCheck = PhpReplaceIfWithSwitchIntention.unparenthesize(condition);
        SmartList possibleCaseExpressions = new SmartList();
        if (expressionToCheck instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expressionToCheck;
            IElementType operator = binaryExpression.getOperationType();
            PsiElement leftOperand = binaryExpression.getLeftOperand();
            PsiElement rightOperand = binaryExpression.getRightOperand();
            if (PhpLangUtil.isShortCircuitOrOperator(operator)) {
                return PhpReplaceIfWithSwitchIntention.determinePossibleCaseExpressions(leftOperand);
            }
            if (operator == PhpTokenTypes.opEQUAL) {
                if (PhpReplaceIfWithSwitchIntention.canBeCaseLabel(leftOperand) && rightOperand != null) {
                    possibleCaseExpressions.add(rightOperand);
                }
                if (PhpReplaceIfWithSwitchIntention.canBeCaseLabel(rightOperand)) {
                    possibleCaseExpressions.add(leftOperand);
                }
            }
        }
        SmartList smartList = possibleCaseExpressions;
        if (smartList == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private static boolean canBeMadeIntoCase(PsiElement condition, PsiElement caseExpression) {
        PsiElement expressionToCheck = PhpReplaceIfWithSwitchIntention.unparenthesize(condition);
        if (expressionToCheck instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expressionToCheck;
            IElementType operator = binaryExpression.getOperationType();
            PsiElement leftOperand = binaryExpression.getLeftOperand();
            PsiElement rightOperand = binaryExpression.getRightOperand();
            if (PhpLangUtil.isShortCircuitOrOperator(operator)) {
                return PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase(leftOperand, caseExpression) && PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase(rightOperand, caseExpression);
            }
            if (operator == PhpTokenTypes.opEQUAL) {
                return PhpReplaceIfWithSwitchIntention.canBeCaseLabel(leftOperand) && rightOperand != null && PhpCodeEditUtil.isEquivalent(caseExpression, rightOperand) || PhpReplaceIfWithSwitchIntention.canBeCaseLabel(rightOperand) && leftOperand != null && PhpCodeEditUtil.isEquivalent(caseExpression, leftOperand);
            }
        }
        return false;
    }

    private static boolean canBeCaseLabel(PsiElement expression) {
        return expression != null && PhpCodeValidationUtil.isAllowedAsConstantValue(expression);
    }

    private static void createBranch(ControlStatement ifStatement, PsiElement caseExpression, List<IfStatementBranch> branches) {
        ArrayList<PsiElement> labels = new ArrayList<PsiElement>();
        PhpPsiElement condition = ifStatement.getCondition();
        PhpReplaceIfWithSwitchIntention.collectLabels((PsiElement)condition, caseExpression, labels);
        IfStatementBranch ifBranch = new IfStatementBranch();
        for (PsiElement label : labels) {
            ifBranch.addLabel(label.getText());
        }
        ifBranch.setStatement(ifStatement.getStatement());
        branches.add(ifBranch);
    }

    private static void collectLabels(PsiElement condition, PsiElement caseExpression, List<PsiElement> labels) {
        PsiElement expressionToCheck = PhpReplaceIfWithSwitchIntention.unparenthesize(condition);
        if (expressionToCheck instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expressionToCheck;
            IElementType operator = binaryExpression.getOperationType();
            PsiElement leftOperand = binaryExpression.getLeftOperand();
            PsiElement rightOperand = binaryExpression.getRightOperand();
            if (PhpLangUtil.isShortCircuitOrOperator(operator)) {
                PhpReplaceIfWithSwitchIntention.collectLabels(leftOperand, caseExpression, labels);
                PhpReplaceIfWithSwitchIntention.collectLabels(rightOperand, caseExpression, labels);
            } else if (operator == PhpTokenTypes.opEQUAL && leftOperand != null && rightOperand != null) {
                if (PhpCodeEditUtil.isEquivalent(caseExpression, rightOperand)) {
                    labels.add(leftOperand);
                } else {
                    labels.add(rightOperand);
                }
            }
        }
    }

    private static PsiElement unparenthesize(PsiElement condition) {
        return condition instanceof ParenthesizedExpression ? ((ParenthesizedExpression)condition).unparenthesize() : condition;
    }

    private static void updateIfStatement(@NotNull Project project, If ifStatement, PsiElement caseExpression, List<IfStatementBranch> branches) {
        if (project == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(6);
        }
        StringBuilder switchStatementText = new StringBuilder(1024);
        switchStatementText.append("switch(").append(caseExpression.getText()).append(')').append('{');
        for (IfStatementBranch branch : branches) {
            Statement statement = branch.getStatement();
            if (!branch.isElse()) {
                List<String> labels = branch.getLabels();
                PhpReplaceIfWithSwitchIntention.dumpBranch(switchStatementText, labels, statement);
                continue;
            }
            PhpReplaceIfWithSwitchIntention.dumpDefaultBranch(switchStatementText, statement);
        }
        switchStatementText.append('}');
        String switchStatementString = switchStatementText.toString();
        Statement switchStatement = PhpPsiElementFactory.createStatement(project, switchStatementString);
        ifStatement.replace((PsiElement)switchStatement);
    }

    private static void dumpBranch(StringBuilder switchStatementString, List<String> labels, Statement body) {
        PhpReplaceIfWithSwitchIntention.dumpLabels(switchStatementString, labels);
        PhpReplaceIfWithSwitchIntention.dumpBody(switchStatementString, body);
    }

    private static void dumpLabels(StringBuilder switchStatementString, List<String> labels) {
        for (String label : labels) {
            switchStatementString.append("case ").append(label).append(":");
        }
    }

    private static void dumpDefaultBranch(StringBuilder switchStatementString, Statement body) {
        switchStatementString.append("default: ");
        PhpReplaceIfWithSwitchIntention.dumpBody(switchStatementString, body);
    }

    private static void dumpBody(StringBuilder switchStatementString, Statement bodyStatement) {
        if (bodyStatement instanceof GroupStatement && PhpPsiUtil.isOfType(bodyStatement.getFirstChild(), PhpTokenTypes.chLBRACE)) {
            for (PsiElement s = bodyStatement.getFirstChild(); s != null; s = s.getNextSibling()) {
                if (PhpPsiUtil.isOfType(s, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE)) continue;
                PhpReplaceIfWithSwitchIntention.appendElement(switchStatementString, s);
            }
        } else {
            PhpReplaceIfWithSwitchIntention.appendElement(switchStatementString, (PsiElement)bodyStatement);
        }
        if (PhpStatementUtils.statementMayCompleteNormally(bodyStatement)) {
            switchStatementString.append("break;");
        }
    }

    private static void appendElement(StringBuilder switchStatementString, PsiElement element) {
        if (element instanceof PhpBreak) {
            Integer identifier;
            PhpBreak breakStatement = (PhpBreak)element;
            PsiElement label = breakStatement.getArgument();
            Integer n = identifier = label != null ? PhpCodeInsightUtil.toInt(label) : null;
            if (identifier == null && label != null) {
                switchStatementString.append("break ").append(label.getText()).append(" + 1;");
            } else {
                int newIdentifier = identifier != null ? identifier + 1 : 2;
                switchStatementString.append("break ").append(newIdentifier).append(";");
            }
        } else {
            PsiElement child = element.getFirstChild();
            if (child != null) {
                while (child != null) {
                    PhpReplaceIfWithSwitchIntention.appendElement(switchStatementString, child);
                    child = child.getNextSibling();
                }
            } else {
                switchStatementString.append(element.getText());
            }
        }
    }

    @NotNull
    public String getText() {
        String string = TEXT;
        if (string == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = TEXT;
        if (string == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithSwitchIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithSwitchIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "determinePossibleCaseExpressions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCaseExpression";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateIfStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IfStatementBranch {
        private final List<String> labels = new ArrayList<String>();
        private Statement statement;
        private boolean isElse;

        private IfStatementBranch() {
        }

        public void addLabel(String label) {
            this.labels.add(label);
        }

        public void setStatement(Statement statement) {
            this.statement = statement;
        }

        public Statement getStatement() {
            return this.statement;
        }

        public List<String> getLabels() {
            return Collections.unmodifiableList(this.labels);
        }

        public boolean isElse() {
            return this.isElse;
        }

        public void setElse() {
            this.isElse = true;
        }
    }
}

