/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.codeSmell.PhpTernaryExpressionCanBeReplacedWithConditionInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpExpressionWithoutClarifyingParenthesesInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpUnnecessaryParenthesesInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNegateExpressionIntention
extends PsiElementBaseIntentionAction {
    private static final Collection<Pair<String, String>> OUR_OPERATORS_PAIRS = Arrays.asList(Pair.create((Object)"||", (Object)"&&"), Pair.create((Object)"and", (Object)"or"), Pair.create((Object)"&", (Object)"|"), Pair.create((Object)"===", (Object)"!=="), Pair.create((Object)"==", (Object)"!="), Pair.create((Object)">", (Object)"<="), Pair.create((Object)">=", (Object)"<"));
    private static final TokenSet LOGICAL_OPS = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsLOGICAL_OPS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opBIT_AND, PhpTokenTypes.opBIT_OR})});

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("negate.boolean.expression", new Object[0]);
        if (string == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        BinaryExpression expression;
        if (project == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(3);
        }
        if ((expression = PhpNegateExpressionIntention.getBinaryExpression(element)) == null) {
            return false;
        }
        PsiElement operation = expression.getOperation();
        if (operation == null) {
            return false;
        }
        String text = operation.getText();
        String invertedOperatorText = PhpNegateExpressionIntention.getInvertedOperatorText(text);
        if (invertedOperatorText == null) {
            return false;
        }
        this.setText(PhpBundle.message("intention.name.replace.with", text, invertedOperatorText));
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        BinaryExpression binaryExpression;
        if (project == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(6);
        }
        if ((binaryExpression = PhpNegateExpressionIntention.getBinaryExpression(element)) == null) {
            return;
        }
        PsiElement topmostParent = PhpTernaryExpressionCanBeReplacedWithConditionInspection.skipParentParenthesis((PsiElement)binaryExpression).getParent();
        if (topmostParent instanceof UnaryExpression && PhpNegateExpressionIntention.isNegation((UnaryExpression)topmostParent)) {
            binaryExpression = (BinaryExpression)topmostParent.replace((PsiElement)binaryExpression);
        } else {
            PsiElement notUnaryExpression = PhpNegateExpressionIntention.createNotUnaryExpression(project, (PsiElement)binaryExpression);
            PsiElement parent = binaryExpression.getParent();
            PsiElement unaryExpression = parent instanceof ParenthesizedExpression ? parent.replace(notUnaryExpression) : binaryExpression.replace(notUnaryExpression);
            binaryExpression = (BinaryExpression)PsiTreeUtil.findChildOfType((PsiElement)unaryExpression, BinaryExpression.class);
        }
        if (binaryExpression == null) {
            return;
        }
        PsiElement inverted = PhpNegateExpressionIntention.createInvertedExpression(binaryExpression);
        if (inverted == null) {
            return;
        }
        binaryExpression.replace(inverted);
    }

    private static BinaryExpression getBinaryExpression(@NotNull PsiElement element) {
        if (element == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(7);
        }
        BinaryExpression expression = (BinaryExpression)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)BinaryExpression.class::isInstance));
        if (expression != null) {
            return expression;
        }
        UnaryExpression unaryExpression = (UnaryExpression)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)UnaryExpression.class::isInstance));
        if (unaryExpression != null && PhpNegateExpressionIntention.isNegation(unaryExpression)) {
            return (BinaryExpression)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize((PsiElement)unaryExpression.getValue()), BinaryExpression.class);
        }
        return null;
    }

    private static boolean isNegation(UnaryExpression parent) {
        return PhpPsiUtil.isOfType(parent.getOperation(), PhpTokenTypes.opNOT);
    }

    @NotNull
    private static PsiElement createNotUnaryExpression(@NotNull Project project, PsiElement expression) {
        if (project == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(8);
        }
        if (expression instanceof ParenthesizedExpression) {
            return PhpNegateExpressionIntention.createNotUnaryExpression(project, (PsiElement)((ParenthesizedExpression)expression).getArgument());
        }
        if (expression instanceof UnaryExpression && PhpNegateExpressionIntention.isNegation((UnaryExpression)expression)) {
            PsiElement psiElement = PhpPsiUtil.unparenthesize((PsiElement)((UnaryExpression)expression).getValue());
            if (psiElement == null) {
                PhpNegateExpressionIntention.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        UnaryExpression notUnaryExpression = PhpPsiElementFactory.createPhpPsiFromText(project, UnaryExpression.class, "!(" + expression.getText() + ")");
        if (PhpUnnecessaryParenthesesInspection.isParensUnnecessary((ParenthesizedExpression)notUnaryExpression.getValue())) {
            UnaryExpression unaryExpression = PhpPsiElementFactory.createPhpPsiFromText(project, UnaryExpression.class, "!" + expression.getText());
            if (unaryExpression == null) {
                PhpNegateExpressionIntention.$$$reportNull$$$0(10);
            }
            return unaryExpression;
        }
        UnaryExpression unaryExpression = notUnaryExpression;
        if (unaryExpression == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(11);
        }
        return unaryExpression;
    }

    @Nullable
    private static PsiElement createInvertedExpression(@NotNull BinaryExpression expression) {
        PsiElement operation;
        if (expression == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(12);
        }
        PsiElement left = expression.getLeftOperand();
        PsiElement right = expression.getRightOperand();
        if (LOGICAL_OPS.contains(expression.getOperationType())) {
            left = PhpExpressionWithoutClarifyingParenthesesInspection.wrapInParens(PhpNegateExpressionIntention.createInvertedExpression(left));
            right = PhpExpressionWithoutClarifyingParenthesesInspection.wrapInParens(PhpNegateExpressionIntention.createInvertedExpression(right));
        }
        if ((operation = expression.getOperation()) == null || left == null || right == null) {
            return null;
        }
        String binaryExpressionText = String.format("%s %s %s", left.getText(), PhpNegateExpressionIntention.createInvertedOperation(operation).getText(), right.getText());
        BinaryExpression invertedExpression = PhpPsiElementFactory.createPhpPsiFromText(expression.getProject(), BinaryExpression.class, binaryExpressionText);
        PhpNegateExpressionIntention.unwrapIfNecessary(invertedExpression.getLeftOperand());
        PhpNegateExpressionIntention.unwrapIfNecessary(invertedExpression.getRightOperand());
        return invertedExpression;
    }

    public static PsiElement unwrapIfNecessary(PsiElement element) {
        if (element instanceof ParenthesizedExpression && PhpUnnecessaryParenthesesInspection.isParensUnnecessary((ParenthesizedExpression)element)) {
            return element.replace((PsiElement)((ParenthesizedExpression)element).extract());
        }
        return element;
    }

    @Nullable
    public static PsiElement createInvertedExpression(@Nullable PsiElement element) {
        if (element instanceof ParenthesizedExpression) {
            return PhpNegateExpressionIntention.createInvertedExpression((PsiElement)((ParenthesizedExpression)element).getArgument());
        }
        if (element instanceof BinaryExpression) {
            return PhpNegateExpressionIntention.createInvertedExpression((BinaryExpression)element);
        }
        if (PhpLangUtil.isTrue(element)) {
            return PhpPsiElementFactory.createConstantReference(element.getProject(), "false");
        }
        if (PhpLangUtil.isFalse(element)) {
            return PhpPsiElementFactory.createConstantReference(element.getProject(), "true");
        }
        return element != null ? PhpNegateExpressionIntention.createNotUnaryExpression(element.getProject(), element) : null;
    }

    private static PsiElement createInvertedOperation(PsiElement operation) {
        BinaryExpression binaryExpression = PhpPsiElementFactory.createPhpPsiFromText(operation.getProject(), BinaryExpression.class, "$a " + PhpNegateExpressionIntention.getInvertedOperatorText(operation.getText()) + " $b");
        return binaryExpression.getOperation();
    }

    @Nullable
    private static String getInvertedOperatorText(String operationText) {
        Pair pair = (Pair)ContainerUtil.find(OUR_OPERATORS_PAIRS, t -> ((String)t.first).equals(operationText) || ((String)t.second).equals(operationText));
        if (pair == null) {
            return null;
        }
        return ((String)pair.first).equals(operationText) ? (String)pair.second : (String)pair.first;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpNegateExpressionIntention";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpNegateExpressionIntention";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotUnaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNotUnaryExpression";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createInvertedExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

