/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.codeStyle.PhpUnnecessaryParenthesesInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMergeNestedConditionIntention
extends BaseElementAtCaretIntentionAction {
    @Nls
    public static final String NAME = PhpBundle.message("merge.nested.conditions", new Object[0]);
    protected static final Pair<If, If> NULL_PAIR = Pair.create(null, null);

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(1);
        }
        Pair<If, If> pair = this.getOuterAndInnerConditionsToMerge(element);
        return PhpMergeNestedConditionIntention.ifWithoutElseBranches((If)pair.first) && PhpMergeNestedConditionIntention.ifWithoutElseBranches((If)pair.second);
    }

    @NotNull
    protected Pair<If, If> getOuterAndInnerConditionsToMerge(@NotNull PsiElement position) {
        If currentIf;
        if (position == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(2);
        }
        if ((currentIf = (If)ObjectUtils.tryCast((Object)position.getParent(), If.class)) == null) {
            Pair<If, If> pair = NULL_PAIR;
            if (pair == null) {
                PhpMergeNestedConditionIntention.$$$reportNull$$$0(3);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)currentIf, (Object)PhpMergeNestedConditionIntention.getInnerOnlyIf((PsiElement)currentIf.getStatement()));
        if (pair == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private static boolean ifWithoutElseBranches(If parentIf) {
        return parentIf != null && parentIf.getElseIfBranches().length == 0 && parentIf.getElseBranch() == null;
    }

    @Nullable
    public static If getInnerOnlyIf(@Nullable PsiElement statement) {
        if (statement instanceof GroupStatement) {
            return (If)ObjectUtils.tryCast((Object)((GroupStatement)statement).getOnlyStatement(), If.class);
        }
        return (If)ObjectUtils.tryCast((Object)statement, If.class);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(6);
        }
        Pair<If, If> pair = this.getOuterAndInnerConditionsToMerge(element);
        If outerIf = (If)pair.first;
        if (outerIf == null) {
            return;
        }
        If innerIf = (If)pair.second;
        if (innerIf == null) {
            return;
        }
        PhpPsiElement condition = outerIf.getCondition();
        if (condition == null) {
            return;
        }
        PhpPsiElement innerCondition = innerIf.getCondition();
        if (innerCondition == null) {
            return;
        }
        PsiElement mergedCondition = PhpMergeNestedConditionIntention.createMergedCondition(project, condition, innerCondition);
        Statement innerOnlyIfStatement = innerIf.getStatement();
        if (innerOnlyIfStatement == null) {
            return;
        }
        Statement outerStatement = outerIf.getStatement();
        if (outerStatement == null) {
            return;
        }
        PsiComment[] commentsOutsideInnerIf = (PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)outerStatement, PsiComment.class);
        if (commentsOutsideInnerIf != null) {
            for (PsiComment comment : commentsOutsideInnerIf) {
                outerIf.getParent().addBefore((PsiElement)comment, (PsiElement)outerIf);
            }
        }
        condition.replace(mergedCondition);
        outerStatement.replace((PsiElement)innerOnlyIfStatement);
    }

    @NotNull
    private static PsiElement createMergedCondition(@NotNull Project project, @NotNull PhpPsiElement condition, @NotNull PhpPsiElement innerCondition) {
        if (project == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(7);
        }
        if (condition == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(8);
        }
        if (innerCondition == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(9);
        }
        BinaryExpression mergedExpression = PhpPsiElementFactory.createPhpPsiFromText(project, BinaryExpression.class, String.format("(%s) && (%s)", condition.getText(), innerCondition.getText()));
        PhpMergeNestedConditionIntention.unparenthesizeIfNecessary(condition, (ParenthesizedExpression)mergedExpression.getLeftOperand());
        PhpMergeNestedConditionIntention.unparenthesizeIfNecessary(innerCondition, (ParenthesizedExpression)mergedExpression.getRightOperand());
        BinaryExpression binaryExpression = mergedExpression;
        if (binaryExpression == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(10);
        }
        return binaryExpression;
    }

    private static void unparenthesizeIfNecessary(@NotNull PhpPsiElement originalOperand, @Nullable ParenthesizedExpression parenthesizedOperand) {
        if (originalOperand == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(11);
        }
        if (parenthesizedOperand != null && !(originalOperand instanceof ParenthesizedExpression) && PhpUnnecessaryParenthesesInspection.isParensUnnecessary(parenthesizedOperand)) {
            parenthesizedOperand.replace((PsiElement)parenthesizedOperand.unparenthesize());
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = NAME;
        if (string == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpMergeNestedConditionIntention.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpMergeNestedConditionIntention";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerCondition";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalOperand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpMergeNestedConditionIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterAndInnerConditionsToMerge";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergedCondition";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOuterAndInnerConditionsToMerge";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createMergedCondition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unparenthesizeIfNecessary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

