/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.intentions.PhpExtractConditionIntention;
import com.jetbrains.php.lang.intentions.PhpMergeNestedConditionIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpMergeElseIfIntention
extends PsiElementBaseIntentionAction {
    private static final PsiComment[] EMPTY_COMMENTS = new PsiComment[0];

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        Else anElse;
        if (project == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(1);
        }
        if ((anElse = (Else)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)Else.INSTANCEOF)) == null) {
            return false;
        }
        If anIf = PhpMergeNestedConditionIntention.getInnerOnlyIf((PsiElement)anElse.getStatement());
        return anIf != null && (element.getParent() == anElse || element.getParent() == anIf);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Else anElse;
        if (project == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(3);
        }
        if ((anElse = (Else)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)Else.INSTANCEOF)) == null) {
            return;
        }
        If innerIf = PhpMergeNestedConditionIntention.getInnerOnlyIf((PsiElement)anElse.getStatement());
        if (innerIf == null) {
            return;
        }
        Pair<ElseIf, PsiElement> createElseIfAnchors = PhpMergeElseIfIntention.createElseIfAnchors(innerIf);
        PhpMergeElseIfIntention.addCommentsToBody((ElseIf)createElseIfAnchors.first, PhpMergeElseIfIntention.getComments(anElse));
        PhpMergeElseIfIntention.replaceElseWithElseIfBranches(anElse, createElseIfAnchors);
    }

    private static PsiComment @NotNull [] getComments(Else anElse) {
        PhpPsiElement statement = anElse.getStatement();
        PsiComment[] psiCommentArray = (PsiComment[])ObjectUtils.notNull((Object)((PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)(statement instanceof GroupStatement ? statement : anElse), PsiComment.class)), (Object)EMPTY_COMMENTS);
        if (psiCommentArray == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(4);
        }
        return psiCommentArray;
    }

    private static void replaceElseWithElseIfBranches(Else anElse, Pair<ElseIf, PsiElement> createdBranchesAnchors) {
        if (createdBranchesAnchors.first == createdBranchesAnchors.second) {
            anElse.getParent().addBefore((PsiElement)createdBranchesAnchors.first, (PsiElement)anElse);
        } else {
            anElse.getParent().addRangeBefore((PsiElement)createdBranchesAnchors.first, (PsiElement)createdBranchesAnchors.second, (PsiElement)anElse);
        }
        anElse.delete();
    }

    private static void addCommentsToBody(@NotNull ElseIf elseIf, PsiComment @NotNull [] comments) {
        if (elseIf == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(5);
        }
        if (comments == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(6);
        }
        if (comments.length == 0) {
            return;
        }
        Statement statement = elseIf.getStatement();
        if (statement == null) {
            return;
        }
        PsiElement anchor = PhpMergeElseIfIntention.findAnchor(statement);
        PsiElement parent = anchor.getParent();
        anchor = parent.addBefore((PsiElement)comments[0], anchor);
        for (int i = 1; i < comments.length; ++i) {
            anchor = parent.addAfter((PsiElement)comments[i], anchor);
        }
    }

    @NotNull
    private static PsiElement findAnchor(Statement statement) {
        PsiElement lastChild = statement.getLastChild();
        if (statement instanceof GroupStatement && PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.chRBRACE)) {
            PsiElement firstStatement = (PsiElement)((GroupStatement)statement).statements().first();
            PsiElement psiElement = firstStatement != null ? firstStatement : lastChild;
            if (psiElement == null) {
                PhpMergeElseIfIntention.$$$reportNull$$$0(7);
            }
            return psiElement;
        }
        Statement statement2 = statement;
        if (statement2 == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(8);
        }
        return statement2;
    }

    @NotNull
    private static Pair<ElseIf, PsiElement> createElseIfAnchors(If anIf) {
        String textWithoutIfKeyword = PhpExtractConditionIntention.getTextAfterFirstChild((PsiElement)anIf);
        If createdIf = PhpPsiElementFactory.createPhpPsiFromText(anIf.getProject(), If.class, "if (true) {} elseif " + textWithoutIfKeyword);
        ElseIf[] elseIfBranches = createdIf.getElseIfBranches();
        ElseIf firstAnchor = elseIfBranches[0];
        Statement lastAnchor = PhpMergeElseIfIntention.getLastBranch(createdIf, elseIfBranches);
        Pair pair = Pair.create((Object)firstAnchor, (Object)lastAnchor);
        if (pair == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @NotNull
    public static Statement getLastBranch(If createdIf, ElseIf[] elseIfBranches) {
        Statement statement = (Statement)ObjectUtils.notNull((Object)createdIf.getElseBranch(), () -> (Statement)Objects.requireNonNull((ElseIf)ArrayUtil.getLastElement((Object[])elseIfBranches)));
        if (statement == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(10);
        }
        return statement;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("merge.into.elseif", new Object[0]);
        if (string == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpMergeElseIfIntention";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseIf";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpMergeElseIfIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnchor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createElseIfAnchors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastBranch";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCommentsToBody";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

