/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.intentions.PhpReplaceWithAliasIntention;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.refactoring.rename.PhpUseWithAliasRenameProcessor;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInlineAliasIntention
extends BaseElementAtCaretIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PhpUse alias;
        if (project == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(1);
        }
        if ((alias = PhpInlineAliasIntention.findAlias(element)) == null) {
            return;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(element);
        if (scope == null) {
            return;
        }
        Collection<PsiReference> references = PhpCodeInsightUtil.collectReferencesToAlias(alias);
        String name = PhpInlineAliasIntention.inlineAlias(project, alias, scope);
        references.forEach(r -> PhpReplaceWithAliasIntention.replaceReference(project, r, name));
    }

    private static String inlineAlias(@NotNull Project project, @NotNull PhpUse alias, @NotNull PhpPsiElement scope) {
        if (project == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(2);
        }
        if (alias == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(4);
        }
        String fqn = alias.getFQN();
        PhpInlineAliasIntention.processImport(project, alias, scope, fqn);
        return PhpCodeInsightUtil.createQualifiedName(scope, fqn, true, false);
    }

    private static void processImport(@NotNull Project project, @NotNull PhpUse alias, @NotNull PhpPsiElement scope, String fqn) {
        boolean declarationWithSameNameExists;
        if (project == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(5);
        }
        if (alias == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(7);
        }
        String keyword = PhpInlineAliasIntention.getKeyword(alias);
        boolean alreadyImportedWithoutAlias = PhpCodeInsightUtil.findDeclarations(scope, fqn).stream().filter(use -> StringUtil.equals((CharSequence)PhpInlineAliasIntention.getKeyword(use), (CharSequence)keyword)).anyMatch(use -> use.getAliasName() == null);
        String shortName = PhpLangUtil.toShortName(fqn);
        boolean importWithSameNameExists = PhpUseWithAliasRenameProcessor.importsWithSameName(shortName, scope, keyword).anyMatch(d -> !PhpInlineAliasIntention.equals(d, alias));
        PhpUseList list = PhpUseImpl.getUseList((PsiElement)alias);
        if (list == null) {
            return;
        }
        boolean bl = declarationWithSameNameExists = !PhpUseWithAliasRenameProcessor.getConflictDeclarations(list, scope, shortName).isEmpty();
        if (importWithSameNameExists || alreadyImportedWithoutAlias || declarationWithSameNameExists) {
            PhpCodeEditUtil.deleteUseOrUseList(alias, list);
        } else {
            alias.replace((PsiElement)PhpReplaceWithAliasIntention.createUseWithAlias(project, alias, null));
        }
    }

    private static boolean equals(@NotNull PhpUse first, @NotNull PhpUse second) {
        if (first == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(8);
        }
        if (second == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(9);
        }
        return StringUtil.equals((CharSequence)PhpInlineAliasIntention.getKeyword(first), (CharSequence)PhpInlineAliasIntention.getKeyword(second)) && PhpLangUtil.equalsClassNames(first.getFQN(), second.getFQN()) && StringUtil.equals((CharSequence)first.getAliasName(), (CharSequence)second.getAliasName());
    }

    @NotNull
    private static String getKeyword(@NotNull PhpUse first) {
        if (first == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(10);
        }
        String string = PhpGroupUseElement.getKeyword(first, PhpUseImpl.getUseList((PsiElement)first));
        if (string == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(12);
        }
        if (element == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(13);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(element);
        if (scope == null) {
            return false;
        }
        PhpUse useWithAlias = PhpInlineAliasIntention.findAlias(element);
        return useWithAlias != null && useWithAlias.getAliasName() != null && !useWithAlias.isTraitImport();
    }

    @Nullable
    private static PhpUse findAlias(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PhpUse use = (PhpUse)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (use != null) {
            return use;
        }
        PsiReference reference = PhpInlineAliasIntention.getReference(element);
        return reference != null ? PhpTargetElementEvaluator.getElementByReference(reference) : null;
    }

    @Nullable
    private static PsiReference getReference(@NotNull PsiElement element) {
        Object namespaceReference;
        PsiReference firstNamespaceReference;
        if (element == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(14);
        }
        PsiReference psiReference = firstNamespaceReference = (namespaceReference = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF)) != null ? (PsiReference)ArrayUtil.getFirstElement((Object[])namespaceReference.getReferences()) : null;
        if (firstNamespaceReference != null && element.getTextRangeInParent().equals((Object)firstNamespaceReference.getRangeInElement())) {
            return firstNamespaceReference;
        }
        return (PsiReference)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)a -> a instanceof PsiReference), (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpInlineAliasIntention.getTitle();
        if (string == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PhpInlineAliasIntention.getTitle();
        if (string == null) {
            PhpInlineAliasIntention.$$$reportNull$$$0(16);
        }
        return string;
    }

    @IntentionName
    @Nls
    public static String getTitle() {
        return PhpBundle.message("intention.inline.alias", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpInlineAliasIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpInlineAliasIntention";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inlineAlias";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processImport";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getKeyword";
                break;
            }
            case 11: 
            case 15: 
            case 16: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

