/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.injection.PhpInjectionUtil;
import com.jetbrains.php.injection.PhpInjectorBase;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocLangTag;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInjectLanguageIntention
extends PsiElementBaseIntentionAction {
    @IntentionName
    @IntentionFamilyName
    public static final String TEXT = PhpBundle.message("inject.language.using.phpdoc", new Object[0]);
    private static final String LANGUAGE = "text";
    private static final String TEMPLATE = "/** @lang text */";

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement host;
        if (project == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(1);
        }
        if ((host = PhpInjectLanguageIntention.getHost(element)) != null) {
            PsiElement added;
            PhpDocComment phpDoc = PhpInjectorBase.getDocComment(host);
            if (phpDoc == null) {
                PhpDocComment comment = PhpPsiElementFactory.createFromText(project, PhpDocComment.class, TEMPLATE);
                assert (comment != null);
                added = host.getParent().addBefore((PsiElement)comment, host);
            } else {
                PhpDocLangTag tag = PhpPsiElementFactory.createFromText(project, PhpDocLangTag.class, TEMPLATE);
                assert (tag != null);
                added = phpDoc.addBefore((PsiElement)tag, phpDoc.getLastChild());
            }
            int selectionPos = added.getText().indexOf(LANGUAGE);
            if (selectionPos >= 0) {
                int selectionStart = added.getTextOffset() + selectionPos;
                CaretModel caretModel = editor.getCaretModel();
                caretModel.moveToOffset(selectionStart);
                caretModel.moveCaretRelatively(LANGUAGE.length(), 0, true, false, false);
            }
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiElement host;
        if (project == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(3);
        }
        if ((host = PhpInjectLanguageIntention.getHost(element)) != null) {
            PhpDocComment phpDoc = PhpInjectorBase.getDocComment(host);
            Object lang = PhpPsiUtil.getChildByCondition((PsiElement)phpDoc, (Condition<? super PsiElement>)PhpDocLangTag.INSTANCEOF);
            return lang == null;
        }
        return false;
    }

    @Nullable
    private static PsiElement getHost(@NotNull PsiElement element) {
        if (element == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(4);
        }
        PsiElement originalElement = element.getOriginalElement();
        Object stringLiteral = PhpPsiUtil.getParentByCondition(originalElement, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF);
        return PhpInjectionUtil.getLargestStringLiteral(stringLiteral);
    }

    @NotNull
    public String getFamilyName() {
        String string = TEXT;
        if (string == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = TEXT;
        if (string == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpInjectLanguageIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpInjectLanguageIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHost";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

