/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.findUsages.PhpGotoTargetRendererProvider;
import com.jetbrains.php.lang.inspections.classes.PhpAddMethodStubsQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImplementMethodIntention
extends BaseElementAtCaretIntentionAction {
    @Nls
    public static final @NlsContexts.Command String ACTION_NAME = PhpBundle.message("implement.method", new Object[0]);
    private static final Condition<PsiElement> METHOD_CONDITION = Conditions.and((Condition)Method.INSTANCEOF, (Condition)Conditions.not(PhpDocMethod.class::isInstance));

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Method method;
        Collection classes;
        if (project == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(1);
        }
        if ((classes = (Collection)PhpImplementMethodIntention.subClassesWithoutImplementation(project, method = PhpImplementMethodIntention.getMethodAtCaret(element)).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        if (classes.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            PhpImplementMethodIntention.doImplementMethod(project, classes, method);
        } else {
            PhpImplementMethodIntention.createClassesChooserBuilder(project, classes, method).createPopup().showInBestPositionFor(editor);
        }
    }

    @NotNull
    private static IPopupChooserBuilder<PhpClass> createClassesChooserBuilder(Project project, Collection<PhpClass> classes, Method method) {
        PhpGotoTargetRendererProvider.PhpNamedElementPsiElementListCellRenderer renderer = new PhpGotoTargetRendererProvider.PhpNamedElementPsiElementListCellRenderer(false);
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(new ArrayList<PhpClass>(classes)).setSelectionMode(2).setRenderer((ListCellRenderer)((Object)renderer)).setTitle(CodeInsightBundle.message((String)"intention.implement.abstract.method.class.chooser.title", (Object[])new Object[0])).setItemsChosenCallback(selectedClasses -> {
            if (!selectedClasses.isEmpty()) {
                CommandProcessor.getInstance().executeCommand(project, () -> PhpImplementMethodIntention.doImplementMethod(project, selectedClasses, method), ACTION_NAME, null);
            }
        });
        renderer.installSpeedSearch(builder);
        IPopupChooserBuilder iPopupChooserBuilder = builder;
        if (iPopupChooserBuilder == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(2);
        }
        return iPopupChooserBuilder;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void doImplementMethod(Project project, Collection<? extends PhpClass> values, Method method) {
        Method lastAddedMethod;
        Ref lastClass = new Ref();
        List writableClasses = ContainerUtil.filter(values, e -> ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{e.getContainingFile().getVirtualFile()}));
        WriteAction.run(() -> {
            for (PhpClass phpClass : writableClasses) {
                lastClass.set((Object)phpClass);
                PhpAddMethodStubsQuickFix.addMethodStubs(project, phpClass, Collections.singleton(method));
            }
        });
        if (!lastClass.isNull() && (lastAddedMethod = ((PhpClass)lastClass.get()).findOwnMethodByName((CharSequence)method.getName())) != null) {
            PhpCodeUtil.openRelatedFile(project, (PsiElement)lastAddedMethod);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(4);
        }
        return PhpImplementMethodIntention.subClassesWithoutImplementation(project, PhpImplementMethodIntention.getMethodAtCaret(element)).limit(1L).count() > 0L;
    }

    private static Method getMethodAtCaret(@NotNull PsiElement element) {
        if (element == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(5);
        }
        return (Method)PhpPsiUtil.getParentByCondition(element, false, METHOD_CONDITION, (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    private static Stream<PhpClass> subClassesWithoutImplementation(@NotNull Project project, @Nullable Method method) {
        if (project == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(6);
        }
        if (method == null) {
            return Stream.empty();
        }
        PhpClass containingClass = method.getContainingClass();
        if (containingClass == null || !containingClass.isInterface()) {
            return Stream.empty();
        }
        return PhpIndex.getInstance((Project)project).getAllSubclasses(containingClass.getFQN()).stream().filter(e -> !e.isInterface()).filter(e -> e.findOwnMethodByName((CharSequence)method.getName()) == null);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = ACTION_NAME;
        if (string == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpImplementMethodIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpImplementMethodIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassesChooserBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMethodAtCaret";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "subClassesWithoutImplementation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

