/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.PhpNewBaseAction;
import com.jetbrains.php.actions.PhpNewClassDataProvider;
import com.jetbrains.php.actions.PhpNewClassDialog;
import com.jetbrains.php.actions.newClassDataProvider.ClassCreationType;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.classes.PhpAddMethodStubsQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.createClass.PhpCreateClassQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.extract.extractInterface.PhpExtractInterfaceProcessor;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import java.util.Collection;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImplementInterfaceIntention
extends PsiElementBaseIntentionAction {
    public static final BiConsumer<PsiFile, PhpClass> INTERFACE_IMPLEMENTOR = (psiFile, interfaceToImplement) -> {
        PhpClass phpClass = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)psiFile, PhpClass.class);
        if (phpClass != null) {
            Project project = phpClass.getProject();
            PhpImplementInterfaceIntention.implementInterface(project, phpClass, interfaceToImplement);
            PhpCodeUtil.openRelatedFile(project, (PsiElement)psiFile);
        }
    };

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PhpNewClassDataProvider dialog;
        PhpClass phpInterface;
        if (project == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(1);
        }
        if ((phpInterface = PhpImplementInterfaceIntention.getInterface(element)) != null && phpInterface.isValid() && (dialog = this.getDialogDataProvider(project, element.getContainingFile(), phpInterface)) != null) {
            PhpNewBaseAction.createFile(project, dialog, (Consumer<? super PsiFile>)((Consumer)psiFile -> INTERFACE_IMPLEMENTOR.accept((PsiFile)psiFile, phpInterface)), PhpImplementInterfaceIntention.getTitle());
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(3);
        }
        return element.getContainingFile() instanceof PhpFile && PhpPsiUtil.isOfType(element, Holder.ACCEPTED_TYPES) && PhpImplementInterfaceIntention.getInterface(element) != null;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpImplementInterfaceIntention.getTitle();
        if (string == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PhpImplementInterfaceIntention.getTitle();
        if (string == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    protected PhpNewClassDataProvider getDialogDataProvider(@NotNull Project project, @NotNull PsiFile file, @NotNull PhpClass interfaceToImplement) {
        PhpNewClassDialog dialog;
        if (project == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(6);
        }
        if (file == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(7);
        }
        if (interfaceToImplement == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(8);
        }
        return (dialog = PhpImplementInterfaceIntention.getDialog(project, file, interfaceToImplement)).showAndGet() ? dialog : null;
    }

    @NotNull
    private static PhpNewClassDialog getDialog(final @NotNull Project project, @NotNull PsiFile file, final @NotNull PhpClass interfaceToImplement) {
        if (project == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(9);
        }
        if (file == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(10);
        }
        if (interfaceToImplement == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(11);
        }
        return new PhpNewClassDialog(project, file.getContainingDirectory()){

            @Override
            protected void init() {
                super.init();
                this.myTemplateComboBox.setEnabled(false);
                ActionUtil.clearActions((JComponent)this.myNameTextField);
                String implementorName = interfaceToImplement.getName() + "Impl";
                this.setData(implementorName, ClassCreationType.CLASS, implementorName, PhpLangUtil.toName(interfaceToImplement.getNamespaceName()));
                this.myDirectoryCombobox.setDirectoryProvider(PhpDirectoryByPsrProvider.getDefaultProvider());
            }

            @Override
            @NotNull
            public Properties getProperties(@NotNull PsiDirectory directory) {
                if (directory == null) {
                    1.$$$reportNull$$$0(0);
                }
                Properties properties = PhpCreateClassQuickFix.getDefaultDialogProperties(project, this);
                if (properties == null) {
                    1.$$$reportNull$$$0(1);
                }
                return properties;
            }

            @Override
            public boolean canInheritSuperClasses() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "directory";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpImplementInterfaceIntention$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpImplementInterfaceIntention$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProperties";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getProperties";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void implementInterface(@NotNull Project project, @NotNull PhpClass phpClass, @NotNull PhpClass interfaceToImplement) {
        PhpPsiElement scope;
        if (project == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(12);
        }
        if (phpClass == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(13);
        }
        if (interfaceToImplement == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(14);
        }
        String interfaceQualifiedName = (scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)phpClass)) != null ? PhpCodeInsightUtil.createQualifiedName(scope, interfaceToImplement.getFQN()) : interfaceToImplement.getFQN();
        PhpExtractInterfaceProcessor.addImplementClause(project, phpClass, interfaceQualifiedName);
        PhpAddMethodStubsQuickFix.addMethodStubs(project, phpClass, PhpImplementInterfaceIntention.getMethodsToImplement(phpClass, interfaceToImplement));
    }

    private static Collection<Method> getMethodsToImplement(@NotNull PhpClass phpClass, @NotNull PhpClass interfaceToImplement) {
        if (phpClass == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(15);
        }
        if (interfaceToImplement == null) {
            PhpImplementInterfaceIntention.$$$reportNull$$$0(16);
        }
        return ContainerUtil.filter((Collection)interfaceToImplement.getMethods(), method -> phpClass.findOwnMethodByName((CharSequence)method.getName()) == null);
    }

    @Nullable
    protected static PhpClass getInterface(PsiElement element) {
        return (PhpClass)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)Conditions.not(parent -> parent instanceof PhpClass && ((PhpClass)parent).isInterface()));
    }

    @IntentionFamilyName
    public static String getTitle() {
        return PhpBundle.message("intention.implement.interface", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpImplementInterfaceIntention";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceToImplement";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpImplementInterfaceIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDialogDataProvider";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDialog";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "implementInterface";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsToImplement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final TokenSet ACCEPTED_TYPES = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwINTERFACE, PhpTokenTypes.IDENTIFIER, PhpElementTypes.MODIFIER_LIST});

        private Holder() {
        }
    }
}

