/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.actions.generation.PhpGeneratePhpDocBlocksAction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpChangeVisibilityIntentionBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpGenerateDocBlockIntention
extends PsiElementBaseIntentionAction {
    private static final Condition<PsiElement> FUNCTION_CONDITION = Conditions.and((Condition)Function.INSTANCEOF, (Condition)Conditions.not(PhpDocMethod.class::isInstance));
    private static final Condition<PsiElement> FIELD_CONDITION = Conditions.and((Condition)Field.INSTANCEOF, e -> PhpPsiUtil.isOfType(e.getParent(), PhpElementTypes.CLASS_FIELDS));
    private static final Condition<PsiElement> FIELD_OR_FUNCTION_CONDITION = Conditions.or(FIELD_CONDITION, FUNCTION_CONDITION);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement targetElement;
        if (project == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(1);
        }
        if ((targetElement = PhpGenerateDocBlockIntention.getElement(element)) instanceof Function) {
            PhpGenerateDocBlockIntention.addComment(project, editor, targetElement);
        } else if (targetElement instanceof Field) {
            PhpClassFieldsList classFields = ((Field)targetElement).getParentList();
            if (classFields == null) {
                return;
            }
            if (PhpHierarchyChecksInspection.isGroupedDeclarations(classFields)) {
                Field extractedField = PhpGenerateDocBlockIntention.extractFieldFromGroupedDeclaration(project, (Field)targetElement, (PsiElement)classFields);
                PhpGenerateDocBlockIntention.addComment(project, editor, (PsiElement)extractedField);
            } else {
                PhpGenerateDocBlockIntention.addComment(project, editor, targetElement);
            }
        }
    }

    @Nullable
    private static Field extractFieldFromGroupedDeclaration(@NotNull Project project, @NotNull Field field, @NotNull PsiElement classFields) {
        if (project == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(2);
        }
        if (field == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(3);
        }
        if (classFields == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(4);
        }
        String defaultValue = PhpChangeVisibilityIntentionBase.getDefaultValueText(field);
        PhpPsiElement newField = PhpPsiElementFactory.createClassField(project, field.getModifier(), field.getName(), defaultValue, PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, field.getDeclaredType(), (PsiElement)field));
        PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)field, PhpTokenTypes.opCOMMA);
        PsiElement addedField = classFields.getParent().addBefore((PsiElement)newField, classFields);
        return (Field)PhpPsiUtil.getChildByCondition(addedField, (Condition<? super PsiElement>)Field.INSTANCEOF);
    }

    private static void addComment(@NotNull Project project, Editor editor, @Nullable PsiElement targetElement) {
        PsiElement beforeElement;
        if (project == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(5);
        }
        PhpDocComment comment = PhpDocCommentGenerator.constructDocComment(project, targetElement, true);
        if (targetElement != null && comment != null && (beforeElement = PhpGeneratePhpDocBlocksAction.PhpGeneratePhpDocBlocksActionHandler.getBeforeElement(targetElement)) != null) {
            TextRange docRange = PhpCodeEditUtil.insertDocCommentBeforeAndGetTextRange(beforeElement, comment);
            if (editor != null) {
                PhpDocCommentGenerator.tryMoveCaretOnMarker(editor, docRange);
            }
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiElement prev;
        PsiElement beforeElement;
        PsiElement targetElement;
        if (project == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(7);
        }
        if ((targetElement = PhpGenerateDocBlockIntention.getElement(element)) != null && (beforeElement = PhpGeneratePhpDocBlocksAction.PhpGeneratePhpDocBlocksActionHandler.getBeforeElement(targetElement)) != null && !((prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(beforeElement, true)) instanceof PhpDocComment)) {
            this.setText(PhpGenerateDocBlockIntention.getNameText());
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement getElement(PsiElement element) {
        return PhpPsiUtil.getParentByCondition(element, false, FIELD_OR_FUNCTION_CONDITION, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpGenerateDocBlockIntention.getNameText();
        if (string == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    @IntentionFamilyName
    public static String getNameText() {
        return PhpBundle.message("intention.generate.phpdoc", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFields";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpGenerateDocBlockIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpGenerateDocBlockIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractFieldFromGroupedDeclaration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addComment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

