/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.GroupStatementImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractConditionIntention
extends BaseElementAtCaretIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(1);
        }
        If anIf = (If)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)If.class::isInstance));
        BinaryExpression expression = anIf != null ? (BinaryExpression)ObjectUtils.tryCast((Object)anIf.getCondition(), BinaryExpression.class) : null;
        Collection<PhpExpression> operands = PhpExtractConditionIntention.getLogicalOperands((PhpExpression)expression, null);
        if (operands.size() <= 1) {
            return false;
        }
        PhpExpression operand = PhpExtractConditionIntention.findOperand(element, operands);
        if (operand == null) {
            return false;
        }
        this.setText(PhpBundle.message("intention.name.extract.if", operand.getText()));
        return true;
    }

    @Nullable
    private static PhpExpression findOperand(@Nullable PsiElement element, PhpExpression expression) {
        return PhpExtractConditionIntention.findOperand(element, PhpExtractConditionIntention.getLogicalOperands(expression, null));
    }

    @Nullable
    private static PhpExpression findOperand(@Nullable PsiElement element, Collection<PhpExpression> operands) {
        if (element == null) {
            return null;
        }
        return (PhpExpression)ContainerUtil.find(operands, operand -> PsiTreeUtil.isAncestor((PsiElement)operand, (PsiElement)element, (boolean)false));
    }

    @NotNull
    private static Collection<PhpExpression> getLogicalOperands(@Nullable PhpExpression expression, @Nullable IElementType parentTokenType) {
        BinaryExpression binaryExpression = (BinaryExpression)ObjectUtils.tryCast((Object)expression, BinaryExpression.class);
        if (binaryExpression == null) {
            List<Object> list = expression != null ? Collections.singletonList(expression) : Collections.emptyList();
            if (list == null) {
                PhpExtractConditionIntention.$$$reportNull$$$0(2);
            }
            return list;
        }
        IElementType type = binaryExpression.getOperationType();
        if (!Holder.SUPPORTED_LOGICAL_TOKENS.contains(type)) {
            List<PhpExpression> list = Collections.emptyList();
            if (list == null) {
                PhpExtractConditionIntention.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (type == PhpTokenTypes.opAND && parentTokenType == PhpTokenTypes.opOR) {
            List<PhpExpression> list = Collections.singletonList(expression);
            if (list == null) {
                PhpExtractConditionIntention.$$$reportNull$$$0(4);
            }
            return list;
        }
        SmartList expressions = new SmartList();
        expressions.addAll(PhpExtractConditionIntention.getLogicalOperands((PhpExpression)ObjectUtils.tryCast((Object)binaryExpression.getLeftOperand(), PhpExpression.class), type));
        expressions.addAll(PhpExtractConditionIntention.getLogicalOperands((PhpExpression)ObjectUtils.tryCast((Object)binaryExpression.getRightOperand(), PhpExpression.class), type));
        SmartList smartList = expressions;
        if (smartList == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PhpExpression expression;
        if (project == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(7);
        }
        If anIf = (If)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)If.class::isInstance));
        PhpExpression phpExpression = expression = anIf != null ? (PhpExpression)ObjectUtils.tryCast((Object)anIf.getCondition(), PhpExpression.class) : null;
        if (expression == null) {
            return;
        }
        PhpExpression operand = PhpExtractConditionIntention.findOperand(element, expression);
        if (operand == null) {
            return;
        }
        BinaryExpression binaryExpression = (BinaryExpression)ObjectUtils.tryCast((Object)operand.getParent(), BinaryExpression.class);
        if (binaryExpression == null || !Holder.SUPPORTED_LOGICAL_TOKENS.contains(binaryExpression.getOperationType())) {
            return;
        }
        if (binaryExpression.getOperationType() == PhpTokenTypes.opAND) {
            PhpExtractConditionIntention.extractOperandFromConjunction(anIf, binaryExpression, operand);
        } else {
            PhpExtractConditionIntention.extractOperandFromDisjunction(anIf, binaryExpression, operand);
        }
    }

    private static void extractOperandFromConjunction(@NotNull If anIf, @NotNull BinaryExpression operandExpression, @NotNull PhpExpression operand) {
        if (anIf == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(8);
        }
        if (operandExpression == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(9);
        }
        if (operand == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(10);
        }
        If ifWithoutOperandInCondition = PhpExtractConditionIntention.createIfWithoutOperandInCondition(anIf, operandExpression, operand);
        PhpPsiElement condition = anIf.getCondition();
        Statement statement = anIf.getStatement();
        if (condition == null || statement == null) {
            return;
        }
        condition.replace(PhpPsiUtil.unparenthesize((PsiElement)operand));
        statement.replace(PhpExtractConditionIntention.createInnerStatement(anIf.getProject(), ifWithoutOperandInCondition, statement));
    }

    private static PsiElement createInnerStatement(Project project, If ifWithoutOperandInCondition, Statement statement) {
        if (statement instanceof GroupStatement) {
            return PhpPsiElementFactory.createPhpPsiFromText(project, GroupStatementImpl.class, "{" + ifWithoutOperandInCondition.getText() + "}");
        }
        return ifWithoutOperandInCondition;
    }

    @NotNull
    private static If createIfWithoutOperandInCondition(@NotNull If anIf, @NotNull BinaryExpression operandExpression, @NotNull PhpExpression operand) {
        PsiElement oppositeOperandCopy;
        if (anIf == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(11);
        }
        if (operandExpression == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(12);
        }
        if (operand == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(13);
        }
        If copiedIf = (If)anIf.copy();
        PhpPsiElement condition = anIf.getCondition();
        assert (condition != null);
        TextRange operandExpressionRangeInsideCondition = PhpExtractConditionIntention.getRangeInsideCondition(operandExpression, condition);
        PhpPsiElement copiedCondition = copiedIf.getCondition();
        assert (copiedCondition != null);
        BinaryExpression operandExpressionCopy = PhpExtractConditionIntention.findConditionBinaryExpression(copiedCondition).stream().filter(expression -> PhpExtractConditionIntention.getRangeInsideCondition(expression, copiedCondition).equals((Object)operandExpressionRangeInsideCondition)).findFirst().orElseThrow(() -> new IllegalStateException("Invalid condition: " + copiedCondition.getText()));
        PhpExpression operandCopy = PhpExtractConditionIntention.findOperand(operandExpressionCopy.findElementAt(operand.getStartOffsetInParent()), (PhpExpression)operandExpressionCopy);
        assert (operandCopy != null);
        PsiElement psiElement = oppositeOperandCopy = operandExpressionCopy.getLeftOperand() == operandCopy ? operandExpressionCopy.getRightOperand() : operandExpressionCopy.getLeftOperand();
        assert (oppositeOperandCopy != null);
        operandExpressionCopy.replace(PhpPsiUtil.unparenthesize(oppositeOperandCopy));
        If if_ = copiedIf;
        if (if_ == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(14);
        }
        return if_;
    }

    @NotNull
    private static Collection<BinaryExpression> findConditionBinaryExpression(PhpPsiElement condition) {
        ArrayList<BinaryExpression> result = new ArrayList<BinaryExpression>(PsiTreeUtil.findChildrenOfType((PsiElement)condition, BinaryExpression.class));
        result.add((BinaryExpression)condition);
        ArrayList<BinaryExpression> arrayList = result;
        if (arrayList == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private static TextRange getRangeInsideCondition(@NotNull BinaryExpression operandExpression, @NotNull PhpPsiElement condition) {
        if (operandExpression == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(16);
        }
        if (condition == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(17);
        }
        TextRange textRange = operandExpression.getTextRange().shiftLeft(condition.getTextRange().getStartOffset());
        if (textRange == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(18);
        }
        return textRange;
    }

    private static void extractOperandFromDisjunction(@NotNull If anIf, @NotNull BinaryExpression binaryExpression, @NotNull PhpExpression operand) {
        PhpPsiElement condition;
        if (anIf == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(19);
        }
        if (binaryExpression == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(20);
        }
        if (operand == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(21);
        }
        if ((condition = anIf.getCondition()) == null) {
            return;
        }
        PhpExtractConditionIntention.addElseIfBranch(anIf, PhpExtractConditionIntention.createElseIfWithoutOperandInCondition(anIf, binaryExpression, operand));
        condition.replace(PhpPsiUtil.unparenthesize((PsiElement)operand));
    }

    private static void addElseIfBranch(@NotNull If anIf, @NotNull ElseIf elseIfWithoutOperandInCondition) {
        if (anIf == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(22);
        }
        if (elseIfWithoutOperandInCondition == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(23);
        }
        ElseIf[] elseIfBranches = anIf.getElseIfBranches();
        Else elseBranch = anIf.getElseBranch();
        if (elseIfBranches.length > 0) {
            anIf.addBefore((PsiElement)elseIfWithoutOperandInCondition, (PsiElement)elseIfBranches[0]);
        } else if (elseBranch != null) {
            anIf.addBefore((PsiElement)elseIfWithoutOperandInCondition, (PsiElement)elseBranch);
        } else {
            anIf.add((PsiElement)elseIfWithoutOperandInCondition);
        }
    }

    @NotNull
    private static ElseIf createElseIfWithoutOperandInCondition(@NotNull If anIf, @NotNull BinaryExpression operandExpression, @NotNull PhpExpression operand) {
        if (anIf == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(24);
        }
        if (operandExpression == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(25);
        }
        if (operand == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(26);
        }
        If ifWithoutOperand = PhpExtractConditionIntention.createIfWithoutOperandInCondition(anIf, operandExpression, operand);
        String textWithoutIfKeyword = PhpExtractConditionIntention.getTextAfterFirstChild((PsiElement)ifWithoutOperand);
        ElseIf elseIf = PhpPsiElementFactory.createPhpPsiFromText(anIf.getProject(), If.class, "if (true) {} elseif " + textWithoutIfKeyword).getElseIfBranches()[0];
        if (elseIf == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(27);
        }
        return elseIf;
    }

    @NotNull
    public static String getTextAfterFirstChild(@NotNull PsiElement ifWithoutOperand) {
        if (ifWithoutOperand == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(28);
        }
        String string = ifWithoutOperand.getText().substring(ifWithoutOperand.getFirstChild().getTextRangeInParent().getEndOffset());
        if (string == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("extract.condition", new Object[0]);
        if (string == null) {
            PhpExtractConditionIntention.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 18: 
            case 27: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 18: 
            case 27: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 18: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpExtractConditionIntention";
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anIf";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandExpression";
                break;
            }
            case 10: 
            case 13: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseIfWithoutOperandInCondition";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifWithoutOperand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpExtractConditionIntention";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalOperands";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createIfWithoutOperandInCondition";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findConditionBinaryExpression";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInsideCondition";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createElseIfWithoutOperandInCondition";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAfterFirstChild";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 18: 
            case 27: 
            case 29: 
            case 30: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractOperandFromConjunction";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createIfWithoutOperandInCondition";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInsideCondition";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extractOperandFromDisjunction";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addElseIfBranch";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createElseIfWithoutOperandInCondition";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTextAfterFirstChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 18: 
            case 27: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final TokenSet SUPPORTED_LOGICAL_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opAND, PhpTokenTypes.opOR});

        private Holder() {
        }
    }
}

