/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.phpdoc.PhpRedundantDocCommentInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.intentions.PhpUndefinedInConstructorIntentionBase;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDeclareFieldIntention
extends PhpUndefinedInConstructorIntentionBase {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(1);
        }
        PhpClass klazz = (PhpClass)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        FieldReference reference = (FieldReference)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)FieldReference.INSTANCEOF);
        if (reference != null) {
            String name = reference.getName();
            if (klazz != null && name != null) {
                PhpDeclareFieldIntention.insertFieldFromUsage(project, klazz, (MemberReference)reference, name);
            }
        }
    }

    public static void insertFieldFromUsage(@NotNull Project project, @NotNull PhpClass klazz, @NotNull MemberReference fieldReference, @NotNull String name) {
        PhpDocComment comment;
        PhpType type;
        PsiElement field;
        PsiElement insertedField;
        if (project == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(2);
        }
        if (klazz == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(3);
        }
        if (fieldReference == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(5);
        }
        if ((insertedField = PhpAddFieldDeclarationQuickFix.addFieldToClass(klazz, field = PhpAddFieldDeclarationQuickFix.createField(project, klazz, name, type = fieldReference.getGlobalType(), fieldReference.getReferenceType().isStatic()), comment = PhpDeclareFieldIntention.getDocComment(project, field, klazz, type))) != null) {
            PhpAddFieldDeclarationQuickFix.runTemplate(insertedField, PhpAddFieldDeclarationQuickFix.createFieldTemplate(insertedField), null);
        }
    }

    @Nullable
    public static PhpDocComment getDocComment(@NotNull Project project, @Nullable PsiElement classFields, @NotNull PhpClass klazz, @NotNull PhpType docType) {
        if (project == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(6);
        }
        if (klazz == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(7);
        }
        if (docType == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(8);
        }
        if (!PhpDocCommentGenerator.isTemplateNullOrEmpty(classFields)) {
            String typeHint = PhpDocUtil.getTypePresentation(project, docType, PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)klazz));
            HashMap<String, String> additionalAttributes = new HashMap<String, String>();
            additionalAttributes.put("TYPE_HINT", typeHint);
            additionalAttributes.put("CLASS_NAME", klazz.getName());
            PhpDocComment docComment = PhpDocCommentGenerator.constructDocComment(project, classFields, additionalAttributes);
            Field field = (Field)PhpPsiUtil.getChildByCondition(classFields, (Condition<? super PsiElement>)Field.INSTANCEOF);
            if (field != null && docComment != null && !PhpRedundantDocCommentInspection.isRedundantPropertyDocComment(project, field, docComment)) {
                return docComment;
            }
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpDeclareFieldIntention.getFamilyNameText();
        if (string == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    @IntentionFamilyName
    public static String getFamilyNameText() {
        return PhpBundle.message("intention.declare.missing.field", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpDeclareFieldIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpDeclareFieldIntention";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertFieldFromUsage";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDocComment";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

