/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpUndefinedVariableInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConvertShortArrowFunctionToClosureIntention
extends BaseElementAtCaretIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element) || !PhpLanguageFeature.ARROW_FUNCTION_SYNTAX.isSupported(project)) {
            return false;
        }
        Function function = (Function)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)Function.INSTANCEOF);
        return function != null && function.isClosure() && FunctionImpl.isShortArrowFunction(function);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(3);
        }
        Function function = (Function)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)Function.INSTANCEOF);
        PhpConvertShortArrowFunctionToClosureIntention.convertArrowFunctionToClosure(project, function);
    }

    public static void convertArrowFunctionToClosure(@NotNull Project project, Function function) {
        if (project == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(4);
        }
        if (function == null) {
            return;
        }
        PsiElement kwFN = PhpConvertShortArrowFunctionToClosureIntention.findNode((PsiElement)function, PhpTokenTypes.kwFN);
        if (kwFN == null) {
            return;
        }
        Parameter[] parameters = function.getParameters();
        Variable[] externalVariables = (Variable[])((StreamEx)StreamEx.of((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)function, Variable.class)).filter(e -> PhpConvertShortArrowFunctionToClosureIntention.shouldBeAddedToUseList(e, parameters))).toArray(Variable.class);
        PsiElement opHash = PhpConvertShortArrowFunctionToClosureIntention.findNode((PsiElement)function, PhpTokenTypes.opHASH_ARRAY);
        if (opHash == null) {
            return;
        }
        PsiElement returnArgument = FunctionImpl.getShortArrowFunctionArgument(function);
        if (returnArgument == null) {
            return;
        }
        kwFN.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.kwFUNCTION, "function () {}"));
        opHash.delete();
        PhpReturn returnStatement = (PhpReturn)returnArgument.replace((PsiElement)PhpPsiElementFactory.createReturnStatement(project, returnArgument.getText()));
        PhpRefactoringUtil.wrapWithBraces(project, (Statement)returnStatement);
        if (externalVariables.length > 0) {
            PhpUndefinedVariableInspection.addUseListWithVariables(project, function, externalVariables);
        }
    }

    private static boolean shouldBeAddedToUseList(@NotNull Variable e, Parameter[] parameters) {
        if (e == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(5);
        }
        return StringUtil.isNotEmpty((String)e.getName()) && PhpAnnotatorVisitor.canBeUsedAsLexicalVariable(e) && !ArrayUtil.contains((Object)e.resolve(), (Object[])parameters);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("convert.the.arrow.function.to.a.traditional.closure", new Object[0]);
        if (string == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static PsiElement findNode(PsiElement element, IElementType elementType) {
        ASTNode fnNode = element.getNode().findChildByType(elementType);
        return fnNode != null ? fnNode.getPsi() : null;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpConvertShortArrowFunctionToClosureIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpConvertShortArrowFunctionToClosureIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertArrowFunctionToClosure";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeAddedToUseList";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

