/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpWrongForeachArgumentTypeInspection
extends PhpInspection {
    private static final PhpType UNSUPPORTED_TYPE_SET = new PhpType();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpWrongForeachArgumentTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpForeach(ForeachStatement foreach) {
                PsiElement argument = foreach.getArgument();
                if (argument instanceof PhpTypedElement) {
                    Project project = argument.getProject();
                    PhpType argumentType = ((PhpTypedElement)argument).getGlobalType();
                    if (PhpType.isSubType((PhpType)argumentType, (PhpType)UNSUPPORTED_TYPE_SET)) {
                        String errorMessage = isOnTheFly ? PhpBundle.message("inspection.wrong.foreach.argument.type.problem", argumentType.toStringResolved()) : PhpWrongForeachArgumentTypeInspection.getErrorBatch();
                        holder.registerProblem(argument, errorMessage, new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    @InspectionMessage
    private static String getErrorBatch() {
        return PhpBundle.message("inspection.wrong.foreach.argument.type.problem.batch", new Object[0]);
    }

    static {
        UNSUPPORTED_TYPE_SET.add(PhpType.STRING);
        UNSUPPORTED_TYPE_SET.add(PhpType.FLOAT);
        UNSUPPORTED_TYPE_SET.add(PhpType.INT);
        UNSUPPORTED_TYPE_SET.add(PhpType.BOOLEAN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/type/PhpWrongForeachArgumentTypeInspection", "buildVisitor"));
    }
}

