/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeParameterTypeQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeReturnTypeQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpIncompatibleReturnTypeInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStrictTypeCheckingInspection
extends PhpInspection {
    public boolean ENABLE_WITHOUT_DECLARE_STRICT_DIRECTIVE;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        PhpFile file;
        if (holder == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(0);
        }
        if ((file = (PhpFile)ObjectUtils.tryCast((Object)holder.getFile(), PhpFile.class)) == null || !this.ENABLE_WITHOUT_DECLARE_STRICT_DIRECTIVE && !PhpCodeInsightUtil.isStrictTypes(file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpStrictTypeCheckingInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new PhpElementVisitor(){

            public void visitPhpReturn(PhpReturn returnStatement) {
                PsiElement returnArgument = returnStatement.getArgument();
                Condition stopAt = Conditions.or((Condition)PhpClass.INSTANCEOF, (Condition)PhpNamespace.INSTANCEOF);
                Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)returnStatement, true, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)stopAt);
                if (function == null) {
                    return;
                }
                this.checkStrictReturnTypeCompatibility(function, returnArgument, (PsiElement)returnStatement);
            }

            public void visitPhpFunction(Function function) {
                if (function.isClosure() && FunctionImpl.isShortArrowFunction(function)) {
                    PsiElement returnArgument = FunctionImpl.getShortArrowFunctionArgument(function);
                    if (returnArgument == null) {
                        return;
                    }
                    this.checkStrictReturnTypeCompatibility(function, returnArgument, returnArgument);
                }
            }

            private void checkStrictReturnTypeCompatibility(@NotNull Function function, @Nullable PsiElement returnArgument, @NotNull PsiElement elementToHighlight) {
                Project project;
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (elementToHighlight == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!PhpLanguageFeature.RETURN_TYPES.isSupported(project = function.getProject())) {
                    return;
                }
                PhpType declaredType = function.getDeclaredType();
                if (PhpType.intersects((PhpType)declaredType, (PhpType)PhpType.SCALAR)) {
                    List<PsiElement> arguments = PhpIncompatibleReturnTypeInspection.collectArgumentsContributingToReturnType(returnArgument);
                    for (PsiElement argument : arguments) {
                        Object inferredType = argument instanceof PhpTypedElement ? ((PhpTypedElement)argument).getGlobalType().filterUnknown() : (argument == null ? PhpType.VOID : null);
                        if (inferredType == null || PhpStrictTypeCheckingInspection.canAcceptInner(declaredType, inferredType) || PhpType.NULL.equals(inferredType)) continue;
                        holder.registerProblem(arguments.size() == 1 || argument == null ? elementToHighlight : argument, isOnTheFly ? PhpBundle.message("inspection.strict.type.checking.return", declaredType, inferredType.toStringRelativized(function.getNamespaceName())) : PhpBundle.message("inspection.strict.type.checking.return.batch", new Object[0]), new LocalQuickFix[]{this.getReturnTypeFix(project, declaredType, (PhpType)inferredType)});
                    }
                }
            }

            @Nullable
            private PhpChangeReturnTypeQuickFix getReturnTypeFix(@NotNull Project project, @NotNull PhpType declaredType, @NotNull PhpType inferredType) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (declaredType == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (inferredType == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (PhpType.VOID.equals((Object)inferredType)) {
                    return null;
                }
                if (inferredType.filterNull().size() > 1 && !PhpLanguageFeature.UNION_TYPES.isSupported(project)) {
                    return null;
                }
                return new PhpChangeReturnTypeQuickFix(project, declaredType, inferredType);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.visitFunctionCall((ParameterListOwner)reference, (PhpReference)reference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.visitFunctionCall((ParameterListOwner)reference, (PhpReference)reference);
            }

            public void visitPhpNewExpression(NewExpression expression) {
                ClassReference reference = expression.getClassReference();
                if (reference != null) {
                    this.visitFunctionCall((ParameterListOwner)expression, (PhpReference)reference);
                }
            }

            public void visitPhpAttribute(PhpAttribute attribute) {
                ClassReference reference = attribute.getClassReference();
                if (reference != null) {
                    this.visitFunctionCall((ParameterListOwner)attribute, (PhpReference)reference);
                }
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                PhpType assignedValueType;
                PhpType fieldType;
                Field field;
                Project project = assignmentExpression.getProject();
                if (!PhpLanguageFeature.TYPED_PROPERTIES.isSupported(project)) {
                    return;
                }
                FieldReference fieldReference = (FieldReference)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), FieldReference.class);
                PhpTypedElement assignedValue = (PhpTypedElement)ObjectUtils.tryCast((Object)assignmentExpression.getValue(), PhpTypedElement.class);
                if (fieldReference != null && assignedValue != null && (field = (Field)ObjectUtils.tryCast((Object)fieldReference.resolve(), Field.class)) != null && !field.isConstant() && !(field instanceof PhpDocProperty) && PhpType.intersects((PhpType)(fieldType = field.getDeclaredType()), (PhpType)PhpType.SCALAR) && !PhpStrictTypeCheckingInspection.canAcceptInner(fieldType, assignedValueType = assignedValue.getGlobalType().filterUnknown())) {
                    holder.registerProblem((PsiElement)assignmentExpression, PhpBundle.message("inspection.strict.type.checking.field.assignment", fieldType, assignedValueType), new LocalQuickFix[0]);
                }
            }

            private void visitFunctionCall(@NotNull ParameterListOwner parameterListOwner, @NotNull PhpReference reference) {
                Project project;
                if (parameterListOwner == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (reference == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (!PhpLanguageFeature.SCALAR_TYPE_HINTS.isSupported(project = parameterListOwner.getProject())) {
                    return;
                }
                List arguments = (List)PhpStrictTypeCheckingInspection.unwrapSpreadOperator(parameterListOwner.getParameters()).collect(Collectors.toList());
                if (arguments.isEmpty()) {
                    return;
                }
                Collection results = (Collection)((StreamEx)((StreamEx)StreamEx.of((Object[])reference.multiResolve(false)).filter(ResolveResult::isValidResult)).map(ResolveResult::getElement).select(Function.class).map(f -> new FunctionParametersHolder((Function)f, arguments)).filter(FunctionParametersHolder::isValid)).collect(Collectors.toList());
                if (results.isEmpty()) {
                    return;
                }
                for (int i = 0; i < arguments.size(); ++i) {
                    int index = i;
                    PsiElement argument = (PsiElement)arguments.get(i);
                    List descriptors = ContainerUtil.map((Collection)results, r -> this.checkProblemsInArgumentAtIndex(project, arguments, results, (FunctionParametersHolder)r, index));
                    if (!descriptors.isEmpty() && !descriptors.contains(null)) {
                        if (descriptors.size() == 1) {
                            holder.registerProblem((ProblemDescriptor)descriptors.get(0));
                        } else {
                            holder.registerProblem(argument, PhpBundle.message("inspection.strict.type.checking.parameter.batch", new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                    if (PhpCodeInsightUtil.isUnpackedArgument(argument)) break;
                }
            }

            @Nullable
            private ProblemDescriptor checkProblemsInArgumentAtIndex(Project project, List<PsiElement> arguments, Collection<FunctionParametersHolder> results, FunctionParametersHolder functionParameters, int i) {
                PhpType inferredType;
                PsiElement referenceParameter = arguments.get(i);
                if (!(referenceParameter instanceof PhpTypedElement)) {
                    return null;
                }
                Parameter parameter = functionParameters.getParameter(i);
                PhpType declaredType = functionParameters.getDeclaredType(parameter);
                if (PhpType.intersects((PhpType)declaredType, (PhpType)PhpType.SCALAR) && !PhpStrictTypeCheckingInspection.isTypeCompatible(declaredType, inferredType = PhpParamsInspection.unpluraliseSpreadArguments(((PhpTypedElement)referenceParameter).getGlobalType().filterUnknown(), referenceParameter))) {
                    return InspectionManager.getInstance((Project)project).createProblemDescriptor(referenceParameter, isOnTheFly ? PhpBundle.message("inspection.strict.type.checking.parameter", declaredType, inferredType.toStringRelativized(functionParameters.getFunction().getNamespaceName())) : PhpBundle.message("inspection.strict.type.checking.parameter.batch", new Object[0]), isOnTheFly, this.getParamFixes(parameter, results, PhpCodeInsightUtil.getParameterIndex((PsiElement)parameter), referenceParameter, declaredType, inferredType), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
                return null;
            }

            private LocalQuickFix @NotNull [] getParamFixes(@NotNull Parameter parameter, Collection<FunctionParametersHolder> results, int i, @NotNull PsiElement referenceParameter, @NotNull PhpType declaredType, @NotNull PhpType inferredType) {
                if (parameter == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (referenceParameter == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (declaredType == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (inferredType == null) {
                    1.$$$reportNull$$$0(10);
                }
                Object[] fixes = PhpParamsInspection.getFixes(referenceParameter, inferredType, declaredType);
                Project project = parameter.getProject();
                if (PhpType.VOID.equals((Object)inferredType) || results.size() != 1) {
                    if (fixes == null) {
                        1.$$$reportNull$$$0(11);
                    }
                    return fixes;
                }
                if (inferredType.filterNull().size() > 1 && !PhpLanguageFeature.UNION_TYPES.isSupported(project)) {
                    if (fixes == null) {
                        1.$$$reportNull$$$0(12);
                    }
                    return fixes;
                }
                if (inferredType.isNullable() && !PhpLanguageFeature.NULLABLES.isSupported(project)) {
                    if (fixes == null) {
                        1.$$$reportNull$$$0(13);
                    }
                    return fixes;
                }
                PhpTypedElement typedDefaultValue = (PhpTypedElement)ObjectUtils.tryCast((Object)parameter.getDefaultValue(), PhpTypedElement.class);
                if (typedDefaultValue != null && !PhpStrictTypeCheckingInspection.isTypeCompatible(typedDefaultValue.getGlobalType(), inferredType)) {
                    if (fixes == null) {
                        1.$$$reportNull$$$0(14);
                    }
                    return fixes;
                }
                LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)new PhpChangeParameterTypeQuickFix(project, i, declaredType, inferredType, isOnTheFly));
                if (localQuickFixArray == null) {
                    1.$$$reportNull$$$0(15);
                }
                return localQuickFixArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elementToHighlight";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declaredType";
                        break;
                    }
                    case 4: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inferredType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameterListOwner";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceParameter";
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpStrictTypeCheckingInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpStrictTypeCheckingInspection$1";
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParamFixes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "checkStrictReturnTypeCompatibility";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getReturnTypeFix";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFunctionCall";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "getParamFixes";
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }

            class FunctionParametersHolder {
                private final List<Parameter> myFunctionParameters;
                private final List<PsiElement> myArguments;
                private final Function myFunction;

                FunctionParametersHolder(Function function, List<PsiElement> arguments) {
                    this.myFunctionParameters = Arrays.asList(function.getParameters());
                    this.myArguments = arguments;
                    this.myFunction = function;
                }

                boolean isValid() {
                    return this.myFunctionParameters.size() > 0 && this.myFunctionParameters.size() <= 10;
                }

                private PhpType getDeclaredType(Parameter functionParameter) {
                    return PhpStrictTypeCheckingInspection.getDeclaredType(functionParameter);
                }

                @Nullable
                private Parameter getParameter(int i) {
                    return PhpParamsInspection.getMappedParam(this.myArguments, this.myFunctionParameters, i);
                }

                Function getFunction() {
                    return this.myFunction;
                }
            }
        };
    }

    public static StreamEx<PsiElement> unwrapSpreadOperator(PsiElement[] arguments) {
        return StreamEx.of((Object[])arguments).flatMap(p -> p instanceof ArrayCreationExpression && PhpCodeInsightUtil.isUnpackedArgument(p) ? ArrayCreationExpressionImpl.children((ArrayCreationExpression)p).stream().map(PhpPsiElement::getFirstPsiChild) : Stream.of(p));
    }

    public static PhpType getDeclaredType(Parameter functionParameter) {
        if (functionParameter == null) {
            return PhpType.EMPTY;
        }
        PhpType declaredType = new PhpType().add(functionParameter.getDeclaredType());
        if (PhpType.NULL.equals((Object)((ParameterImpl)functionParameter).getDefaultValueType())) {
            declaredType.add(PhpType.NULL);
        }
        return functionParameter.isVariadic() ? declaredType.unpluralize() : declaredType;
    }

    public static boolean isTypeCompatible(@NotNull PhpType declaredType, @NotNull PhpType argType) {
        if (declaredType == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(2);
        }
        if (argType == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(3);
        }
        return PhpStrictTypeCheckingInspection.canAcceptInner(declaredType, argType) || PhpType.intersects((PhpType)PhpType.NULL, (PhpType)declaredType) && (PhpType.NULL.equals((Object)argType) || declaredType.filterNull().equals((Object)argType));
    }

    private static boolean canAcceptInner(@NotNull PhpType declaredType, @NotNull PhpType inferredType) {
        if (declaredType == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(4);
        }
        if (inferredType == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(5);
        }
        if (PhpStrictTypeCheckingInspection.canAccept(declaredType, inferredType)) {
            return true;
        }
        if (PhpStrictTypeCheckingInspection.allNonScalar(inferredType)) {
            return !PhpStrictTypeCheckingInspection.allScalar(declaredType);
        }
        return !PhpStrictTypeCheckingInspection.allScalar(declaredType) && !PhpStrictTypeCheckingInspection.allScalar(inferredType);
    }

    static boolean canAccept(@NotNull PhpType declaredType, @NotNull PhpType inferredType) {
        if (declaredType == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(6);
        }
        if (inferredType == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(7);
        }
        if (inferredType.isAmbiguous()) {
            return true;
        }
        if (PhpType.intersects((PhpType)declaredType, (PhpType)inferredType)) {
            return true;
        }
        if (PhpStrictTypeCheckingInspection.hasBoolean(declaredType) && PhpStrictTypeCheckingInspection.hasBoolean(inferredType)) {
            return true;
        }
        return PhpType.intersects((PhpType)declaredType, (PhpType)PhpType.FLOAT) && PhpType.intersects((PhpType)inferredType, (PhpType)PhpType.FLOAT_INT);
    }

    static boolean allScalar(@NotNull PhpType type) {
        if (type == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(8);
        }
        if (type.isEmpty()) {
            return false;
        }
        if (PhpType.NULL.equals((Object)type)) {
            return true;
        }
        Set scalarTypes = PhpType.SCALAR.getTypes();
        return type.filterNull().getTypes().stream().allMatch(t -> scalarTypes.contains(t) || "\\false".equals(t) || "\\true".equals(t));
    }

    static boolean allNonScalar(@NotNull PhpType type) {
        if (type == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(9);
        }
        Set scalarTypes = PhpType.SCALAR.getTypes();
        return type.getTypes().stream().noneMatch(t -> scalarTypes.contains(t) || "\\null".equals(t) || "\\true".equals(t) || "\\false".equals(t));
    }

    private static boolean hasBoolean(@NotNull PhpType type) {
        if (type == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(10);
        }
        return type.getTypes().stream().anyMatch(t -> "\\false".equals(t) || "\\true".equals(t) || "\\bool".equals(t));
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpStrictTypeCheckingInspection";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argType";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpStrictTypeCheckingInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTypeCompatible";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canAcceptInner";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canAccept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "allScalar";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "allNonScalar";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasBoolean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myEnableWithoutDeclareStrictDirective;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myEnableWithoutDeclareStrictDirective.setSelected(PhpStrictTypeCheckingInspection.this.ENABLE_WITHOUT_DECLARE_STRICT_DIRECTIVE);
            this.myEnableWithoutDeclareStrictDirective.getModel().addChangeListener(event -> {
                PhpStrictTypeCheckingInspection.this.ENABLE_WITHOUT_DECLARE_STRICT_DIRECTIVE = this.myEnableWithoutDeclareStrictDirective.isSelected();
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBCheckBox jBCheckBox = new JBCheckBox();
            this.myEnableWithoutDeclareStrictDirective = jBCheckBox;
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.strict.type.checking.option"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

