/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRedundantTypeInUnionTypeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantTypeInUnionTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpTypeDeclaration(PhpTypeDeclaration typeDeclaration) {
                Project project = typeDeclaration.getProject();
                PhpType declaredType = typeDeclaration.getGlobalType();
                LinkedHashMap<PhpType, Set<PhpType>> equivalenceClasses = new LinkedHashMap<PhpType, Set<PhpType>>();
                for (String type : declaredType.getTypesSorted()) {
                    PhpType typePart = new PhpType().add(type);
                    PhpType original2 = PhpHierarchyChecksInspection.unwrapAlias(typePart, project);
                    equivalenceClasses.computeIfAbsent(original2, t -> new LinkedHashSet()).add(typePart);
                }
                if (equivalenceClasses.size() != declaredType.size()) {
                    PhpType reducedType = PhpRedundantTypeInUnionTypeInspection.composeReducedType(equivalenceClasses);
                    String reducedTypeString = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, reducedType, (PsiElement)typeDeclaration);
                    assert (reducedTypeString != null);
                    holder.registerProblem((PsiElement)typeDeclaration, PhpBundle.message("inspection.php.redundant.type.in.union.type.template", reducedTypeString), new LocalQuickFix[]{new PhpSimplifyRedundantTypeFix(reducedType)});
                }
            }
        };
    }

    @NotNull
    private static PhpType composeReducedType(@NotNull Map<PhpType, Set<PhpType>> equivalenceClasses) {
        if (equivalenceClasses == null) {
            PhpRedundantTypeInUnionTypeInspection.$$$reportNull$$$0(1);
        }
        PhpType reducedType = new PhpType();
        for (Map.Entry<PhpType, Set<PhpType>> entry : equivalenceClasses.entrySet()) {
            PhpType original2 = entry.getKey();
            Set<PhpType> equivalentTypes = entry.getValue();
            reducedType.add(equivalentTypes.contains(original2) ? original2 : (PhpType)ContainerUtil.getFirstItem(equivalentTypes));
        }
        PhpType phpType = reducedType;
        if (phpType == null) {
            PhpRedundantTypeInUnionTypeInspection.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equivalenceClasses";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpRedundantTypeInUnionTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpRedundantTypeInUnionTypeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "composeReducedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "composeReducedType";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpSimplifyRedundantTypeFix
    implements LocalQuickFix {
        private final PhpType myNewType;

        private PhpSimplifyRedundantTypeFix(PhpType newType) {
            this.myNewType = newType;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.php.redundant.type.in.union.type.fix.name", new Object[0]);
            if (string == null) {
                PhpSimplifyRedundantTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpTypeDeclarationImpl typeDeclaration;
            if (project == null) {
                PhpSimplifyRedundantTypeFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpSimplifyRedundantTypeFix.$$$reportNull$$$0(2);
            }
            if ((typeDeclaration = (PhpTypeDeclarationImpl)((Object)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PhpTypeDeclarationImpl.class))) == null) {
                return;
            }
            typeDeclaration.update(this.myNewType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpRedundantTypeInUnionTypeInspection$PhpSimplifyRedundantTypeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpRedundantTypeInUnionTypeInspection$PhpSimplifyRedundantTypeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

