/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpChangeFunctionSignatureFromUsageQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpSetInheritanceBetweenClassesQuickFixBase;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParamsInspection
extends PhpInspection {
    private static final Comparator<Pair<List<Parameter>, Map<PsiElement, ProblemDescriptor>>> COMPARATOR = (o1, o2) -> {
        int i = ((List)o1.getFirst()).size() - ((List)o2.getFirst()).size();
        return i != 0 ? i : ((Map)o1.second).size() - ((Map)o2.second).size();
    };
    private static final Collection<PhpType> TYPES_ALLOWED_FOR_CAST = ContainerUtil.immutableSet((Object[])new PhpType[]{PhpType.INT, PhpType.STRING, PhpType.BOOLEAN, PhpType.FLOAT, PhpType.ARRAY, PhpType.OBJECT});
    private static final int PARAMETER_LIMIT = 50;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpParamsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){
            final Set<VirtualFile> extensionRoots;
            {
                this.extensionRoots = PhpRuntimeLibraryRootsProvider.getLibraryRoots(holder.getProject());
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                if (reference.getParent() instanceof PhpUse) {
                    return;
                }
                ResolveResult[] results = reference.multiResolve(false);
                PhpParamsInspection.checkCall((PhpPsiElement)reference, results, reference.getParameters(), this.extensionRoots, holder);
            }

            public void visitPhpMethodReference(MethodReference call) {
                if (call.getNameNode() != null) {
                    if (call.getParent() instanceof PhpTraitUseRule) {
                        return;
                    }
                    ResolveResult[] results = ((PsiPolyVariantReference)call.getReference()).multiResolve(false);
                    if (results.length > 0 && results[0].getElement() instanceof PhpDocMethod) {
                        results = ((PsiPolyVariantReference)call.getReference()).multiResolve(true);
                    }
                    PhpParamsInspection.checkCall((PhpPsiElement)call, results, call.getParameters(), this.extensionRoots, holder);
                }
            }

            public void visitPhpNewExpression(NewExpression expression) {
                ClassReference classReference = expression.getClassReference();
                PsiElement[] parameters = expression.getParameters();
                this.checkConstructorCall((PhpPsiElement)expression, classReference, parameters);
            }

            public void visitPhpAttribute(PhpAttribute attribute) {
                this.checkConstructorCall((PhpPsiElement)attribute, attribute.getClassReference(), attribute.getParameters());
            }

            private void checkConstructorCall(PhpPsiElement expression, ClassReference classReference, PsiElement[] parameters) {
                if (classReference != null) {
                    Method constructor;
                    ResolveResult[] results = classReference.multiResolve(false);
                    if (results.length == 1 && results[0].getElement() instanceof Method) {
                        PhpParamsInspection.checkCall(expression, results, parameters, this.extensionRoots, holder);
                    } else if (results.length == 1 && results[0].getElement() instanceof PhpClass && (constructor = ((PhpClass)results[0].getElement()).getConstructor()) != null) {
                        PhpParamsInspection.checkCall(expression, PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{constructor}), parameters, this.extensionRoots, holder);
                    }
                }
            }
        };
    }

    private static void checkCall(PhpPsiElement call, ResolveResult[] results, PsiElement[] callParams, Set<VirtualFile> extensionRoots, ProblemsHolder holder) {
        if (results.length > 0) {
            callParams = (PsiElement[])PhpStrictTypeCheckingInspection.unwrapSpreadOperator(callParams).toArray((Object[])PsiElement.EMPTY_ARRAY);
            ArrayList<Pair<List<Parameter>, Map<PsiElement, ProblemDescriptor>>> warnings = new ArrayList<Pair<List<Parameter>, Map<PsiElement, ProblemDescriptor>>>();
            boolean onTheFly = holder.isOnTheFly();
            boolean unpackedArgument = callParams.length > 0 && PhpCodeInsightUtil.isUnpackedArgument(callParams[callParams.length - 1]);
            IntFunction<PhpType> typeFunc = PhpParamsInspection.createCachedTypeFunc(callParams);
            List<PsiElement> arguments = Arrays.asList(callParams);
            if (PhpParamsInspection.processSignatures(results, extensionRoots, (Processor<List<Parameter>>)((Processor)declParams -> {
                HashMap<PsiElement, ProblemDescriptor> problems = new HashMap<PsiElement, ProblemDescriptor>();
                warnings.add(new Pair(declParams, problems));
                return !PhpParamsInspection.checkMissingParameter(call, arguments, declParams, problems, onTheFly, unpackedArgument) && PhpParamsInspection.checkParametersTypes(typeFunc, call, arguments, declParams, problems, onTheFly);
            }))) {
                return;
            }
            PhpParamsInspection.registerProblems(holder, warnings);
        }
    }

    private static void registerProblems(ProblemsHolder holder, List<Pair<List<Parameter>, Map<PsiElement, ProblemDescriptor>>> warnings) {
        warnings.sort(COMPARATOR);
        Pair item = (Pair)ContainerUtil.getFirstItem(warnings);
        if (item != null) {
            ((Map)item.getSecond()).forEach((key, value) -> holder.registerProblem(value));
        }
    }

    public static boolean checkParametersTypes(IntFunction<? extends PhpType> typeFunc, PhpPsiElement call, List<PsiElement> callParams, List<Parameter> declParams, HashMap<PsiElement, ProblemDescriptor> problems, boolean isOnTheFly) {
        Parameter declParameter;
        boolean result = true;
        PhpNamedElement pos = (PhpNamedElement)PsiTreeUtil.getParentOfType((PsiElement)call, PhpNamedElement.class);
        String ns = pos != null ? pos.getNamespaceName() : "\\";
        PhpIndex phpIndex = PhpIndex.getInstance((Project)call.getProject());
        for (int i = 0; i < callParams.size() && (declParameter = PhpParamsInspection.getMappedParam(callParams, declParams, i)) != null; ++i) {
            PhpType callType;
            PhpType declType;
            if (declParameter.isOptional() && declParameter.getDeclaredType().isEmpty() || (declType = PhpParamsInspection.getParameterType(declParameter)).isEmpty()) continue;
            PhpType localType = PhpParamsInspection.unpluraliseSpreadArguments(new PhpType().add(callParams.get(i)), callParams.get(i));
            if (declType.isConvertibleLocal(call.getProject(), localType) || PhpParamsInspection.isCallTypeConvertibleFromDeclaredType(callType = PhpParamsInspection.unpluraliseSpreadArguments(typeFunc.apply(i), callParams.get(i)), declType, phpIndex)) continue;
            String description = isOnTheFly ? PhpBundle.message("inspection.wrong_param_type", callType.toStringRelativized(ns), declType.toStringRelativized(ns)) : PhpBundle.message("parameter.ref.type.is.not.compatible.with.declaration", new Object[0]);
            problems.put(callParams.get(i), PhpParamsInspection.createSimpleDescriptor(callParams.get(i), isOnTheFly, description, PhpParamsInspection.getFixes(callParams.get(i), callType, declType)));
            result = false;
        }
        return result;
    }

    public static PhpType unpluraliseSpreadArguments(PhpType type, PsiElement argument) {
        return PhpCodeInsightUtil.isUnpackedArgument(argument) ? type.unpluralize() : type;
    }

    @Nullable
    public static Parameter getMappedParam(List<PsiElement> arguments, @NotNull List<Parameter> params, int i) {
        String name;
        Parameter mappedParam;
        if (params == null) {
            PhpParamsInspection.$$$reportNull$$$0(1);
        }
        Parameter parameter = mappedParam = (name = PhpAnnotatorVisitor.getNameOfMappedParam(arguments, params, i)) != null ? (Parameter)ContainerUtil.find(params, p -> PhpLangUtil.equalsParameterNames(p.getName(), name)) : null;
        if (mappedParam != null) {
            return mappedParam;
        }
        Parameter lastItem = (Parameter)ContainerUtil.getLastItem(params);
        return lastItem != null && lastItem.isVariadic() ? lastItem : null;
    }

    @Contract(pure=true)
    @NotNull
    public static @NotNull IntFunction<@NotNull PhpType> createCachedTypeFunc(PsiElement @NotNull [] callParams) {
        if (callParams == null) {
            PhpParamsInspection.$$$reportNull$$$0(2);
        }
        PhpType[] types = new PhpType[callParams.length];
        IntFunction<PhpType> intFunction = i -> {
            if (i >= types.length) {
                return PhpType.EMPTY;
            }
            if (types[i] == null) {
                types[i] = new PhpType().add(callParams[i]).global(callParams[i].getProject()).filterNull();
            }
            return types[i];
        };
        if (intFunction == null) {
            PhpParamsInspection.$$$reportNull$$$0(3);
        }
        return intFunction;
    }

    @NotNull
    public static PhpType getParameterType(Parameter declParameter) {
        PhpType declType = new PhpType().add(declParameter.getGlobalType().filterNull());
        if (declParameter.isOptional() && !declType.isEmpty()) {
            PhpType phpType = declType.add(PhpType.VOID);
            if (phpType == null) {
                PhpParamsInspection.$$$reportNull$$$0(4);
            }
            return phpType;
        }
        PhpType phpType = declType;
        if (phpType == null) {
            PhpParamsInspection.$$$reportNull$$$0(5);
        }
        return phpType;
    }

    public static boolean checkMissingParameter(PhpPsiElement call, List<PsiElement> callParams, List<Parameter> declParams, HashMap<PsiElement, ProblemDescriptor> problems, boolean isOnTheFly, boolean unpackedArgument) {
        if (unpackedArgument) {
            return false;
        }
        Collection<@NlsSafe String> missingRequiredParameterNames = PhpParamsInspection.getMissingRequiredParametersNames(callParams, declParams);
        if (!missingRequiredParameterNames.isEmpty()) {
            PsiElement anchorToHighlight = (PsiElement)ObjectUtils.notNull((Object)((PhpPsiElement)PhpPsiUtil.getChildByCondition((PsiElement)call, (Condition<? super PsiElement>)ParameterList.INSTANCEOF)), (Object)call);
            String description = missingRequiredParameterNames.size() == 1 ? PhpBundle.message("inspection.missing_param", ContainerUtil.getFirstItem(missingRequiredParameterNames)) : PhpBundle.message("required.parameters.missing", StringUtil.join(missingRequiredParameterNames, (String)", "));
            problems.put((PsiElement)call, PhpChangeFunctionSignatureFromUsageQuickFix.getDescriptor(anchorToHighlight, description, isOnTheFly));
            return true;
        }
        return false;
    }

    private static @NotNull Collection<@NlsSafe String> getMissingRequiredParametersNames(List<PsiElement> callParams, List<Parameter> declParams) {
        Collection argumentMappedParamsNames = (Collection)IntStream.range(0, callParams.size()).mapToObj(i -> PhpAnnotatorVisitor.getNameOfMappedParam(callParams, declParams, i)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE)));
        Collection collection = declParams.stream().filter(PhpParamsInspection::required).map(Parameter::getName).filter(name -> !argumentMappedParamsNames.contains(name)).map(name -> "$" + name).collect(Collectors.toList());
        if (collection == null) {
            PhpParamsInspection.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    private static ProblemDescriptor createSimpleDescriptor(PsiElement call, boolean isOnTheFly, @InspectionMessage String description, LocalQuickFix ... fixes) {
        ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)call.getProject()).createProblemDescriptor(call, description, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        if (problemDescriptor == null) {
            PhpParamsInspection.$$$reportNull$$$0(7);
        }
        return problemDescriptor;
    }

    public static LocalQuickFix @NotNull [] getFixes(@NotNull PsiElement argument, PhpType argumentType, PhpType declType) {
        if (argument == null) {
            PhpParamsInspection.$$$reportNull$$$0(8);
        }
        if (TYPES_ALLOWED_FOR_CAST.contains(declType)) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
            LocalQuickFixOnPsiElement localQuickFixOnPsiElement = localQuickFixArray[0] = PhpPsiUtil.isOfType(argument, PhpElementTypes.CAST_EXPRESSION) ? new PhpChangeCastOperationQuickFix((UnaryExpression)argument, declType) : new PhpReplaceArgumentWithCastQuickFix(argument, declType);
            if (localQuickFixArray == null) {
                PhpParamsInspection.$$$reportNull$$$0(9);
            }
            return localQuickFixArray;
        }
        LocalQuickFix[] localQuickFixArray = PhpParamsInspection.getInheritanceChangeQuickFixes(argument, argumentType, declType);
        if (localQuickFixArray == null) {
            PhpParamsInspection.$$$reportNull$$$0(10);
        }
        return localQuickFixArray;
    }

    private static LocalQuickFix[] getInheritanceChangeQuickFixes(@NotNull PsiElement argument, @NotNull PhpType argumentType, @NotNull PhpType declType) {
        PhpIndex phpIndex;
        PhpClass onlyArgumentClass;
        if (argument == null) {
            PhpParamsInspection.$$$reportNull$$$0(11);
        }
        if (argumentType == null) {
            PhpParamsInspection.$$$reportNull$$$0(12);
        }
        if (declType == null) {
            PhpParamsInspection.$$$reportNull$$$0(13);
        }
        if ((onlyArgumentClass = PhpParamsInspection.getOnlyArgumentClass(phpIndex = PhpIndex.getInstance((Project)argument.getProject()), argumentType)) == null || onlyArgumentClass.isTrait()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (!onlyArgumentClass.isWritable()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return (LocalQuickFix[])((StreamEx)StreamEx.of((Collection)declType.getTypes()).filter(PhpLangUtil::isFqn)).flatMap(fqn -> phpIndex.getAnyByFQN(fqn).stream()).map(declaredParameterClass -> PhpSetInheritanceBetweenClassesQuickFixBase.getFix(onlyArgumentClass, declaredParameterClass)).nonNull().toArray((Object[])LocalQuickFix.EMPTY_ARRAY);
    }

    @Nullable
    private static PhpClass getOnlyArgumentClass(PhpIndex phpIndex, PhpType argumentType) {
        if (argumentType.size() != 1 || !PhpLangUtil.isFqn(argumentType.toString())) {
            return null;
        }
        return (PhpClass)ContainerUtil.getOnlyItem((Collection)phpIndex.getAnyByFQN(argumentType.toString()));
    }

    public static boolean isCallTypeConvertibleFromDeclaredType(PhpType callType, PhpType declType, PhpIndex index) {
        return declType.isEmpty() || callType.isAmbiguous() || declType.isConvertibleFrom(callType, index);
    }

    private static boolean required(Parameter p) {
        return !p.isOptional() && !p.isVariadic();
    }

    private static boolean processSignatures(ResolveResult[] results, Set<VirtualFile> extensionRoots, Processor<List<Parameter>> processor) {
        for (ResolveResult result : results) {
            Function f;
            Parameter[] declParams;
            PsiElement element = result.getElement();
            if (!(element instanceof Function) || !result.isValidResult() || (declParams = (f = (Function)element).getParameters()).length > 50 || !(PhpParamsInspection.belongToExtensions(element, extensionRoots) ? PhpParamsInspection.collectSignatureVariants(declParams, processor) : processor.process(Arrays.asList(declParams)))) continue;
            return true;
        }
        return false;
    }

    private static boolean belongToExtensions(PsiElement element, @NotNull Set<VirtualFile> extensionRoots) {
        if (extensionRoots == null) {
            PhpParamsInspection.$$$reportNull$$$0(14);
        }
        return VfsUtilCore.isUnder((VirtualFile)element.getContainingFile().getVirtualFile(), extensionRoots);
    }

    private static boolean collectSignatureVariants(Parameter[] declParams, Processor<List<Parameter>> processor) {
        ArrayList sigs = new ArrayList();
        sigs.add(new ArrayList());
        for (Parameter declParam : declParams) {
            int sigsSize = sigs.size();
            for (int i1 = 0; i1 < sigsSize; ++i1) {
                List sig = (List)sigs.get(i1);
                if (!PhpParamsInspection.required(declParam)) {
                    sigs.add(new ArrayList(sig));
                }
                sig.add(declParam);
            }
        }
        return sigs.stream().anyMatch(arg_0 -> processor.process(arg_0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callParams";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedTypeFunc";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingRequiredParametersNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleDescriptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMappedParam";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCachedTypeFunc";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInheritanceChangeQuickFixes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "belongToExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpReplaceArgumentWithCastQuickFix
    extends LocalQuickFixOnPsiElement {
        private final PhpType myParameterType;

        private PhpReplaceArgumentWithCastQuickFix(PsiElement argument, PhpType parameterType) {
            super(argument);
            this.myParameterType = parameterType;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.argument.with.cast.quick.fix.family.name", this.myParameterType.toStringResolved());
            if (string == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            PsiElement element = this.myStartElement.getElement();
            if (element == null) {
                String string = this.getFamilyName();
                if (string == null) {
                    PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = PhpBundle.message("intention.name.cast.to", element.getText(), this.myParameterType.toStringResolved());
            if (string == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(3);
            }
            if (file == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(6);
            }
            startElement.replace((PsiElement)PhpReplaceArgumentWithCastQuickFix.createCastElementToType(project, startElement, this.myParameterType));
        }

        private static PhpPsiElement createCastElementToType(@NotNull Project project, PsiElement element, PhpType type) {
            if (project == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(7);
            }
            String castExpressionText = String.format("(%s)%s", type.toStringRelativized("\\"), element.getText());
            return PhpPsiElementFactory.createPhpPsiFromText(project, PhpElementTypes.CAST_EXPRESSION, castExpressionText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection$PhpReplaceArgumentWithCastQuickFix";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection$PhpReplaceArgumentWithCastQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createCastElementToType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PhpChangeCastOperationQuickFix
    extends LocalQuickFixOnPsiElement {
        private final PhpType myType;

        private PhpChangeCastOperationQuickFix(UnaryExpression argument, PhpType type) {
            super((PsiElement)argument);
            this.myType = type;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.change.cast.operation.quick.fix.family.name", this.myType.toStringResolved());
            if (string == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            PsiElement operation;
            UnaryExpression element = (UnaryExpression)this.myStartElement.getElement();
            if (element != null && (operation = element.getOperation()) != null) {
                String string = PhpBundle.message("intention.name.change.cast.to", operation.getText(), this.myType.toStringResolved());
                if (string == null) {
                    PhpChangeCastOperationQuickFix.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = this.getFamilyName();
            if (string == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            UnaryExpression argument;
            if (project == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(3);
            }
            if (file == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(6);
            }
            if ((argument = (UnaryExpression)ObjectUtils.tryCast((Object)startElement, UnaryExpression.class)) == null) {
                return;
            }
            PhpPsiElement castValue = argument.getValue();
            if (castValue == null) {
                return;
            }
            argument.replace((PsiElement)PhpReplaceArgumentWithCastQuickFix.createCastElementToType(project, (PsiElement)castValue, this.myType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection$PhpChangeCastOperationQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection$PhpChangeCastOperationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

