/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedVariableInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PhpNullIsNotCompatibleWithParameterInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpNullIsNotCompatibleWithParameterInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.doCheck(reference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.doCheck((FunctionReference)reference);
            }

            private void doCheck(FunctionReference reference) {
                List<PsiElement> arguments = Arrays.asList(reference.getParameters());
                for (int i = 0; i < arguments.size(); ++i) {
                    if (!(arguments.get(i) instanceof Variable) || !PhpNullIsNotCompatibleWithParameterInspection.isFirstAccessAtCurrentRead((Variable)arguments.get(i)) || !((Variable)arguments.get(i)).getGlobalType().isEmpty()) continue;
                    this.checkNullTypeParameter(reference, arguments, i);
                }
            }

            private void checkNullTypeParameter(FunctionReference reference, List<PsiElement> arguments, int i) {
                List parameters = Arrays.stream(reference.multiResolve(false)).map(result -> (Function)ObjectUtils.tryCast((Object)result.getElement(), Function.class)).filter(Objects::nonNull).map(f -> PhpNullIsNotCompatibleWithParameterInspection.getMappedParam(arguments, i, f)).collect(Collectors.toList());
                if (!parameters.isEmpty() && ContainerUtil.all(parameters, p -> p != null && p.isPassByRef() && !PhpNullIsNotCompatibleWithParameterInspection.isParamConvertibleFromNull(p))) {
                    String message = parameters.size() == 1 ? PhpBundle.message("inspection.wrong_param_type", "null", ((Parameter)parameters.get(0)).getGlobalType().toStringResolved()) : PhpBundle.message("parameter.type.is.not.convertible.from.null", new Object[0]);
                    holder.registerProblem(arguments.get(i), message, PhpUndefinedVariableInspection.getUndefinedFixes(arguments.get(i), PhpPsiUtil.getScopeHolder(arguments.get(i)), isOnTheFly));
                }
            }
        };
    }

    private static boolean isParamConvertibleFromNull(Parameter param) {
        PhpType declType = PhpStrictTypeCheckingInspection.getDeclaredType(param).global(param.getProject());
        return declType.isEmpty() || PhpParamsInspection.isCallTypeConvertibleFromDeclaredType(PhpType.NULL, declType, PhpIndex.getInstance((Project)param.getProject()));
    }

    private static Parameter getMappedParam(List<PsiElement> arguments, int argumentIndex, Function f) {
        return PhpParamsInspection.getMappedParam(arguments, Arrays.asList(f.getParameters()), argumentIndex);
    }

    private static boolean isFirstAccessAtCurrentRead(Variable argument) {
        if (ContainerUtil.exists((Iterable)argument.resolveLocal(), Parameter.class::isInstance)) {
            return false;
        }
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)argument, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            return false;
        }
        final Ref res = new Ref((Object)true);
        PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                res.set((Object)false);
                return false;
            }
        });
        return (Boolean)res.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/type/PhpNullIsNotCompatibleWithParameterInspection", "buildVisitor"));
    }
}

