/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeReturnTypeQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpMissingReturnTypeInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMixedReturnTypeCanBeReducedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMixedReturnTypeCanBeReducedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                String hint = PhpMixedReturnTypeCanBeReducedInspection.getReducedMixedTypeHint(function);
                if (StringUtil.isNotEmpty((String)hint)) {
                    PhpReturnType declaration = (PhpReturnType)function.getTypeDeclaration();
                    assert (declaration != null);
                    holder.registerProblem((PsiElement)declaration, PhpBundle.message("inspection.message.type.can.be.reduced.to", hint), new LocalQuickFix[]{new PhpChangeReturnTypeQuickFix(holder.getProject(), PhpType.MIXED, PhpMixedReturnTypeCanBeReducedInspection.createTypeFromHint(hint))});
                }
            }

            public void visitPhpMethod(Method method) {
                if (!(method instanceof PhpDocMethod)) {
                    this.visitPhpFunction((Function)method);
                }
            }
        };
    }

    @NlsSafe
    private static String getReducedMixedTypeHint(Function function) {
        String hint;
        PhpType inferredType = function.getInferredType().global(function.getProject());
        if (function.getDeclaredType().equals((Object)PhpType.MIXED) && !inferredType.hasUnknown() && StringUtil.isNotEmpty((String)(hint = PhpMissingReturnTypeInspection.createTypeHint((PhpScopeHolder)function, function.getInferredType()))) && !hint.equals("mixed")) {
            PhpType type;
            if (function instanceof Method && !PhpMixedReturnTypeCanBeReducedInspection.typeIsCompatibleWithChildrenReturnType(type = PhpMixedReturnTypeCanBeReducedInspection.createTypeFromHint(hint), (Method)function)) {
                return null;
            }
            return hint;
        }
        return null;
    }

    @NotNull
    private static PhpType createTypeFromHint(String hint) {
        PhpType phpType = PhpChangeSignatureDialog.getTypeFromPresentation(hint, null);
        if (phpType == null) {
            PhpMixedReturnTypeCanBeReducedInspection.$$$reportNull$$$0(1);
        }
        return phpType;
    }

    private static boolean typeIsCompatibleWithChildrenReturnType(PhpType superMethodNewReturnType, Method superMethod) {
        Ref res = new Ref((Object)true);
        Project project = superMethod.getProject();
        PhpClassHierarchyUtils.processOverridingMethods((Method)superMethod, (childMethod, subClass, baseClass) -> {
            PhpReturnType declaration = (PhpReturnType)childMethod.getTypeDeclaration();
            res.set((Object)(declaration == null || PhpHierarchyChecksInspection.getCompatibility(project, superMethodNewReturnType, childMethod.getDeclaredType(), declaration).isCompatible() ? 1 : 0));
            return (Boolean)res.get();
        });
        return (Boolean)res.get();
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpMixedReturnTypeCanBeReducedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMixedReturnTypeCanBeReducedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeFromHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

