/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.DeclareImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpMissingStrictTypesDeclarationInspection
extends PhpInspection {
    private static final PhpAddStrictTypesDeclarationQuickFix QUICK_FIX = new PhpAddStrictTypesDeclarationQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingStrictTypesDeclarationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFile(PhpFile file) {
                List declares;
                PsiElement prevSibling;
                PsiElement groupStatement;
                PsiElement phpOpeningTag;
                if (PhpLanguageFeature.SCALAR_TYPE_HINTS.isSupported(holder.getProject()) && (phpOpeningTag = PhpPsiUtil.getChildOfType(groupStatement = file.getFirstChild(), PhpTokenTypes.PHP_OPENING_TAG)) != null && ((prevSibling = phpOpeningTag.getPrevSibling()) == null || PhpAnnotatorVisitor.isShebang(prevSibling)) && (declares = PhpPsiUtil.getChildren(groupStatement, (Condition<? super PsiElement>)Declare.INSTANCEOF)).stream().map(DeclareImpl::getStrictTypesDirective).noneMatch(Objects::nonNull)) {
                    holder.registerProblem(phpOpeningTag, PhpBundle.message("inspection.missing.strict.types.declaration", new Object[0]), new LocalQuickFix[]{QUICK_FIX});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/type/PhpMissingStrictTypesDeclarationInspection", "buildVisitor"));
    }

    private static final class PhpAddStrictTypesDeclarationQuickFix
    extends PhpQuickFixBase {
        private PhpAddStrictTypesDeclarationQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.missing.strict.types.declaration.add.declaration", new Object[0]);
            if (string == null) {
                PhpAddStrictTypesDeclarationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpAddStrictTypesDeclarationQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddStrictTypesDeclarationQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement phpOpeningTag = descriptor.getPsiElement();
            Statement declare = PhpPsiElementFactory.createStatement(project, "declare(strict_types=1);");
            phpOpeningTag.getParent().addRangeAfter(declare.getPrevSibling(), (PsiElement)declare, phpOpeningTag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpMissingStrictTypesDeclarationInspection$PhpAddStrictTypesDeclarationQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMissingStrictTypesDeclarationInspection$PhpAddStrictTypesDeclarationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

