/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpIncorrectMagicMethodSignatureInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMissingReturnTypeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpMissingReturnTypeInspection.this.doCheck(function, holder, isOnTheFly);
            }

            public void visitPhpMethod(Method method) {
                if (method instanceof PhpDocMethod) {
                    return;
                }
                if (PhpIncorrectMagicMethodSignatureInspection.isCheckedMagicMethod(method)) {
                    return;
                }
                if (method.getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
                    return;
                }
                PhpMissingReturnTypeInspection.this.doCheck((Function)method, holder, isOnTheFly);
            }
        };
    }

    public void doCheck(Function function, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PhpReturnType declarationType;
        if (holder == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(1);
        }
        if ((declarationType = (PhpReturnType)function.getTypeDeclaration()) != null) {
            return;
        }
        PhpType inferredType = function.getType().global(function.getProject());
        if (PhpType.intersects((PhpType)PhpType.VOID, (PhpType)inferredType)) {
            return;
        }
        if (!PhpDocSignatureInspection.isReturnTypeSupported(inferredType, function.getProject())) {
            return;
        }
        String hint = PhpMissingReturnTypeInspection.createTypeHint(function);
        if (hint.isEmpty()) {
            return;
        }
        PsiElement fnToken = PhpPsiUtil.getChildOfType((PsiElement)function, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwFUNCTION, PhpTokenTypes.kwFN}));
        if (fnToken == null) {
            return;
        }
        PsiElement identifier = (PsiElement)ObjectUtils.notNull((Object)function.getNameIdentifier(), (Object)fnToken);
        if (!identifier.getTextRange().isEmpty()) {
            if (function.isClosure() || PhpMissingReturnTypeInspection.hasMixedTypeNotFromPhpDoc(function)) {
                if (!isOnTheFly) {
                    return;
                }
                holder.registerProblem(identifier, PhpBundle.message("inspection.php.missing.return.type.description", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new PhpAddReturnTypeQuickFix(hint)});
            } else {
                holder.registerProblem(identifier, PhpBundle.message("inspection.php.missing.return.type.description", new Object[0]), new LocalQuickFix[]{new PhpAddReturnTypeQuickFix(hint)});
            }
        }
    }

    private static boolean hasMixedTypeNotFromPhpDoc(@NotNull Function function) {
        if (function == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(2);
        }
        if (PhpType.intersects((PhpType)PhpType.MIXED, (PhpType)function.getDocType())) {
            return false;
        }
        return PhpType.intersects((PhpType)PhpType.MIXED, (PhpType)function.getGlobalType());
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP700;
    }

    @NotNull
    public static String createTypeHint(@NotNull Function function) {
        if (function == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(3);
        }
        return PhpMissingReturnTypeInspection.createTypeHint((PhpScopeHolder)function, function.getType());
    }

    @NotNull
    public static String createTypeHint(@NotNull PhpScopeHolder scopeHolder, @NotNull PhpType functionType) {
        if (scopeHolder == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(4);
        }
        if (functionType == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(5);
        }
        Project project = scopeHolder.getProject();
        int size = functionType.size();
        if (PhpLanguageFeature.STATIC_RETURN_TYPE_HINT.isSupported(project)) {
            functionType = functionType.filterOut(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0));
        }
        boolean addStatic = size != functionType.size();
        PhpType type = functionType.global(project);
        boolean allowMultipleTypes = PhpLanguageFeature.UNION_TYPES.isSupported(project);
        String typeHint = PhpAddMethodDeclarationQuickFix.createTypeHint(project, type, (PsiElement)scopeHolder, false, allowMultipleTypes);
        List typeHints = StringUtil.split((String)typeHint, (String)"|");
        String string = addStatic ? StringUtil.notNullize((String)PhpCodeUtil.getTypeHintString(project, allowMultipleTypes, ContainerUtil.append((List)typeHints, (Object[])new String[]{"static"}))) : typeHint;
        if (string == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpMissingReturnTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMissingReturnTypeInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doCheck";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasMixedTypeNotFromPhpDoc";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTypeHint";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpAddReturnTypeQuickFix
    implements LocalQuickFix {
        private final String myTypeHint;

        private PhpAddReturnTypeQuickFix(String typeHint) {
            this.myTypeHint = typeHint;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("add.return.type", new Object[0]);
            if (string == null) {
                PhpAddReturnTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = PhpBundle.message("intention.name.add.as.function.s.return.type", this.myTypeHint);
            if (string == null) {
                PhpAddReturnTypeQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Function function;
            if (project == null) {
                PhpAddReturnTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpAddReturnTypeQuickFix.$$$reportNull$$$0(3);
            }
            if ((function = (Function)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), (Condition<? super PsiElement>)Function.INSTANCEOF)) == null || function.getTypeDeclaration() != null) {
                return;
            }
            function.updateType(function.getType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpMissingReturnTypeInspection$PhpAddReturnTypeQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMissingReturnTypeInspection$PhpAddReturnTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

