/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpUpdateSignatureFromPhpDocQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.List;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMissingParamTypeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingParamTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpParameter(Parameter parameter) {
                PhpMissingParamTypeInspection.this.doCheck(parameter, holder);
            }
        };
    }

    public void doCheck(Parameter parameter, @NotNull ProblemsHolder holder) {
        PhpType type;
        if (holder == null) {
            PhpMissingParamTypeInspection.$$$reportNull$$$0(1);
        }
        if (!(type = parameter.getDeclaredType()).isEmpty() || parameter.getDefaultValue() != null) {
            return;
        }
        Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)parameter, (Condition<? super PsiElement>)((Condition)Function.class::isInstance));
        if (function == null) {
            return;
        }
        if (PhpMissingParamTypeInspection.isSuperMethodParameterTypeIncompatible(function, parameter)) {
            return;
        }
        PhpDocParamTag docTag = parameter.getDocTag();
        if (docTag == null) {
            return;
        }
        String hint = PhpUpdateSignatureFromPhpDocQuickFix.getParameterTypeString(function, (PhpDocTag)docTag);
        if (StringUtil.isEmpty((String)hint)) {
            return;
        }
        holder.registerProblem((PsiElement)parameter, PhpBundle.message("inspection.php.missing.param.type.description", new Object[0]), new LocalQuickFix[]{new PhpAddParamTypeQuickFix(hint, holder.isOnTheFly())});
    }

    private static boolean isSuperMethodParameterTypeIncompatible(@NotNull Function function, @NotNull Parameter parameter) {
        Method method;
        if (function == null) {
            PhpMissingParamTypeInspection.$$$reportNull$$$0(2);
        }
        if (parameter == null) {
            PhpMissingParamTypeInspection.$$$reportNull$$$0(3);
        }
        if ((method = (Method)ObjectUtils.tryCast((Object)function, Method.class)) == null) {
            return false;
        }
        PhpType newType = parameter.getDocType();
        int index = ArrayUtil.indexOf((Object[])function.getParameters(), (Object)parameter);
        if (index < 0) {
            return false;
        }
        Ref result = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperMethods((Method)method, (superMethod, subClass, baseClass) -> {
            Parameter param = superMethod.getParameter(index);
            if (param != null && !param.getDeclaredType().equals((Object)newType)) {
                result.set((Object)true);
            }
            return (Boolean)result.get() == false;
        });
        return (Boolean)result.get();
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP700;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMissingParamTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheck";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuperMethodParameterTypeIncompatible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpAddParamTypeQuickFix
    implements LocalQuickFix {
        @NotNull
        private final String myTypeHint;
        private final boolean myIsOnTheFly;
        private static final PhpParameterInfo[] EMPTY_ARRAY = new PhpParameterInfo[0];

        private PhpAddParamTypeQuickFix(@NotNull String typeHint, boolean isOnTheFly) {
            if (typeHint == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(0);
            }
            this.myTypeHint = typeHint;
            this.myIsOnTheFly = isOnTheFly;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = PhpBundle.message("quickfix.php.missing.param.type.description", this.myTypeHint);
            if (string == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.php.missing.param.type.batch.description", new Object[0]);
            if (string == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Parameter updatingParameter;
            if (project == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(4);
            }
            if ((updatingParameter = (Parameter)ObjectUtils.tryCast((Object)descriptor.getStartElement(), Parameter.class)) == null) {
                return;
            }
            Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)updatingParameter, (Condition<? super PsiElement>)((Condition)Function.class::isInstance));
            if (function == null) {
                return;
            }
            List parametersInfo = EntryStream.of((Object[])function.getParameters()).mapKeyValue((index, parameter) -> PhpAddParamTypeQuickFix.createNewInfoOnlyForUpdatedParameter(updatingParameter, function, index, parameter)).toList();
            PhpMethodDescriptor methodDescriptor = new PhpMethodDescriptor(function);
            PhpReturnType returnType = function.getReturnType();
            PhpChangeInfo changeInfo = new PhpChangeInfo(methodDescriptor, parametersInfo.toArray(EMPTY_ARRAY), methodDescriptor.getVisibility(), methodDescriptor.getName(), returnType != null ? returnType.getText() : null, null, false, true);
            PhpUpdateSignatureFromPhpDocQuickFix.changeFunctionSignature(function, changeInfo, this.myIsOnTheFly);
        }

        @NotNull
        private static PhpParameterInfo createNewInfoOnlyForUpdatedParameter(Parameter updatedParameter, Function function, Integer index, Parameter parameter) {
            if (parameter != updatedParameter) {
                return new PhpParameterInfo((int)index, parameter);
            }
            PhpParameterInfo phpParameterInfo = PhpUpdateSignatureFromPhpDocQuickFix.createParameterInfo(function, function.getParameters(), updatedParameter.getDocTag());
            if (phpParameterInfo == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(5);
            }
            return phpParameterInfo;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeHint";
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpMissingParamTypeInspection$PhpAddParamTypeQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMissingParamTypeInspection$PhpAddParamTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewInfoOnlyForUpdatedParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

