/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.google.common.base.Predicates;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpAddInferredTypeAsPropertyTypeQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMissingFieldTypeInspection
extends PhpInspection {
    private static final Predicate<String> NOT_APPLICABLE_TYPE_IN_FIELD_DECLARATION = Predicates.or((com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{PhpType::isAnonymousClass, PhpLangUtil::isClassNameSpecial, PhpType::isCallableType, "\\resource"::equalsIgnoreCase, "\\void"::equalsIgnoreCase});

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpField(Field field) {
                PhpType inferredType;
                if (field.isConstant() || field instanceof PhpDocProperty || field.getTypeDeclaration() != null) {
                    return;
                }
                PsiElement nameIdentifier = field.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                Project project = field.getProject();
                PhpType fieldType = field.getGlobalType();
                if (fieldType.filterNull().isEmpty()) {
                    PhpType typeFromGetter = PhpMissingFieldTypeInspection.getTypeFromGetter(project, field);
                    if (typeFromGetter.isEmpty() || typeFromGetter.equals((Object)PhpType.VOID)) {
                        holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.missing.field.type", new Object[0]), new LocalQuickFix[0]);
                        return;
                    }
                    fieldType = typeFromGetter;
                }
                if (!(inferredType = PhpMissingFieldTypeInspection.getSuitableTypeForFieldTypeDeclaration(project, field, fieldType)).isEmpty()) {
                    String typeStr = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, inferredType, (PsiElement)field);
                    if (typeStr == null) {
                        return;
                    }
                    if (PhpAddInferredTypeAsPropertyTypeQuickFix.canApplyFix(field)) {
                        holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.missing.field.type", new Object[0]), new LocalQuickFix[]{new PhpAddInferredTypeAsPropertyTypeQuickFix(inferredType, typeStr, isOnTheFly)});
                    }
                }
            }
        };
    }

    @NotNull
    private static PhpType getTypeFromGetter(@NotNull Project project, @NotNull Field field) {
        PhpClass clazz;
        if (project == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(1);
        }
        if (field == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(2);
        }
        if ((clazz = field.getContainingClass()) == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(3);
            }
            return phpType;
        }
        Method[] getters = new PhpAccessorsGenerator(clazz, field).findGetters();
        if (getters.length != 1) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(4);
            }
            return phpType;
        }
        PhpType phpType = getters[0].getGlobalType();
        if (phpType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(5);
        }
        return phpType;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    @NotNull
    private static PhpType getSuitableTypeForFieldTypeDeclaration(@NotNull Project project, @NotNull Field field, @NotNull PhpType fieldType) {
        PhpTypedElement defaultValue;
        PhpType defaultValueType;
        PhpType composedType;
        if (project == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(6);
        }
        if (field == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(7);
        }
        if (fieldType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(8);
        }
        if ((composedType = PhpMissingFieldTypeInspection.composeFieldType(project, fieldType, defaultValueType = (defaultValue = (PhpTypedElement)ObjectUtils.tryCast((Object)field.getDefaultValue(), PhpTypedElement.class)) != null ? defaultValue.getGlobalType() : PhpType.EMPTY)).filterNull().size() != 1 && !PhpLanguageFeature.UNION_TYPES.isSupported(project)) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(9);
            }
            return phpType;
        }
        PhpType phpType = PhpAnnotatorVisitor.isPropertyDefaultValueTypeCompatible(composedType, defaultValueType) ? composedType : PhpType.EMPTY;
        if (phpType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @NotNull
    public static PhpType composeFieldType(@NotNull Project project, @NotNull PhpType inferredType, @NotNull PhpType defaultValueType) {
        if (project == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(11);
        }
        if (inferredType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(12);
        }
        if (defaultValueType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(13);
        }
        PhpType result = PhpMissingFieldTypeInspection.composeType(project, inferredType, NOT_APPLICABLE_TYPE_IN_FIELD_DECLARATION);
        if (defaultValueType.isNullable() && !result.isEmpty() && !PhpType.MIXED.equals((Object)result)) {
            result.add(PhpType.NULL);
        }
        PhpType phpType = result;
        if (phpType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    @NotNull
    public static PhpType composeType(@NotNull Project project, @NotNull PhpType inferredType, Predicate<String> notSuitableTypesPredicate) {
        PhpType filteredType;
        if (project == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(15);
        }
        if (inferredType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(16);
        }
        if ((filteredType = inferredType.filterOut(notSuitableTypesPredicate)).size() != inferredType.size()) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(17);
            }
            return phpType;
        }
        if (PhpType.intersects((PhpType)PhpType.MIXED, (PhpType)filteredType)) {
            if (PhpLanguageFeature.MIXED_TYPE_HINT.isSupported(project)) {
                PhpType phpType = PhpType.MIXED;
                if (phpType == null) {
                    PhpMissingFieldTypeInspection.$$$reportNull$$$0(18);
                }
                return phpType;
            }
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(19);
            }
            return phpType;
        }
        PhpType result = new PhpType();
        boolean convertFalseToBool = !PhpLanguageFeature.UNION_TYPES.isSupported(project) || filteredType.filterNull().equals((Object)PhpType.FALSE);
        for (String typeFqn : filteredType.getTypes()) {
            if (typeFqn.equalsIgnoreCase("\\false") && convertFalseToBool || typeFqn.equalsIgnoreCase("\\true")) {
                result.add(PhpType.BOOLEAN);
                continue;
            }
            if (PhpType.isPluralType((String)typeFqn)) {
                result.add(PhpType.ARRAY);
                continue;
            }
            result.add(typeFqn);
        }
        if (PhpType.intersects((PhpType)result, (PhpType)PhpType.ITERABLE) && PhpType.intersects((PhpType)result, (PhpType)PhpType.ARRAY_TRAVERSABLE_TYPE)) {
            PhpType phpType = result.filter(PhpType.ARRAY_TRAVERSABLE_TYPE);
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(20);
            }
            return phpType;
        }
        PhpType phpType = result;
        if (phpType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(21);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpMissingFieldTypeInspection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMissingFieldTypeInspection";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromGetter";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableTypeForFieldTypeDeclaration";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "composeFieldType";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "composeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromGetter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuitableTypeForFieldTypeDeclaration";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "composeFieldType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "composeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

