/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIllegalArrayKeyTypeInspection
extends PhpInspection {
    private static final PhpType PRIMITIVE_TYPE_SET = new PhpType().add(PhpType.STRING).add(PhpType.FLOAT_INT).add(PhpType.MIXED).add(PhpType.NULL).add(PhpType.BOOLEAN).add(PhpType.NUMBER).add(PhpType.TRUE).add(PhpType.FALSE);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIllegalArrayKeyTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpElement(PhpPsiElement element) {
                IElementType elementType = element.getNode().getElementType();
                if (elementType == PhpElementTypes.ARRAY_KEY || elementType == PhpElementTypes.ARRAY_INDEX) {
                    PhpIllegalArrayKeyTypeInspection.analyzeElement(element.getFirstPsiChild(), holder);
                }
            }
        };
    }

    private static void analyzeElement(@Nullable PhpPsiElement firstPsiChild, ProblemsHolder holder) {
        PhpType keyType;
        if (firstPsiChild instanceof PhpTypedElement && !(keyType = ((PhpTypedElement)firstPsiChild).getGlobalType().filterUnknown()).isAmbiguous() && !PhpIllegalArrayKeyTypeInspection.isResolvedSignatureAcceptsKeyType(firstPsiChild.getParent(), keyType)) {
            holder.registerProblem((PsiElement)firstPsiChild, holder.isOnTheFly() ? PhpBundle.message("inspection.php.illegal.array.key.type.description", PhpIllegalArrayKeyTypeInspection.getError(), keyType.toStringRelativized("\\")) : PhpIllegalArrayKeyTypeInspection.getError(), new LocalQuickFix[0]);
        }
    }

    private static boolean isResolvedSignatureAcceptsKeyType(@NotNull PsiElement arrayKey, PhpType keyType) {
        PhpReference arrayReference;
        if (arrayKey == null) {
            PhpIllegalArrayKeyTypeInspection.$$$reportNull$$$0(1);
        }
        if ((arrayReference = (PhpReference)PhpPsiUtil.getChildByCondition(arrayKey.getParent(), (Condition<? super PsiElement>)PhpReference.INSTANCEOF)) != null) {
            Project project = arrayKey.getProject();
            PhpType referenceType = arrayReference.getType();
            if (referenceType.isEmpty() || PhpType.intersectsGlobal((Project)project, (PhpType)PhpType.MIXED, (PhpType)referenceType)) {
                return true;
            }
            if (!PhpType.intersectsGlobal((Project)project, (PhpType)PhpType.ARRAY, (PhpType)referenceType)) {
                Parameter parameter;
                Method arrayOffsetMethod;
                PsiReference ref;
                ArrayAccessExpression arrayAccess = (ArrayAccessExpression)PhpPsiUtil.getParentByCondition(arrayKey, true, (Condition<? super PsiElement>)ArrayAccessExpression.INSTANCEOF);
                PsiReference psiReference = ref = arrayAccess != null ? (PsiReference)ArrayUtil.getFirstElement((Object[])arrayAccess.getReferences()) : null;
                if (ref != null && (arrayOffsetMethod = (Method)ObjectUtils.tryCast((Object)ref.resolve(), Method.class)) != null && (parameter = arrayOffsetMethod.getParameter(0)) != null) {
                    return PhpParamsInspection.getParameterType(parameter).isConvertibleFrom(keyType, PhpIndex.getInstance((Project)project));
                }
            }
        }
        return PhpType.intersects((PhpType)keyType, (PhpType)PRIMITIVE_TYPE_SET);
    }

    @Override
    @Nullable
    protected ProblemHighlightType getPhp8CustomSeverity() {
        return ProblemHighlightType.ERROR;
    }

    @InspectionMessage
    private static String getError() {
        return PhpBundle.message("inspection.illegal.array.key.type.problem", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayKey";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpIllegalArrayKeyTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isResolvedSignatureAcceptsKeyType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

