/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFieldAssignmentTypeMismatchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpFieldAssignmentTypeMismatchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                Field field;
                Project project = assignmentExpression.getProject();
                FieldReference fieldReference = (FieldReference)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), FieldReference.class);
                PhpTypedElement assignedValue = (PhpTypedElement)ObjectUtils.tryCast((Object)assignmentExpression.getValue(), PhpTypedElement.class);
                if (fieldReference != null && assignedValue != null && (field = (Field)ObjectUtils.tryCast((Object)fieldReference.resolve(), Field.class)) != null && !field.isConstant() && !(field instanceof PhpDocProperty)) {
                    PhpType fieldType = field.getDeclaredType().global(project);
                    if (fieldType.isEmpty() || PhpType.MIXED.equals((Object)fieldType)) {
                        return;
                    }
                    PhpType assignedValueType = assignedValue.getGlobalType();
                    if (!fieldType.isNullable() && PhpType.intersectsGlobal((Project)project, (PhpType)assignedValueType, (PhpType)PhpType.NULL) || !fieldType.isConvertibleFromGlobal(project, assignedValueType)) {
                        holder.registerProblem((PsiElement)assignmentExpression, PhpBundle.message("inspection.field.assignment.type.mismatch", fieldType, assignedValueType), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/type/PhpFieldAssignmentTypeMismatchInspection", "buildVisitor"));
    }
}

