/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpExpressionAlwaysNullInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpReplaceWithNullQuickFix.INSTANCE};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpExpressionAlwaysNullInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpReturn(PhpReturn returnStatement) {
                if (PhpExpressionAlwaysNullInspection.insideReturnByReferenceFunction(returnStatement)) {
                    return;
                }
                this.check((PhpTypedElement)ObjectUtils.tryCast((Object)returnStatement.getArgument(), PhpTypedElement.class));
            }

            private void check(PhpTypedElement argument) {
                if (argument == null || argument instanceof FunctionReference || argument instanceof MemberReference || argument instanceof AssignmentExpression || argument instanceof ConstantReference) {
                    return;
                }
                if (PhpExpressionAlwaysNullInspection.alwaysNull(argument) && !PhpExpressionAlwaysNullInspection.isAmbiguousVariable(argument)) {
                    boolean isClassReference;
                    PsiElement parent = argument.getParent();
                    boolean bl = isClassReference = parent instanceof MemberReferenceImpl && ((MemberReferenceImpl)parent).getClassReference() == argument;
                    if (isClassReference && ((MemberReferenceImpl)parent).isNullSafeDereference()) {
                        holder.registerProblem(parent, PhpBundle.message("inspection.php.expression.always.null.description", new Object[0]), new LocalQuickFix[]{PhpReplaceWithNullQuickFix.INSTANCE});
                    } else {
                        holder.registerProblem((PsiElement)argument, PhpBundle.message("inspection.php.expression.always.null.description", new Object[0]), isClassReference ? LocalQuickFix.EMPTY_ARRAY : FIXES);
                    }
                }
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.check((PhpTypedElement)reference.getClassReference());
            }

            public void visitPhpFieldReference(FieldReference fieldReference) {
                this.check((PhpTypedElement)fieldReference.getClassReference());
            }
        };
    }

    private static boolean isAmbiguousVariable(PhpTypedElement argument) {
        return argument instanceof Variable && (PhpExpressionAlwaysNullInspection.isReferenced((Variable)argument) || PhpExpressionAlwaysNullInspection.resolvedToAmbiguousDeclaration((Variable)argument, new HashSet<Variable>()));
    }

    public static boolean insideReturnByReferenceFunction(PhpReturn returnStatement) {
        Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)returnStatement, (Condition<? super PsiElement>)Function.INSTANCEOF);
        return function != null && function.isReturningByReference();
    }

    private static boolean alwaysNull(PhpTypedElement argument) {
        return argument.getGlobalType().equals((Object)PhpType.NULL);
    }

    private static boolean resolvedToAmbiguousDeclaration(@NotNull Variable argument, Collection<Variable> visited) {
        if (argument == null) {
            PhpExpressionAlwaysNullInspection.$$$reportNull$$$0(1);
        }
        if (!visited.add(argument)) {
            return true;
        }
        for (PhpNamedElement namedElement : argument.resolveLocal()) {
            if (namedElement instanceof Variable && namedElement.getParent() instanceof PhpUseList && PhpExpressionAlwaysNullInspection.resolvedToAmbiguousDeclaration((Variable)namedElement, visited)) {
                return true;
            }
            if (namedElement instanceof Parameter && PhpLangUtil.isNull(((Parameter)namedElement).getDefaultValue())) {
                return true;
            }
            AssignmentExpression assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)namedElement, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF);
            if (assignment == null) continue;
            if (PhpPsiUtil.getParentByCondition((PsiElement)assignment, (Condition<? super PsiElement>)((Condition)PhpStaticStatement.class::isInstance)) != null) {
                return true;
            }
            if (!(assignment.getValue() instanceof FieldReference)) continue;
            return true;
        }
        return false;
    }

    private static boolean isReferenced(@NotNull Variable argument) {
        PhpAccessVariableInstruction instruction;
        if (argument == null) {
            PhpExpressionAlwaysNullInspection.$$$reportNull$$$0(2);
        }
        if ((instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)argument, PhpAccessVariableInstruction.class)) == null) {
            return true;
        }
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)argument);
        return scopeHolder == null || PhpControlFlowUtil.isReferenced(scopeHolder, instruction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysNullInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolvedToAmbiguousDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferenced";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpReplaceWithNullQuickFix
    implements LocalQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpReplaceWithNullQuickFix();

        private PhpReplaceWithNullQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with.null.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpReplaceWithNullQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceWithNullQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceWithNullQuickFix.$$$reportNull$$$0(2);
            }
            descriptor.getStartElement().replace((PsiElement)PhpPsiElementFactory.createConstantReference(project, "null"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysNullInspection$PhpReplaceWithNullQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysNullInspection$PhpReplaceWithNullQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

