/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpInstanceofIsAlwaysTrueInspection;
import com.jetbrains.php.lang.inspections.type.PhpBooleanConstantValueDfaAnalyzer;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysNullInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFlatCollectionIndexBase;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionsAlwaysReturningBooleanValuesIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantHandler;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExpressionAlwaysConstantInspection
extends PhpInspection {
    private static boolean resolveToFunctionThatAlwaysReturnBoolean(FunctionReference value) {
        Collection resolvedElements = (Collection)StreamEx.of((Object[])value.multiResolve(false)).map(ResolveResult::getElement).select(Function.class).collect(Collectors.toSet());
        if (resolvedElements.isEmpty()) {
            return false;
        }
        if (ContainerUtil.all((Collection)resolvedElements, f -> PhpLangUtil.isGlobalNamespaceFQN(f.getNamespaceName()) || f.getDeclaredType().isBoolean())) {
            return true;
        }
        HashSet alwaysBooleanFQNs = new HashSet();
        PhpFlatCollectionIndexBase.processValues(PhpFunctionsAlwaysReturningBooleanValuesIndex.KEY, (file, v) -> {
            alwaysBooleanFQNs.addAll(v);
            return true;
        }, GlobalSearchScope.allScope((Project)value.getProject()));
        return ContainerUtil.all((Collection)resolvedElements, function -> alwaysBooleanFQNs.contains(function.getFQN()));
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpExpressionAlwaysConstantInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpVariable(Variable variable) {
                if (PhpExpressionAlwaysConstantInspection.argumentOfReturnInsideFunctionByRef(variable)) {
                    return;
                }
                PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
                if (instruction == null || !instruction.getAccess().isRead() || instruction.getAccess().isReadWrite()) {
                    return;
                }
                if (variable.isWriteAccess(true)) {
                    return;
                }
                ConstantValue constantValue = this.getConstantValue(instruction);
                if (constantValue != ConstantValue.UNKNOWN) {
                    holder.registerProblem((PsiElement)variable, PhpBundle.message("variable.always.have.value.0", constantValue.getPresentableName()), PhpExpressionAlwaysConstantInspection.getFixes(variable, constantValue, isOnTheFly));
                }
            }

            @NotNull
            private ConstantValue getConstantValue(PhpAccessVariableInstruction instruction) {
                final CharSequence variableName = instruction.getVariableName();
                final Ref ambiguousAssignment = new Ref((Object)Boolean.FALSE);
                final ArrayList assignedConstantValues = new ArrayList();
                final TIntHashSet writeVariableInstructions = new TIntHashSet();
                PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        PhpAccessInstruction.Access access = instruction.getAccess();
                        if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName)) return true;
                        if (access.isRead()) return true;
                        if (!(instruction.getAnchor() instanceof Variable)) {
                            return true;
                        }
                        writeVariableInstructions.add(instruction.num());
                        Variable v = (Variable)instruction.getAnchor();
                        AssignmentExpression assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)v, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF);
                        if (assignment != null && assignment.getVariable() == v) {
                            if (PhpPsiUtil.getParentByCondition((PsiElement)assignment, (Condition<? super PsiElement>)((Condition)PhpStaticStatement.class::isInstance)) == null) {
                                ConstantValue value = ConstantValue.fromValue((PsiElement)assignment.getValue(), true);
                                assignedConstantValues.add(value);
                                return false;
                            }
                        }
                        ambiguousAssignment.set((Object)Boolean.TRUE);
                        return false;
                    }

                    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                        CharSequence baseVariableName = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
                        if (PhpLangUtil.equalsVariableNames(baseVariableName, variableName) && instruction.getAccess().isWrite()) {
                            ambiguousAssignment.set((Object)Boolean.TRUE);
                            return false;
                        }
                        return true;
                    }

                    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                        ambiguousAssignment.set((Object)Boolean.TRUE);
                        return true;
                    }
                });
                if (((Boolean)ambiguousAssignment.get()).booleanValue() || assignedConstantValues.isEmpty() || assignedConstantValues.contains((Object)ConstantValue.UNKNOWN)) {
                    ConstantValue constantValue = ConstantValue.UNKNOWN;
                    if (constantValue == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return constantValue;
                }
                ConstantValue uniqueAssignedConstantValue = (ConstantValue)((Object)ContainerUtil.getOnlyItem(EnumSet.copyOf(assignedConstantValues)));
                if (uniqueAssignedConstantValue != null && uniqueAssignedConstantValue != ConstantValue.UNKNOWN_BOOLEAN_VALUE && assignedConstantValues.size() > 1) {
                    ConstantValue constantValue = uniqueAssignedConstantValue;
                    if (constantValue == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return constantValue;
                }
                ConstantValue constantValue = ConstantValue.fromValue(PhpExpressionAlwaysConstantInspection.computeConstantState(instruction, variableName, writeVariableInstructions));
                if (constantValue == null) {
                    1.$$$reportNull$$$0(2);
                }
                return constantValue;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantInspection$1", "getConstantValue"));
            }
        };
    }

    private static PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState computeConstantState(PhpAccessVariableInstruction instruction, final CharSequence variableName, final TIntHashSet writeVariableInstructions) {
        final int initialInstructionNum = instruction.num();
        final EnumSet<PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState> constantStateRef = EnumSet.noneOf(PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.class);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                if (writeVariableInstructions.contains(instruction.num())) {
                    constantStateRef.add(PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS);
                    return false;
                }
                return true;
            }

            public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                if (constantStateRef.contains((Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS) || instruction.num() >= initialInstructionNum) {
                    return false;
                }
                PhpBooleanConstantValueDfaAnalyzer analyzer = new PhpBooleanConstantValueDfaAnalyzer();
                Object map = analyzer.performDFA(instruction.getCondition(), instruction.getResult());
                PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState computedConstantState = (PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState)((Object)map.get(variableName.toString()));
                if (computedConstantState != null) {
                    if (constantStateRef.isEmpty() || constantStateRef.contains((Object)computedConstantState)) {
                        constantStateRef.add(computedConstantState);
                    } else {
                        constantStateRef.add(PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS);
                    }
                    return false;
                }
                return true;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                constantStateRef.add(PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS);
                return true;
            }
        });
        return (PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState)((Object)ContainerUtil.getOnlyItem(constantStateRef, (Object)((Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS)));
    }

    private static boolean argumentOfReturnInsideFunctionByRef(Variable variable) {
        PhpReturn aReturn = (PhpReturn)ObjectUtils.tryCast((Object)variable.getParent(), PhpReturn.class);
        return aReturn != null && aReturn.getArgument() == variable && PhpExpressionAlwaysNullInspection.insideReturnByReferenceFunction(aReturn);
    }

    private static LocalQuickFix[] getFixes(Variable variable, ConstantValue constantValue, boolean isOnTheFly) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        fixes.add(PhpInstanceofIsAlwaysTrueInspection.getFix(constantValue, (PsiElement)variable));
        if (isOnTheFly) {
            fixes.add(new PhpIntroduceConstantQuickFix(constantValue));
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantInspection", "buildVisitor"));
    }

    private static final class PhpIntroduceConstantQuickFix
    implements LocalQuickFix,
    LowPriorityAction {
        private final ConstantValue myValue;

        private PhpIntroduceConstantQuickFix(ConstantValue value) {
            this.myValue = value;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("introduce.named.constant.for.value.0", this.myValue.getPresentableName());
            if (string == null) {
                PhpIntroduceConstantQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpIntroduceConstantQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpIntroduceConstantQuickFix.$$$reportNull$$$0(2);
            }
            Editor editor = PsiEditorUtil.findEditor((PsiElement)descriptor.getStartElement());
            PhpIntroduceConstantHandler handler = new PhpIntroduceConstantHandler(){

                @Override
                protected boolean isSupportedScope(@Nullable PsiElement scope, @NotNull PsiElement expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return true;
                }

                @Override
                protected PsiElement getConstantValue(@NotNull PhpIntroduceContext introduceContext) {
                    if (introduceContext == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return myValue.createPsi(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "introduceContext";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantInspection$PhpIntroduceConstantQuickFix$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSupportedScope";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getConstantValue";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            try {
                handler.invoke(handler.getIntroduceContext(editor, descriptor.getStartElement()));
            }
            catch (PhpIntroduceBaseHandler.RefactoringErrorException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)handler.getRefactoringName(), null);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantInspection$PhpIntroduceConstantQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantInspection$PhpIntroduceConstantQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ConstantValue {
        TRUE{

            @Override
            public PsiElement createPsi(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PhpPsiElementFactory.createConstantReference(project, "true");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantInspection$ConstantValue$1", "createPsi"));
            }
        }
        ,
        FALSE{

            @Override
            public PsiElement createPsi(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                return PhpPsiElementFactory.createConstantReference(project, "false");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantInspection$ConstantValue$2", "createPsi"));
            }
        }
        ,
        UNKNOWN,
        UNKNOWN_BOOLEAN_VALUE;

        private static final TokenSet BOOLEAN_TOKENS;

        public PsiElement createPsi(@NotNull Project project) {
            if (project == null) {
                ConstantValue.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException();
        }

        public static @NotNull ConstantValue fromValue(@Nullable PsiElement value, boolean resolve) {
            if ((value = PhpPsiUtil.unparenthesize(value)) instanceof PhpIsset || value instanceof PhpEmpty) {
                ConstantValue constantValue = UNKNOWN_BOOLEAN_VALUE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(1);
                }
                return constantValue;
            }
            if (PhpLangUtil.isTrue(value)) {
                ConstantValue constantValue = TRUE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(2);
                }
                return constantValue;
            }
            if (PhpLangUtil.isFalse(value)) {
                ConstantValue constantValue = FALSE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(3);
                }
                return constantValue;
            }
            if (value instanceof UnaryExpression && PhpPsiUtil.isOfType(value, PhpElementTypes.INFIX_EXPRESSION) && PhpPsiUtil.isOfType(((UnaryExpression)value).getOperation(), PhpTokenTypes.opNOT) || value instanceof UnaryExpression && PhpPsiUtil.isOfType(value, PhpElementTypes.CAST_EXPRESSION) && PhpPsiUtil.isOfType(((UnaryExpression)value).getOperation(), PhpTokenTypes.opBOOLEAN_CAST) || value instanceof BinaryExpression && BOOLEAN_TOKENS.contains(((BinaryExpression)value).getOperationType())) {
                ConstantValue constantValue = UNKNOWN_BOOLEAN_VALUE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(4);
                }
                return constantValue;
            }
            if (value instanceof TernaryExpression) {
                ConstantValue falseVariantConstantValue;
                ConstantValue trueVariantConstantValue = ConstantValue.fromValue((PsiElement)((TernaryExpression)value).getTrueVariant(), resolve);
                if (trueVariantConstantValue == (falseVariantConstantValue = ConstantValue.fromValue((PsiElement)((TernaryExpression)value).getFalseVariant(), resolve))) {
                    ConstantValue constantValue = trueVariantConstantValue;
                    if (constantValue == null) {
                        ConstantValue.$$$reportNull$$$0(5);
                    }
                    return constantValue;
                }
                if (trueVariantConstantValue == UNKNOWN || falseVariantConstantValue == UNKNOWN) {
                    ConstantValue constantValue = UNKNOWN;
                    if (constantValue == null) {
                        ConstantValue.$$$reportNull$$$0(6);
                    }
                    return constantValue;
                }
                ConstantValue constantValue = UNKNOWN_BOOLEAN_VALUE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(7);
                }
                return constantValue;
            }
            if (resolve && value instanceof FunctionReference && ConstantValue.isBoolean(((FunctionReference)value).getGlobalType()) && PhpExpressionAlwaysConstantInspection.resolveToFunctionThatAlwaysReturnBoolean((FunctionReference)value)) {
                ConstantValue constantValue = UNKNOWN_BOOLEAN_VALUE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(8);
                }
                return constantValue;
            }
            ConstantValue constantValue = UNKNOWN;
            if (constantValue == null) {
                ConstantValue.$$$reportNull$$$0(9);
            }
            return constantValue;
        }

        private static boolean isBoolean(PhpType type) {
            return !type.isEmpty() && type.filterOut(t -> "\\false".equals(t) || "\\bool".equals(t)).isEmpty();
        }

        public String getPresentableName() {
            return StringUtil.toLowerCase((String)this.name());
        }

        public static ConstantValue fromValue(@Nullable PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState state) {
            if (state == PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.TRUE) {
                return TRUE;
            }
            if (state == PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.FALSE) {
                return FALSE;
            }
            return UNKNOWN;
        }

        static {
            BOOLEAN_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.andNot((TokenSet)PhpTokenTypes.tsCOMPARE_OPS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opSPACESHIP})), PhpTokenTypes.tsLOGICAL_OPS});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantInspection$ConstantValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantInspection$ConstantValue";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPsi";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

