/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpUnnecessaryStringCastInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpArrayMapCanBeConvertedToLoopInspection;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Map;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCastIsUnnecessaryInspection
extends PhpInspection {
    private static final Map<String, PhpType> CAST_FUNCTIONS_TYPES = Map.of("strval", PhpType.STRING, "boolval", PhpType.BOOLEAN, "intval", PhpType.INT, "floatval", PhpType.FLOAT, "doubleval", PhpType.FLOAT);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpCastIsUnnecessaryInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpUnaryExpression(UnaryExpression expr) {
                PsiElement operation = expr.getOperation();
                if (operation == null) {
                    return;
                }
                PhpType type = PhpTypeAnalyserVisitor.getCastOperationType(PsiUtilCore.getElementType((PsiElement)operation));
                if (type.isEmpty()) {
                    return;
                }
                PhpPsiElement value = expr.getValue();
                this.doCheck(operation, type, (PsiElement)value);
            }

            private void doCheck(PsiElement elementToRegisterError, PhpType castType, PsiElement value) {
                if (value == null) {
                    return;
                }
                if (PhpCastIsUnnecessaryInspection.parameterWithoutRealType(value)) {
                    return;
                }
                PhpType valueType = new PhpType().add(value).global(value.getProject());
                if (!valueType.hasUnknown() && valueType.equals((Object)castType)) {
                    holder.registerProblem(elementToRegisterError, PhpBundle.message("inspection.message.cast.redundant", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{PhpUnnecessaryStringCastInspection.QUICK_FIX});
                }
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                PsiElement argument = reference.getParameter(0);
                if (argument == null) {
                    return;
                }
                PhpType castType = EntryStream.of(CAST_FUNCTIONS_TYPES).filterKeys(name -> PhpArrayMapCanBeConvertedToLoopInspection.isGlobalFunctionCallWithName(reference, name)).values().findFirst().orElse(null);
                if (castType == null) {
                    return;
                }
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                this.doCheck(nameNode.getPsi(), castType, argument);
            }
        };
    }

    public static boolean parameterWithoutRealType(@Nullable PsiElement value) {
        return value instanceof Variable && ContainerUtil.exists((Iterable)((Variable)value).resolveLocal(), r -> r instanceof Parameter && ((Parameter)r).getTypeDeclaration() == null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/type/PhpCastIsUnnecessaryInspection", "buildVisitor"));
    }
}

