/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrayAccessOnIllegalTypeInspection
extends PhpInspection {
    private static final PhpType NOT_ALLOWED_TYPES = PhpType.SCALAR.filter(PhpType.STRING);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayAccessOnIllegalTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                PhpTypedElement reference = (PhpTypedElement)ObjectUtils.tryCast((Object)expression.getValue(), PhpTypedElement.class);
                if (reference == null || reference instanceof ArrayAccessExpression) {
                    return;
                }
                Project project = expression.getProject();
                PhpType referenceType = reference.getGlobalType().filterUnknown();
                if (!referenceType.isEmpty() && NOT_ALLOWED_TYPES.getTypes().containsAll(referenceType.getTypes())) {
                    holder.registerProblem((PsiElement)expression.getValue(), PhpBundle.message("inspection.message.illegal.array.offset.access", referenceType.toStringResolved()), new LocalQuickFix[0]);
                }
            }
        };
    }

    @Override
    @Nullable
    protected ProblemHighlightType getPhp8CustomSeverity() {
        return ProblemHighlightType.WARNING;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/type/PhpArrayAccessOnIllegalTypeInspection", "buildVisitor"));
    }
}

