/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArithmeticTypeCheckInspection
extends PhpInspection {
    private static final TokenSet TYPE_CHECKED_PHP8_OPERATORS = TokenSet.andNot((TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsMATH_OPS, PhpTokenTypes.tsBIT_OPS, PhpTokenTypes.tsSHIFT_OPS, PhpTokenTypes.tsUNARY_POSTFIX_OPS, PhpTokenTypes.tsASGN_OPS, PhpTokenTypes.tsUNARY_PREFIX_OPS}), (TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opNOT, PhpTokenTypes.kwCLONE, PhpTokenTypes.opCOALESCE_ASGN}), PhpTokenTypes.CAST_OPERATORS}));
    private static final PhpType ALLOWED_FOR_MATH_IN_800 = new PhpType().add(PhpType.NUMBER).add(PhpType.FLOAT_INT).add(PhpType.BOOLEAN).add(PhpType.NULL).add(PhpType.STRING).add("\\GMP").add(PhpType.MIXED).add(PhpType.VOID);
    @NotNull
    public static final TokenSet ADDITIONS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opPLUS_ASGN});

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArithmeticTypeCheckInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                this.check(holder, (PhpPsiElement)expression, expression.getOperation(), (PsiElement)expression.getVariable(), (PsiElement)expression.getValue());
            }

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                this.check(holder, (PhpPsiElement)expression, expression.getOperation(), expression.getLeftOperand(), expression.getRightOperand());
            }

            public void visitPhpUnaryExpression(UnaryExpression expression) {
                this.check(holder, (PhpPsiElement)expression, expression.getOperation(), null, (PsiElement)expression.getValue());
            }

            private void check(@NotNull ProblemsHolder holder2, @NotNull PhpPsiElement mark, PsiElement operation, @Nullable PsiElement left, PsiElement right) {
                if (holder2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (mark == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (PhpPsiUtil.isOfType(operation, TYPE_CHECKED_PHP8_OPERATORS)) {
                    Project project = holder2.getProject();
                    PhpType lt = new PhpType().add(left).global(project);
                    PhpType rt = new PhpType().add(right).global(project);
                    if (lt.isAmbiguous() || rt.isAmbiguous()) {
                        return;
                    }
                    if (PhpPsiUtil.isOfType(operation, ADDITIONS) && PhpHierarchyChecksInspection.streamOfTypes(lt).anyMatch(PhpType::isArray) && PhpHierarchyChecksInspection.streamOfTypes(rt).anyMatch(PhpType::isArray)) {
                        return;
                    }
                    if (PhpType.intersects((PhpType)ALLOWED_FOR_MATH_IN_800, (PhpType)lt) && PhpType.intersects((PhpType)ALLOWED_FOR_MATH_IN_800, (PhpType)rt)) {
                        return;
                    }
                    PhpIndex index = PhpIndex.getInstance((Project)project);
                    if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN) && PhpType.STRING.isConvertibleFrom(lt, index) && PhpType.STRING.isConvertibleFrom(rt, index)) {
                        return;
                    }
                    holder2.registerProblem((PsiElement)mark, PhpBundle.message("types.not.supported.as.operands.for.0.1.2", operation.getText(), lt, rt), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "holder";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "mark";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/type/PhpArithmeticTypeCheckInspection$1";
                objectArray[2] = "check";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/type/PhpArithmeticTypeCheckInspection", "buildVisitor"));
    }
}

