/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.suppression;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressAllForFileCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForDocCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForFileCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForFunctionCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForStatementCommentFix;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpPsiElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSuppressionUtil {
    public static final String SUPPRESS_INSPECTIONS_TAG_NAME = "@noinspection";

    private PhpSuppressionUtil() {
    }

    public static SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(0);
        }
        return new SuppressQuickFix[]{new PhpSuppressForStatementCommentFix(toolId), new PhpSuppressForDocCommentFix(toolId), new PhpSuppressForFunctionCommentFix(toolId), new PhpSuppressForFileCommentFix(toolId), new PhpSuppressAllForFileCommentFix()};
    }

    public static boolean isSuppressedFor(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(1);
        }
        if (element == null) {
            return true;
        }
        if (element.getContainingFile() instanceof PhpExpressionCodeFragment || PhpParameterBasedTypeProvider.isMeta(element)) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> PhpSuppressionUtil.isSuppressedInComments(toolId, PhpSuppressionUtil.getAllSuppressionDocComments(element)));
    }

    public static Collection<PhpDocComment> getAllSuppressionDocComments(PsiElement place) {
        HashSet<PhpDocComment> res = new HashSet<PhpDocComment>();
        res.addAll(PhpSuppressionUtil.getPhpDocComments(PhpSuppressionUtil.findEnclosingSuppressibleStatement(place)));
        res.addAll(PhpSuppressionUtil.getPhpDocComments((PsiElement)place.getContainingFile()));
        res.addAll(PhpSuppressionUtil.getPhpDocCommentsFromFunction(place));
        return res;
    }

    private static Collection<PhpDocComment> getPhpDocCommentsFromFunction(PsiElement element) {
        SmartList result = new SmartList();
        Function anchor = PhpSuppressionUtil.getTopmostFunction(element);
        while (anchor != null) {
            PhpDocComment docComment = (PhpDocComment)ObjectUtils.tryCast((Object)anchor.getPrevPsiSibling(), PhpDocComment.class);
            ContainerUtil.addIfNotNull((Collection)result, (Object)docComment);
            anchor = docComment;
        }
        return result;
    }

    @Nullable
    public static Function getTopmostFunction(@Nullable PsiElement element) {
        return (Function)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)e -> e instanceof Function && !((Function)e).isClosure()));
    }

    @NotNull
    public static List<PhpDocComment> getPhpDocComments(@Nullable PsiElement element) {
        if (element == null) {
            List<PhpDocComment> list = Collections.emptyList();
            if (list == null) {
                PhpSuppressionUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (element instanceof Statement || element instanceof PhpNamedElement || element instanceof PsiComment) {
            PsiElement parent;
            PhpPsiElement prev = element instanceof PsiComment ? PhpPsiElementImpl.findPrevPhpPsiElement(element) : ((PhpPsiElement)element).getPrevPsiSibling();
            SmartList comments = new SmartList();
            if (element instanceof PhpCase && prev instanceof PhpCase) {
                PsiElement child = prev.getLastChild();
                ASTNode nonWhitespaceSibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child.getNode());
                PsiElement sibling = null;
                if (nonWhitespaceSibling != null) {
                    sibling = nonWhitespaceSibling.getPsi();
                }
                if (sibling instanceof PhpDocComment) {
                    comments.add((PhpDocComment)sibling);
                }
            }
            while (prev instanceof PhpDocComment) {
                comments.add((PhpDocComment)prev);
                prev = prev.getPrevPsiSibling();
            }
            if (comments.size() == 0 && (element instanceof Statement || element instanceof Parameter) && ((parent = element.getParent()) instanceof GroupStatement || parent instanceof ParameterList) && (prev = ((PhpPsiElement)parent).getPrevPsiSibling()) instanceof PhpDocComment) {
                comments.add((PhpDocComment)prev);
            }
            SmartList smartList = comments;
            if (smartList == null) {
                PhpSuppressionUtil.$$$reportNull$$$0(3);
            }
            return smartList;
        }
        if (element instanceof PhpFile) {
            SmartList result = null;
            for (PsiElement child = element.getFirstChild().getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child.getNode() instanceof CompositeElement)) continue;
                if (!PhpDocComment.INSTANCEOF.value((Object)child)) break;
                if (result == null) {
                    result = new SmartList();
                }
                result.add((PhpDocComment)child);
            }
            SmartList smartList = result != null ? result : Collections.emptyList();
            if (smartList == null) {
                PhpSuppressionUtil.$$$reportNull$$$0(4);
            }
            return smartList;
        }
        List<PhpDocComment> list = Collections.emptyList();
        if (list == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static boolean isSuppressedInComments(@NotNull String toolId, Collection<PhpDocComment> comments) {
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(6);
        }
        return comments.stream().anyMatch(comment -> PhpSuppressionUtil.isSuppressedInComment(toolId, comment));
    }

    public static boolean isSuppressedInComment(@NotNull String toolId, @Nullable PhpDocComment comment) {
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(7);
        }
        return PhpSuppressionUtil.getSuppressionsIds(comment).anyMatch(suppressionId -> SuppressionUtil.isInspectionToolIdMentioned((String)suppressionId, (String)toolId));
    }

    @NotNull
    public static Stream<String> getSuppressionsIds(@Nullable PhpDocComment comment) {
        Stream<String> stream = comment != null ? Arrays.stream(comment.getTagElementsByName(SUPPRESS_INSPECTIONS_TAG_NAME)).map(PhpDocTag::getTagValue) : Stream.empty();
        if (stream == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(8);
        }
        return stream;
    }

    @Nullable
    public static PsiElement findEnclosingSuppressibleStatement(@Nullable PsiElement element) {
        return PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)e -> e instanceof Statement && !(e instanceof GroupStatement) || e instanceof PhpNamedElement && !(e instanceof PhpDocPsiElement) && !(e instanceof Variable) || e instanceof PsiComment), (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/suppression/PhpSuppressionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/suppression/PhpSuppressionUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpDocComments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressionsIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedInComments";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedInComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

