/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.suppression;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.suppression.AbstractPhpSuppressFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import org.jetbrains.annotations.NotNull;

public class PhpSuppressForDocCommentFix
extends AbstractPhpSuppressFix {
    @IntentionName
    public static final String NAME = PhpBundle.message("suppress.for.phpdoc.comment", new Object[0]);

    public PhpSuppressForDocCommentFix(String toolId) {
        super(toolId, false);
    }

    @NotNull
    public String getText() {
        String string = NAME;
        if (string == null) {
            PhpSuppressForDocCommentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PsiElement getContainer(PsiElement context) {
        return PhpPsiUtil.getParentByCondition(context, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF);
    }

    @Override
    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        if (project == null) {
            PhpSuppressForDocCommentFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpSuppressForDocCommentFix.$$$reportNull$$$0(2);
        }
        if (container == null) {
            PhpSuppressForDocCommentFix.$$$reportNull$$$0(3);
        }
        PhpSuppressForDocCommentFix.addSuppressTagToComment(container, this.getSuppressionTagText());
    }

    static void addSuppressTagToComment(@NotNull PsiElement docComment, String suppressionText) {
        PhpDocTag suppressionDocTag;
        PsiWhiteSpace newLineBeforeDocTag;
        if (docComment == null) {
            PhpSuppressForDocCommentFix.$$$reportNull$$$0(4);
        }
        if ((newLineBeforeDocTag = (PsiWhiteSpace)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)(suppressionDocTag = PhpPsiElementFactory.createPhpPsiFromText(docComment.getProject(), PhpDocTag.class, "/**\n* " + suppressionText + "*/\nfunction a() {}")), (Condition<? super PsiElement>)((Condition)e -> e instanceof PsiWhiteSpace && e.getText().equals("\n")))) == null) {
            return;
        }
        docComment.addRangeBefore((PsiElement)newLineBeforeDocTag, (PsiElement)suppressionDocTag, docComment.getLastChild());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/suppression/PhpSuppressForDocCommentFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/suppression/PhpSuppressForDocCommentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSuppression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSuppressTagToComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

