/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.stubs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import com.jetbrains.php.config.library.PhpExtensionStubsMetadataProvider;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpInspectionsUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDisabledExtensionStubsInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        Project project;
        Set<Map.Entry<String, Boolean>> extensions;
        Set disabledExtensions;
        if (holder == null) {
            PhpDisabledExtensionStubsInspection.$$$reportNull$$$0(0);
        }
        if ((disabledExtensions = ((StreamEx)StreamEx.of(extensions = PhpRuntimeConfiguration.getInstance(project = holder.getProject()).getExtensions().entrySet()).filter(entry -> (Boolean)entry.getValue() == false)).map(Map.Entry::getKey).toSet()).isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpDisabledExtensionStubsInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new PhpElementVisitor(){

            public void visitPhpClassReference(ClassReference classReference) {
                this.inspect((PhpReference)classReference, PhpTypeSignatureKey.CLASS);
            }

            public void visitPhpDocType(PhpDocType phpDocType) {
                this.inspect((PhpReference)phpDocType, PhpTypeSignatureKey.CLASS);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.inspect((PhpReference)reference, PhpTypeSignatureKey.FUNCTION);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                this.inspect((PhpReference)reference, PhpTypeSignatureKey.CONSTANT);
            }

            private void inspect(@NotNull PhpReference reference, @NotNull PhpTypeSignatureKey key) {
                String extension;
                String fqn;
                Object[] results;
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (key == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ArrayUtil.isEmpty((Object[])(results = reference.multiResolve(false))) && (fqn = reference.getFQN()) != null && (extension = PhpExtensionStubsMetadataProvider.findDisabledExtension(project, key.sign((CharSequence)fqn))) != null) {
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.php.disabled.extension.stubs.description", extension), this.createFixes(extension));
                }
            }

            private LocalQuickFix @NotNull [] createFixes(@NotNull String extension) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (isOnTheFly) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new PhpEnableExtensionQuickFix(extension), new PhpConfigureExtensionsQuickFix(extension)};
                    if (localQuickFixArray == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return localQuickFixArray;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new PhpEnableExtensionQuickFix(extension)};
                if (localQuickFixArray == null) {
                    1.$$$reportNull$$$0(4);
                }
                return localQuickFixArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpDisabledExtensionStubsInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpDisabledExtensionStubsInspection$1";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createFixes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "inspect";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createFixes";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return PhpInspectionsUtil.createPanelWithSettingsLink(PhpBundle.message("languages.frameworks.php.php.runtime", new Object[0]), PhpProjectConfigurable.class, PhpProjectConfigurable::new, configurable -> configurable.openPhpRuntimeTab(false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpDisabledExtensionStubsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpDisabledExtensionStubsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpConfigureExtensionsQuickFix
    implements LocalQuickFix {
        private final String myExtension;

        PhpConfigureExtensionsQuickFix(@NotNull String extension) {
            if (extension == null) {
                PhpConfigureExtensionsQuickFix.$$$reportNull$$$0(0);
            }
            this.myExtension = extension;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.configure.extensions.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpConfigureExtensionsQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpConfigureExtensionsQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpConfigureExtensionsQuickFix.$$$reportNull$$$0(3);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                PhpProjectConfigurable configurable = new PhpProjectConfigurable(project);
                configurable.openPhpRuntimeTab(false, this.myExtension);
                PhpUiUtil.editConfigurable(project, (Configurable)configurable);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpDisabledExtensionStubsInspection$PhpConfigureExtensionsQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpDisabledExtensionStubsInspection$PhpConfigureExtensionsQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpEnableExtensionQuickFix
    implements LocalQuickFix {
        private final String myExtension;

        PhpEnableExtensionQuickFix(@NotNull String extension) {
            if (extension == null) {
                PhpEnableExtensionQuickFix.$$$reportNull$$$0(0);
            }
            this.myExtension = extension;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = PhpBundle.message("php.enable.extension.quick.fix.text", this.myExtension);
            if (string == null) {
                PhpEnableExtensionQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.enable.extension.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpEnableExtensionQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpEnableExtensionQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                PhpEnableExtensionQuickFix.$$$reportNull$$$0(4);
            }
            PhpRuntimeConfiguration configuration = PhpRuntimeConfiguration.getInstance(project);
            Map<String, Boolean> extensions = configuration.getExtensions();
            extensions.put(this.myExtension, true);
            configuration.setExtensions(extensions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpDisabledExtensionStubsInspection$PhpEnableExtensionQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpDisabledExtensionStubsInspection$PhpEnableExtensionQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

