/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.stubs;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpExtensionsManager;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurableForm;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpSimpleFunctionDefinedDFAnalyzer;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedConstantInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedFunctionInspection;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpComposerExtensionStubsInspection
extends PhpInspection {
    public boolean REQUIRE_BUNDLED_EXTENSIONS = true;

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpComposerExtensionStubsInspection.$$$reportNull$$$0(0);
        }
        HashSet excludedCategories = this.REQUIRE_BUNDLED_EXTENSIONS ? ContainerUtil.newHashSet((Object[])new PhpExtensionsManager.ExtensionCategory[]{PhpExtensionsManager.ExtensionCategory.CORE}) : ContainerUtil.newHashSet((Object[])new PhpExtensionsManager.ExtensionCategory[]{PhpExtensionsManager.ExtensionCategory.CORE, PhpExtensionsManager.ExtensionCategory.BUNDLED});
        ComposerDataService dataService = ComposerDataService.getInstance(holder.getProject());
        if (dataService == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerExtensionStubsInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        String path = dataService.getConfigPath();
        if (path == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerExtensionStubsInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        VirtualFile config = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (config == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerExtensionStubsInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        PhpComposerExtensionStubsInspection.saveLaterIfNeeded(config);
        final EnumMap<DependencyContext, Set<String>> extensions = PhpComposerExtensionStubsInspection.getExtensions(config);
        if (extensions == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerExtensionStubsInspection.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        Map<String, PhpExtensionsManager.ExtensionCategory> extensionToCategory = PhpProjectConfigurableForm.getExtensionToCategory();
        final Map extensionMap = PhpRuntimeLibraryRootsProvider.getLibraryRoots(holder.getProject()).stream().filter(ext -> !excludedCategories.contains(extensionToCategory.get(ext.getName()))).collect(Collectors.toMap(ext -> "ext-" + StringUtil.toLowerCase((String)ext.getName()).replace(' ', '-'), Function.identity()));
        return new PhpElementVisitor(){

            public void visitPhpClassReference(ClassReference classReference) {
                this.inspect((PhpReference)classReference);
            }

            public void visitPhpDocType(PhpDocType phpDocType) {
                this.inspect((PhpReference)phpDocType);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.inspect((PhpReference)reference);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                this.inspect((PhpReference)reference);
            }

            private void inspect(@NotNull PhpReference reference) {
                LocalQuickFix moveToRequireFix;
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PhpComposerExtensionStubsInspection.isDfaReachable((PsiElement)reference)) {
                    return;
                }
                MultiMap missedExtensions = MultiMap.create();
                boolean dev = ProjectRootManager.getInstance((Project)reference.getProject()).getFileIndex().isInTestSourceContent(reference.getContainingFile().getVirtualFile());
                for (ResolveResult result : reference.multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (element == null) {
                        return;
                    }
                    VirtualFile file = element.getContainingFile().getVirtualFile();
                    String missedExtension = (String)ContainerUtil.find(extensionMap.keySet(), ext -> this.missedExtension((String)ext, file, dev ? DependencyContext.DEV : DependencyContext.ALL));
                    if (missedExtension == null) {
                        return;
                    }
                    missedExtensions.putValue((Object)missedExtension, (Object)file);
                }
                if (missedExtensions.size() == 0) {
                    return;
                }
                assert (missedExtensions.size() == 1);
                String missedExtension = (String)ContainerUtil.getFirstItem((Collection)missedExtensions.keySet());
                if (missedExtensions.get((Object)missedExtension).size() != 1) {
                    return;
                }
                if (PhpComposerExtensionStubsInspection.isExtensionDfaReachable(missedExtension, reference)) {
                    return;
                }
                VirtualFile missedExtensionFile = (VirtualFile)ContainerUtil.getFirstItem((Collection)missedExtensions.get((Object)missedExtension));
                if (!this.missedExtension(missedExtension, missedExtensionFile, DependencyContext.DEV)) {
                    String message = PhpBundle.message("inspection.ext.is.specified.in.require.dev.but.used.outside.tests", missedExtension);
                    moveToRequireFix = MoveFromDevToRequireQuickFix.getInstance(missedExtension, DependencyContext.DEV, DependencyContext.ALL, isOnTheFly);
                    holder.registerProblem((PsiElement)reference, message, ProblemHighlightType.WEAK_WARNING, reference.getRangeInElement(), new LocalQuickFix[]{moveToRequireFix});
                } else if (!this.missedExtension(missedExtension, missedExtensionFile, DependencyContext.SUGGEST)) {
                    LocalQuickFix[] localQuickFixArray;
                    String message = PhpBundle.message("inspection.ext.is.specified.in.suggest", missedExtension);
                    moveToRequireFix = MoveFromDevToRequireQuickFix.getInstance(missedExtension, DependencyContext.SUGGEST, DependencyContext.ALL, isOnTheFly);
                    LocalQuickFix moveToDevFix = MoveFromDevToRequireQuickFix.getInstance(missedExtension, DependencyContext.SUGGEST, DependencyContext.DEV, isOnTheFly);
                    if (dev) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                        localQuickFixArray2[0] = moveToRequireFix;
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[1] = moveToDevFix;
                    } else {
                        LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray3;
                        localQuickFixArray3[0] = moveToRequireFix;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem((PsiElement)reference, message, ProblemHighlightType.WEAK_WARNING, reference.getRangeInElement(), fixes);
                } else {
                    String message = PhpBundle.message("inspection.missing.ext.composer.json", missedExtension);
                    holder.registerProblem((PsiElement)reference, reference.getRangeInElement(), message, new LocalQuickFix[]{AddToComposerJsonQuickFix.getInstance(missedExtension, isOnTheFly, dev)});
                }
            }

            private boolean missedExtension(String ext, VirtualFile file, DependencyContext context) {
                if ("ext-json".equals(ext) && PhpLanguageLevel.current(holder.getProject()).isAtLeast(PhpLanguageLevel.PHP800)) {
                    return false;
                }
                return !((Set)extensions.get((Object)DependencyContext.ALL)).contains(ext) && !((Set)extensions.get((Object)context)).contains(ext) && VfsUtilCore.isAncestor((VirtualFile)((VirtualFile)extensionMap.get(ext)), (VirtualFile)file, (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$1", "inspect"));
            }
        };
    }

    @Nullable
    private static EnumMap<DependencyContext, Set<String>> getExtensions(VirtualFile config) {
        EnumMap<DependencyContext, Set<String>> res = new EnumMap<DependencyContext, Set<String>>(DependencyContext.class);
        for (DependencyContext context : DependencyContext.values()) {
            Set<String> extensions = ComposerConfigUtils.getExtensions(config, context);
            if (extensions == null) {
                return null;
            }
            res.put(context, extensions);
        }
        return res;
    }

    private static boolean isExtensionDfaReachable(String extensionName, PhpReference reference) {
        PhpInstruction instruction = PhpUndefinedClassInspection.findNearestInstruction((PsiElement)reference);
        Ref canBeDefined = Ref.create((Object)false);
        Ref canBeUndefined = Ref.create((Object)false);
        if (instruction != null) {
            PhpDFAUtil.performReachingDefinitions(instruction, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, StringUtil.trimStart((String)extensionName, (String)"ext-"), new PhpSimpleFunctionDefinedDFAnalyzer("extension_loaded"));
        }
        return (Boolean)canBeDefined.get() != false && (Boolean)canBeUndefined.get() == false;
    }

    private static boolean isDfaReachable(PsiElement reference) {
        Ref canBeDefined = Ref.create((Object)false);
        Ref canBeUndefined = Ref.create((Object)false);
        if (reference instanceof ClassReference) {
            PhpUndefinedClassInspection.processDfaReachability((ClassReference)reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
        } else if (reference instanceof FunctionReference) {
            PhpUndefinedFunctionInspection.processDfaReachability((FunctionReference)reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
        } else if (reference instanceof ConstantReference) {
            PhpUndefinedConstantInspection.processDfaReachability((ConstantReference)reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
        }
        return (Boolean)canBeDefined.get() != false && (Boolean)canBeUndefined.get() == false;
    }

    private static void saveLaterIfNeeded(@NotNull VirtualFile config) {
        FileDocumentManager documentManager;
        Document document;
        if (config == null) {
            PhpComposerExtensionStubsInspection.$$$reportNull$$$0(5);
        }
        if ((document = (documentManager = FileDocumentManager.getInstance()).getDocument(config)) != null && documentManager.isDocumentUnsaved(document)) {
            ApplicationManager.getApplication().invokeLater(() -> documentManager.saveDocument(document));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveLaterIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class AddToComposerJsonQuickFix
    implements LocalQuickFix {
        private static final Set<AddToComposerJsonQuickFix> fixCache = ContainerUtil.newConcurrentSet();
        private final String myExtension;
        private final boolean myOnTheFly;
        private final boolean myDev;

        private AddToComposerJsonQuickFix(@NotNull String extension, boolean onTheFly, boolean dev) {
            if (extension == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(0);
            }
            this.myExtension = extension;
            this.myOnTheFly = onTheFly;
            this.myDev = dev;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("add.to.composer.json.quick.fix", this.myExtension);
            if (string == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            VirtualFile file;
            if (project == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(3);
            }
            if ((file = AddToComposerJsonQuickFix.getComposerJsonFile(project)) == null) {
                return;
            }
            JsonObject requireSectionValue = AddToComposerJsonQuickFix.findRequireSectionValue(project, file, this.myDev ? DependencyContext.DEV : DependencyContext.ALL);
            if (requireSectionValue == null) {
                return;
            }
            JsonProperty property = AddToComposerJsonQuickFix.findOrCreateProperty(project, requireSectionValue, this.myExtension, "\"*\"");
            if (this.myOnTheFly) {
                AddToComposerJsonQuickFix.navigateToProperty(project, file, property);
            }
        }

        private static void navigateToProperty(@NotNull Project project, VirtualFile file, JsonProperty property) {
            FileEditorManager fileManager;
            if (project == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(4);
            }
            if ((fileManager = FileEditorManager.getInstance((Project)project)) != null) {
                fileManager.openFile(file, true);
                Editor editor = fileManager.getSelectedTextEditor();
                if (editor != null) {
                    editor.getCaretModel().moveToOffset(property.getTextRange().getEndOffset());
                }
            }
        }

        @Nullable
        private static VirtualFile getComposerJsonFile(@NotNull Project project) {
            if (project == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(5);
            }
            String path = ComposerDataService.getInstance(project).getConfigPath();
            return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        }

        @Nullable
        private static JsonObject findRequireSectionValue(@NotNull Project project, VirtualFile composerJsonFile, DependencyContext context) {
            JsonObject topObject;
            if (project == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(6);
            }
            String path = ComposerDataService.getInstance(project).getConfigPath();
            if (composerJsonFile == null) {
                Messages.showMessageDialog((Project)project, (String)PhpBundle.message("action.detect.composer.json.not.found", path), (String)PhpBundle.message("action.detect.composer.json.not.found.title", new Object[0]), (Icon)Messages.getWarningIcon());
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(composerJsonFile);
            if (psiFile == null) {
                return null;
            }
            JsonFile jsonFile = (JsonFile)ObjectUtils.tryCast((Object)psiFile, JsonFile.class);
            if (jsonFile == null) {
                return null;
            }
            JsonValue value = jsonFile.getTopLevelValue();
            if (value == null) {
                jsonFile.add((PsiElement)new JsonElementGenerator(project).createValue("{}"));
            }
            if ((topObject = (JsonObject)ObjectUtils.tryCast((Object)jsonFile.getTopLevelValue(), JsonObject.class)) == null) {
                return null;
            }
            JsonProperty requireSection = AddToComposerJsonQuickFix.findOrCreateProperty(project, topObject, context.getSectionName(), "{}");
            return (JsonObject)requireSection.getValue();
        }

        private static JsonProperty findOrCreateProperty(@NotNull Project project, @NotNull JsonObject parent, @NotNull String propertyName, @NotNull String propertyValue) {
            JsonProperty property;
            if (project == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(7);
            }
            if (parent == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(8);
            }
            if (propertyName == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(9);
            }
            if (propertyValue == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(10);
            }
            if ((property = parent.findProperty(propertyName)) != null) {
                return property;
            }
            JsonElementGenerator generator = new JsonElementGenerator(project);
            property = generator.createProperty(propertyName, propertyValue);
            List list = parent.getPropertyList();
            if (list.isEmpty()) {
                parent = (JsonObject)parent.replace((PsiElement)generator.createObject(property.getText()));
                return parent.findProperty(propertyName);
            }
            PsiElement comma = parent.addAfter(generator.createComma(), (PsiElement)ContainerUtil.getLastItem((List)list));
            return (JsonProperty)parent.addAfter((PsiElement)property, comma);
        }

        public static LocalQuickFix getInstance(@NotNull String extension, boolean onTheFly, boolean dev) {
            AddToComposerJsonQuickFix fix;
            if (extension == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(11);
            }
            if ((fix = (AddToComposerJsonQuickFix)ContainerUtil.find(fixCache, i -> i.myExtension.equals(extension) && i.myDev == dev && i.myOnTheFly == onTheFly)) == null) {
                fix = new AddToComposerJsonQuickFix(extension, onTheFly, dev);
                fixCache.add(fix);
            }
            return fix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$AddToComposerJsonQuickFix";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$AddToComposerJsonQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "navigateToProperty";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getComposerJsonFile";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findRequireSectionValue";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreateProperty";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MoveFromDevToRequireQuickFix
    implements LocalQuickFix {
        private final String myExtension;
        private final DependencyContext myFrom;
        private final DependencyContext myTo;
        private final boolean myIsOnTheFly;

        private MoveFromDevToRequireQuickFix(String extension, DependencyContext from, DependencyContext to, boolean onTheFly) {
            this.myExtension = extension;
            this.myFrom = from;
            this.myTo = to;
            this.myIsOnTheFly = onTheFly;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.move.from.to.composer.json.section", this.myExtension, this.myFrom.getSectionName(), this.myTo.getSectionName());
            if (string == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            VirtualFile file;
            JsonProperty extensionFrom;
            if (project == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(2);
            }
            if ((extensionFrom = this.findExtensionToMoveFrom(project, file = AddToComposerJsonQuickFix.getComposerJsonFile(project))) == null) {
                return;
            }
            JsonValue extensionInDevValue = extensionFrom.getValue();
            if (extensionInDevValue == null) {
                return;
            }
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)extensionFrom, PsiUtilCore.getElementType((PsiElement)new JsonElementGenerator(project).createComma()), false);
            JsonProperty property = this.moveExtensionTo(project, file, extensionFrom, extensionInDevValue);
            if (property != null && this.myIsOnTheFly) {
                AddToComposerJsonQuickFix.navigateToProperty(project, file, property);
            }
        }

        @Nullable
        private JsonProperty moveExtensionTo(@NotNull Project project, VirtualFile file, JsonProperty extensionInDev, JsonValue extensionInDevValue) {
            JsonObject requireSection;
            if (project == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(3);
            }
            return (requireSection = AddToComposerJsonQuickFix.findRequireSectionValue(project, file, this.myTo)) != null ? AddToComposerJsonQuickFix.findOrCreateProperty(project, requireSection, extensionInDev.getName(), extensionInDevValue.getText()) : null;
        }

        @Nullable
        private JsonProperty findExtensionToMoveFrom(@NotNull Project project, VirtualFile file) {
            JsonObject requireDevSection;
            if (project == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(4);
            }
            return (requireDevSection = AddToComposerJsonQuickFix.findRequireSectionValue(project, file, this.myFrom)) != null ? requireDevSection.findProperty(this.myExtension) : null;
        }

        private static LocalQuickFix getInstance(String extension, DependencyContext from, DependencyContext to, boolean onTheFly) {
            return new MoveFromDevToRequireQuickFix(extension, from, to, onTheFly);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$MoveFromDevToRequireQuickFix";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$MoveFromDevToRequireQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "moveExtensionTo";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findExtensionToMoveFrom";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum DependencyContext {
        ALL{

            @Override
            public String getSectionName() {
                return "require";
            }
        }
        ,
        DEV{

            @Override
            public String getSectionName() {
                return "require-dev";
            }
        }
        ,
        SUGGEST{

            @Override
            public String getSectionName() {
                return "suggest";
            }
        };


        public abstract String getSectionName();
    }

    public class OptionsPanel {
        private JBCheckBox myRequireBundledExtensions;
        private JPanel myOptionsPanel;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myRequireBundledExtensions.setSelected(PhpComposerExtensionStubsInspection.this.REQUIRE_BUNDLED_EXTENSIONS);
            this.myRequireBundledExtensions.addChangeListener(e -> {
                PhpComposerExtensionStubsInspection.this.REQUIRE_BUNDLED_EXTENSIONS = this.myRequireBundledExtensions.isSelected();
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myRequireBundledExtensions = jBCheckBox = new JBCheckBox();
            jBCheckBox.setSelected(false);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.missing.ext.require.bundled"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

