/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.visitors;

import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpEval;
import com.jetbrains.php.lang.psi.elements.PhpExit;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpExpressionVisitor
extends PhpElementVisitor {
    @NotNull
    final Consumer<? super PhpPsiElement> myExpressionProcessor;

    public PhpExpressionVisitor(@NotNull Consumer<? super PhpPsiElement> expressionProcessor) {
        if (expressionProcessor == null) {
            PhpExpressionVisitor.$$$reportNull$$$0(0);
        }
        this.myExpressionProcessor = expressionProcessor;
    }

    public void visitPhpElement(PhpPsiElement element) {
        if (element instanceof Statement) {
            this.visitPhpStatement((Statement)element);
        }
        if (element instanceof PhpExpression) {
            this.visitPhpExpression((PhpExpression)element);
        }
    }

    public void visitPhpIf(If ifStatement) {
        this.visitControlFlow((ControlStatement)ifStatement);
        this.visitElements((PsiElement[])ifStatement.getElseIfBranches());
        this.visitElements(new PsiElement[]{ifStatement.getElseBranch()});
    }

    public void visitPhpElseIf(ElseIf elseIfStatement) {
        this.visitControlFlow((ControlStatement)elseIfStatement);
    }

    public void visitPhpElse(Else elseStatement) {
        this.visitElements(new PsiElement[]{elseStatement.getStatement()});
    }

    public void visitPhpWhile(While whileStatement) {
        this.visitControlFlow((ControlStatement)whileStatement);
    }

    public void visitPhpDoWhile(DoWhile doWhileStatement) {
        this.visitControlFlow((ControlStatement)doWhileStatement);
    }

    public void visitPhpForeach(ForeachStatement foreach) {
        this.visitElements(new PsiElement[]{foreach.getKey(), foreach.getValue(), foreach.getArray(), foreach.getStatement()});
    }

    public void visitPhpFor(For forStatement) {
        this.visitElements(new PsiElement[][]{forStatement.getInitialExpressions(), forStatement.getConditionalExpressions(), forStatement.getRepeatedExpressions()});
        this.visitElements(new PsiElement[]{forStatement.getStatement()});
    }

    public void visitPhpSwitch(PhpSwitch switchStatement) {
        this.visitElements(switchStatement.getArgument());
        this.visitElements((PsiElement[])switchStatement.getAllCases());
    }

    public void visitPhpCase(PhpCase phpCase) {
        this.visitControlFlow((ControlStatement)phpCase);
    }

    public void visitPhpTry(Try tryStatement2) {
        this.visitElements((PsiElement[])tryStatement2.getCatchClauses());
        this.visitElements(new PsiElement[]{tryStatement2.getStatement(), tryStatement2.getFinallyBlock()});
    }

    public void visitPhpCatch(Catch phpCatch) {
        this.visitElements(new PsiElement[]{phpCatch.getException(), phpCatch.getStatement()});
    }

    public void visitPhpFinally(Finally element) {
        this.visitElements(new PsiElement[]{element.getStatement()});
    }

    public void visitPhpReturn(PhpReturn returnStatement) {
        this.visitElements(returnStatement.getArgument());
    }

    public void visitPhpYield(PhpYield element) {
        this.visitElements(element.getArgument());
    }

    public void visitPhpGroupStatement(GroupStatement groupStatement) {
        this.visitElements(groupStatement.getStatements());
    }

    public void visitPhpGlobal(Global globalStatement) {
        this.visitElements((PsiElement[])globalStatement.getVariables());
    }

    public void visitPhpNamespace(PhpNamespace namespace) {
        this.visitElements(new PsiElement[]{namespace.getStatements()});
    }

    public void visitPhpExpression(PhpExpression expression) {
        this.myExpressionProcessor.consume((Object)expression);
    }

    public void visitPhpUse(PhpUse expression) {
        PhpReference targetReference = expression.getTargetReference();
        if (targetReference != null) {
            this.visitPhpExpression((PhpExpression)targetReference);
        }
    }

    public void visitPhpNewExpression(NewExpression expression) {
        this.visitPhpExpression((PhpExpression)expression);
    }

    public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
        this.visitPhpExpression((PhpExpression)assignmentExpression);
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        this.visitPhpExpression((PhpExpression)expression);
    }

    public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
        this.visitPhpExpression((PhpExpression)multiassignmentExpression);
    }

    public void visitPhpUnaryExpression(UnaryExpression expr) {
        this.visitPhpExpression((PhpExpression)expr);
    }

    public void visitPhpVariable(Variable variable) {
        this.visitPhpExpression((PhpExpression)variable);
    }

    public void visitPhpClassReference(ClassReference classReference) {
        this.visitPhpExpression((PhpExpression)classReference);
    }

    public void visitPhpMethodReference(MethodReference reference) {
        this.visitPhpExpression((PhpExpression)reference);
    }

    public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
        this.visitPhpExpression((PhpExpression)constantReference);
    }

    public void visitPhpFieldReference(FieldReference fieldReference) {
        this.visitPhpExpression((PhpExpression)fieldReference);
    }

    public void visitPhpFunctionCall(FunctionReference reference) {
        this.visitPhpExpression((PhpExpression)reference);
    }

    public void visitPhpInclude(Include include) {
        this.visitPhpExpression((PhpExpression)include);
    }

    public void visitPhpConstantReference(ConstantReference reference) {
        this.visitPhpExpression((PhpExpression)reference);
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        this.visitPhpExpression((PhpExpression)expression);
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        this.visitPhpExpression((PhpExpression)expression);
    }

    public void visitPhpTernaryExpression(TernaryExpression expression) {
        this.visitPhpExpression((PhpExpression)expression);
    }

    public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
        this.visitPhpExpression((PhpExpression)expression);
    }

    public void visitPhpParenthesizedExpression(ParenthesizedExpression expression) {
        this.visitPhpExpression((PhpExpression)expression);
    }

    public void visitPhpIsset(PhpIsset issetExpression) {
        this.visitPhpExpression((PhpExpression)issetExpression);
    }

    public void visitPhpEmpty(PhpEmpty emptyExpression) {
        this.visitPhpExpression((PhpExpression)emptyExpression);
    }

    public void visitPhpUnset(PhpUnset unsetStatement) {
        this.visitElements((PsiElement[])unsetStatement.getArguments());
    }

    public void visitPhpExit(PhpExit exitExpression) {
        this.visitPhpExpression((PhpExpression)exitExpression);
    }

    public void visitPhpPrint(PhpPrintExpression printExpression) {
        this.visitPhpExpression((PhpExpression)printExpression);
    }

    public void visitPhpEval(PhpEval element) {
        this.visitPhpExpression((PhpExpression)element);
    }

    public void visitPhpThrowExpression(PhpThrowExpression throwExpression) {
        this.apply((PsiElement)throwExpression.getArgument());
    }

    public void visitPhpStaticStatement(PhpStaticStatement staticStatement) {
        staticStatement.getDeclarations().forEach(arg_0 -> ((PhpExpressionVisitor)this).apply(arg_0));
    }

    public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
        this.visitElements((PsiElement[])echoStatement.getArguments());
    }

    public void visitPhpTraitUseRule(PhpTraitUseRule type) {
        this.apply((PsiElement)type.getOriginalReference());
        for (ClassReference override : type.getOverrides()) {
            this.apply((PsiElement)override);
        }
        this.apply((PsiElement)type.getOriginal());
    }

    public void visitPhpConstant(Constant constant) {
        this.visitElements(constant.getChildren());
    }

    public void visitPhpStatement(Statement statement) {
        this.visitElements(statement.getChildren());
    }

    private void visitElements(PsiElement ... elements) {
        if (elements == null) {
            PhpExpressionVisitor.$$$reportNull$$$0(1);
        }
        for (PsiElement element : elements) {
            this.apply(element);
        }
    }

    private void visitElements(PsiElement[] ... elementArrays) {
        for (PsiElement[] elementArray : elementArrays) {
            this.visitElements(elementArray);
        }
    }

    private void visitControlFlow(@NotNull ControlStatement controlStmt) {
        if (controlStmt == null) {
            PhpExpressionVisitor.$$$reportNull$$$0(2);
        }
        this.visitElements(new PsiElement[]{controlStmt.getCondition(), controlStmt.getStatement()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlStmt";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/visitors/PhpExpressionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitControlFlow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

