/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.elements;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.inspections.reference.PhpRefManager;
import com.jetbrains.php.lang.inspections.reference.PhpRefMetaData;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElementImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunctionImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethodImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefParameter;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRefParameterImpl
extends PhpRefElementImpl
implements PhpRefParameter {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private final int myIndex;

    public PhpRefParameterImpl(@NotNull Parameter parameter, @NotNull RefManager manager, int index, @NotNull PhpRefFunction refFunction) {
        if (parameter == null) {
            PhpRefParameterImpl.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PhpRefParameterImpl.$$$reportNull$$$0(1);
        }
        if (refFunction == null) {
            PhpRefParameterImpl.$$$reportNull$$$0(2);
        }
        super(parameter.getName(), (PhpPsiElement)parameter, manager);
        this.myIndex = index;
        ((RefEntityImpl)refFunction).add((RefEntity)this);
    }

    @NotNull
    public String getQualifiedName() {
        PhpNamedElement parameter = this.getPhpElement();
        String parameterFqn = parameter != null ? parameter.getFQN() : null;
        String string = (String)ObjectUtils.notNull((Object)parameterFqn, (Object)"");
        if (string == null) {
            PhpRefParameterImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void paramReferenced(boolean forWriting) {
        if (forWriting) {
            this.setUsedForWriting();
        } else {
            this.setUsedForReading();
        }
    }

    public boolean isPromotedField() {
        return false;
    }

    @Nullable
    public PhpNamedElement getPhpElement() {
        return (PhpNamedElement)super.getPhpElement(Parameter.class);
    }

    public boolean isUsedForReading() {
        return false;
    }

    public boolean isUsedForWriting() {
        return false;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public void attachMetaData(@NotNull RefElement declaration, @NotNull PhpRefMetaData data, @NotNull Key<Map<RefElement, PhpRefMetaData>> key) {
        Map metaMap;
        if (declaration == null) {
            PhpRefParameterImpl.$$$reportNull$$$0(4);
        }
        if (data == null) {
            PhpRefParameterImpl.$$$reportNull$$$0(5);
        }
        if (key == null) {
            PhpRefParameterImpl.$$$reportNull$$$0(6);
        }
        if ((metaMap = (Map)this.getUserData(key)) == null) {
            metaMap = new THashMap();
        }
        PhpRefMetaData previousData = metaMap.getOrDefault(declaration, data.getDefaultMeta());
        PhpRefMetaData currentData = previousData.apply(data);
        metaMap.put(declaration, currentData);
        this.putUserData(key, metaMap);
    }

    private void setUsedForWriting() {
        this.setFlag(true, 131072L);
    }

    private void setUsedForReading() {
        this.setFlag(true, 65536L);
    }

    public boolean isForReading() {
        return this.checkFlag(65536L);
    }

    public void setForReading(boolean forReading) {
        this.setFlag(forReading, 65536L);
    }

    public boolean isForWriting() {
        return this.checkFlag(131072L);
    }

    public void setForWriting(boolean forWriting) {
        this.setFlag(forWriting, 131072L);
    }

    @Override
    public void initialize() {
        PsiElement defaultValue;
        PhpNamedElement parameter = this.getPhpElement();
        WritableRefEntity refFunction = this.getOwner();
        if (parameter instanceof Parameter && refFunction instanceof PhpRefFunction && !((Parameter)parameter).isPromotedField() && ((defaultValue = ((Parameter)parameter).getDefaultValue()) instanceof ClassConstantReference || defaultValue instanceof ConstantReference)) {
            PhpRefUtil.addReferencesTo((PhpPsiElement)parameter, (RefElement)refFunction, defaultValue);
        }
    }

    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            PhpRefParameterImpl.$$$reportNull$$$0(7);
        }
        if (visitor instanceof PhpRefVisitor) {
            ReadAction.run(() -> ((PhpRefVisitor)visitor).visitRefParameter(this));
        } else {
            super.accept(visitor);
        }
    }

    @Nullable
    public static RefEntity parameterFromExternalName(@NotNull RefManagerImpl manager, @NotNull String fqName) {
        String method;
        RefEntity refFunctor;
        if (manager == null) {
            PhpRefParameterImpl.$$$reportNull$$$0(8);
        }
        if (fqName == null) {
            PhpRefParameterImpl.$$$reportNull$$$0(9);
        }
        if ((refFunctor = (RefEntity)ObjectUtils.chooseNotNull((Object)PhpRefMethodImpl.methodFromExternalName(manager, method = StringUtil.substringBeforeLast((String)fqName, (String)" ")), (Object)PhpRefFunctionImpl.functionFromExternalName(manager, method))) instanceof PhpRefFunction) {
            String paramName = StringUtil.substringAfterLast((String)fqName, (String)" ");
            Function function = ((PhpRefFunction)refFunctor).getPhpElement();
            if (function != null && !StringUtil.isEmpty((String)paramName)) {
                int order = 0;
                for (Parameter parameter : function.getParameters()) {
                    if (parameter.getName().equals(paramName)) {
                        return PhpRefManager.getInstance((RefManager)manager).createRefParameter(parameter, order, (PhpRefFunction)refFunctor);
                    }
                    ++order;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFunction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefParameterImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefParameterImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "attachMetaData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parameterFromExternalName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

