/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.elements;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMemberImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefParameter;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.MethodImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRefMethodImpl
extends PhpRefClassMemberImpl
implements PhpRefMethod {
    private static final int HAS_BODY_MASK = 65536;
    private static final int EMPTY_BODY_MASK = 131072;
    private static final int CLOSURE_MASK = 262144;
    private static final int CONSTRUCTOR_MASK = 524288;
    private static final int WITH_STATIC_CONSTRUCTOR = 0x100000;
    @Nullable
    private Set<PhpRefMethod> mySuperMethods;
    @Nullable
    private Set<PhpRefMethod> myDerivedMethods;
    private PhpRefParameter @NotNull [] myParameters;

    public PhpRefMethodImpl(@NotNull PhpRefClass phpClass, Method method, RefManager manager) {
        if (phpClass == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(0);
        }
        super(phpClass, (PhpClassMember)method, manager);
        this.myParameters = PhpRefParameter.EMPTY_ARRAY;
        if (method.getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
            this.setConstructor();
        }
    }

    public boolean isExternalOverride() {
        return false;
    }

    public synchronized void addSuperMethod(@NotNull PhpRefMethod refSuperMethod) {
        if (refSuperMethod == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(1);
        }
        this.mySuperMethods = this.addRefMemberTo(refSuperMethod, this.mySuperMethods);
    }

    public synchronized void markExtended(@NotNull PhpRefMethod method) {
        if (method == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(2);
        }
        this.myDerivedMethods = this.addRefMemberTo(method, this.myDerivedMethods);
    }

    @Override
    protected void initialize() {
        this.appendDirectSuperMembers(PhpRefMethodImpl.class, superRefMethod -> this.attachSuperMethod((PhpRefMethodImpl)((Object)superRefMethod)));
    }

    void attachSuperMethod(@NotNull PhpRefMethodImpl superRefMethod) {
        if (superRefMethod == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(3);
        }
        this.addSuperMethod(superRefMethod);
        superRefMethod.markExtended(this);
    }

    private synchronized void setParameters(PhpRefParameter @NotNull [] parameters) {
        if (parameters == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(4);
        }
        this.myParameters = parameters;
    }

    @NotNull
    public synchronized Collection<PhpRefMethod> getSuperMethods() {
        Collection collection = (Collection)ObjectUtils.notNull(this.mySuperMethods, Collections.emptySet());
        if (collection == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public synchronized Collection<PhpRefMethod> getDerivedMethods() {
        Collection collection = (Collection)ObjectUtils.notNull(this.myDerivedMethods, Collections.emptySet());
        if (collection == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private void setConstructor() {
        this.setFlag(true, 524288L);
        PhpRefClass refClass = this.getOwnerClass();
        if (refClass == null) {
            return;
        }
        refClass.setConstructor((PhpRefMethod)this);
    }

    public boolean isConstructor() {
        return this.checkFlag(524288L);
    }

    public void setHasBody() {
        this.setFlag(true, 65536L);
    }

    public void setEmptyBody() {
        this.setFlag(true, 131072L);
    }

    public boolean hasBody() {
        return this.checkFlag(65536L);
    }

    public boolean isBodyEmpty() {
        return this.checkFlag(131072L);
    }

    public void setClosure() {
        this.setFlag(true, 262144L);
    }

    public boolean isClosure() {
        return this.checkFlag(262144L);
    }

    public boolean isTest() {
        PhpRefClass refClass = this.getOwnerClass();
        return refClass != null && refClass.isTest();
    }

    public boolean isWithStaticConstructor() {
        return this.checkFlag(0x100000L);
    }

    public void setWithStaticConstructor() {
        this.setFlag(true, 0x100000L);
    }

    public synchronized PhpRefParameter @NotNull [] getParameters() {
        if (this.myParameters == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(7);
        }
        return this.myParameters;
    }

    @Nullable
    public Method getPhpElement() {
        return this.getPhpElement(Method.class);
    }

    @NotNull
    public Collection<? extends PhpRefClassMember> getDerivedMembers() {
        Collection<PhpRefMethod> collection = this.getDerivedMethods();
        if (collection == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends PhpRefClassMember> getSuperMembers() {
        Collection<PhpRefMethod> collection = this.getSuperMethods();
        if (collection == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Override
    public void buildReferences() {
        Method method;
        super.buildReferences();
        if (this.isConstructor()) {
            this.addOutReference((RefElement)this.getOwnerClass());
        }
        if ((method = this.getPhpElement()) instanceof MethodImpl) {
            this.setParameters(PhpRefUtil.initializeParameterList((PhpRefFunction)this, (Function)method));
            PhpRefUtil.attachTypeToDeclaration(method.getDocType(), (PhpPsiElement)method, this);
            PhpRefUtil.buildFunctorReferences((PhpRefFunction)this, (Function)method);
            this.buildReferencesInside((Consumer<? super PhpPsiElement>)((Consumer)this::buildInnerReference));
            PhpRefUtil.traversePhpUnitDocTagsForReferences(this, (PhpNamedElement)method);
        }
    }

    @Override
    public void referenceRemoved() {
        super.referenceRemoved();
        PhpRefUtil.runOnCollection(this::removeSuper, this.getSuperMethods().toArray(PhpRefMethod.EMPTY_ARRAY));
    }

    private synchronized void removeSuper(@NotNull PhpRefMethod superMethod) {
        if (superMethod == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(10);
        }
        this.removeRefMemberFrom(this, superMethod.getDerivedMethods());
        this.removeRefMemberFrom(superMethod, this.getSuperMethods());
    }

    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(11);
        }
        if (visitor instanceof PhpRefVisitor) {
            ReadAction.run(() -> ((PhpRefVisitor)visitor).visitRefMethod(this));
        } else {
            super.accept(visitor);
        }
    }

    @Nullable
    public static RefEntity methodFromExternalName(@NotNull RefManagerImpl manager, @NotNull String externalName) {
        List qualifiedPath;
        if (manager == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(12);
        }
        if (externalName == null) {
            PhpRefMethodImpl.$$$reportNull$$$0(13);
        }
        if ((qualifiedPath = StringUtil.split((String)externalName, (String)" ")).size() == 2) {
            PhpClass phpClass = PhpRefMethodImpl.classFromClassMemberExternalName(manager, qualifiedPath);
            return phpClass != null ? PhpRefUtil.getReferenceEx((PsiElement)phpClass.findOwnMethodByName((CharSequence)qualifiedPath.get(1)), manager) : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refSuperMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superRefMethod";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefMethodImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefMethodImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperMethods";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedMethods";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedMembers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addSuperMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "markExtended";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "attachSuperMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setParameters";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeSuper";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "methodFromExternalName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

