/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.elements;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElement;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElementImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefParameter;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRefFunctionImpl
extends PhpRefElementImpl
implements PhpRefFunction {
    private static final int HAS_BODY_MASK = 65536;
    private static final int EMPTY_BODY_MASK = 131072;
    private static final int CLOSURE_MASK = 262144;
    private static final int IMPLICITLY_USED_FROM_CORE = 524288;
    private PhpRefParameter @NotNull [] myParameters = PhpRefParameter.EMPTY_ARRAY;

    public PhpRefFunctionImpl(Function function, RefManager manager) {
        super(function.getFQN(), (PhpPsiElement)function, manager);
    }

    public void setHasBody() {
        this.setFlag(true, 65536L);
    }

    public void setEmptyBody() {
        this.setFlag(true, 131072L);
    }

    public boolean getImplicitlyUsed() {
        return this.checkFlag(524288L);
    }

    public void setImplicitlyUsed(int hash) {
        if (hash > 0) {
            this.setFlag(true, 524288L);
        }
    }

    public boolean hasBody() {
        return this.checkFlag(65536L);
    }

    public boolean isBodyEmpty() {
        return this.checkFlag(131072L);
    }

    public void setClosure() {
        this.setFlag(true, 262144L);
    }

    public boolean isClosure() {
        return this.checkFlag(262144L);
    }

    public synchronized PhpRefParameter @NotNull [] getParameters() {
        if (this.myParameters == null) {
            PhpRefFunctionImpl.$$$reportNull$$$0(0);
        }
        return this.myParameters;
    }

    private synchronized void setParameters(PhpRefParameter @NotNull [] parameters) {
        if (parameters == null) {
            PhpRefFunctionImpl.$$$reportNull$$$0(1);
        }
        this.myParameters = parameters;
    }

    @Override
    protected void initialize() {
    }

    @Nullable
    public Function getPhpElement() {
        return super.getPhpElement(Function.class);
    }

    public void attachMetaData(PhpReference reference, PhpRefElement declaration) {
    }

    @Override
    public void buildReferences() {
        super.buildReferences();
        Function function = this.getPhpElement();
        if (function instanceof FunctionImpl) {
            this.setParameters(PhpRefUtil.initializeParameterList(this, function));
            PhpRefUtil.attachTypeToDeclaration(function.getDocType(), (PhpPsiElement)function, this);
            PhpRefUtil.buildFunctorReferences(this, function);
            PhpRefUtil.attachRefToOuter((RefManager)this.getRefManager(), (PhpPsiElement)function, this);
            this.buildReferencesInside((Consumer<? super PhpPsiElement>)((Consumer)this::buildInnerReference));
        }
    }

    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            PhpRefFunctionImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof PhpRefVisitor) {
            ReadAction.run(() -> ((PhpRefVisitor)visitor).visitRefFunction(this));
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.isClosure() ? "\u03bb" : super.getQualifiedName();
        if (string == null) {
            PhpRefFunctionImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static RefEntity functionFromExternalName(@NotNull RefManagerImpl manager, @NotNull String fqn) {
        if (manager == null) {
            PhpRefFunctionImpl.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            PhpRefFunctionImpl.$$$reportNull$$$0(5);
        }
        return PhpRefUtil.getReferenceEx((PsiElement)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)manager.getProject()).getFunctionsByFQN(fqn)), manager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefFunctionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefFunctionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setParameters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "functionFromExternalName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

